/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.followlist.ui;

import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.data.PageData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.R;
import com.yy.hiyo.relation.base.fans.FansUserDetails;
import com.yy.hiyo.relation.base.widget.BaseListEmptyView;
import com.yy.hiyo.relation.base.widget.BaseListWindow;
import com.yy.hiyo.relation.followlist.FollowListMvp;
import com.yy.hiyo.relation.followlist.FollowListPresenter;
import com.yy.hiyo.relation.followlist.ui.FollowViewHolder;
import com.yy.hiyo.relation.hiido.FollowStatisHelper;
import com.yy.hiyo.user.base.NavigationUtils;
import me.drakeet.multitype.ItemViewBinder;

public class FollowListWindow
extends BaseListWindow
implements FollowListMvp.IView {
    private FollowListMvp.IPresenter mFollowListPresenter;
    private FansUserDetails mToProfilePageUser;

    public FollowListWindow(IMvpContext mvpContext, UICallBacks callBacks, long uid, String roomId) {
        super(mvpContext, callBacks, "FollowListWindow");
        this.mFollowListPresenter = new FollowListPresenter(mvpContext, this, uid, roomId);
        this.initDataObserve();
    }

    private void initDataObserve() {
        this.mFollowListPresenter.listCount().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                FollowListWindow.this.setListCount(integer);
            }
        });
        this.mFollowListPresenter.nextPage().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<PageData<FansUserDetails>>(){

            public void onChanged(@Nullable PageData<FansUserDetails> followUserDetailsPageData) {
                FollowListWindow.this.setPageData(followUserDetailsPageData);
            }
        });
    }

    protected void onInitData() {
        this.mFollowListPresenter.onFollowListRefresh();
    }

    protected void onRegisterViewHolder() {
        super.onRegisterViewHolder();
        this.mAdapter.register(FansUserDetails.class, (ItemViewBinder)FollowViewHolder.getItemBinder(new FollowViewHolder.OnItemActionListener(){

            @Override
            public void onStatusClicked(FansUserDetails followUserDetails) {
                FollowListWindow.this.mFollowListPresenter.onFansStatusClicked(followUserDetails);
            }

            @Override
            public void onItemClicked(FansUserDetails followUserDetails) {
                UserInfoKS userInfoKS = followUserDetails.getUserInfoKS();
                if (userInfoKS == null) {
                    return;
                }
                MLog.info((Object)"FollowListWindow", (String)"open profile window:%s", (Object[])new Object[]{userInfoKS.uid});
                String roomId = FollowListWindow.this.mFollowListPresenter.getRoomId();
                NavigationUtils.navigateToProfilePage((long)userInfoKS.uid, (String)roomId);
                FollowListWindow.this.mToProfilePageUser = followUserDetails;
                FollowStatisHelper.reportFollowItemClick();
            }
        }));
    }

    public void onShown() {
        super.onShown();
        FollowStatisHelper.reportFollowListShow();
    }

    protected void onListRefresh() {
        this.mFollowListPresenter.onFollowListRefresh();
    }

    protected void onListLoadmore() {
        this.mFollowListPresenter.onFollowListLoadmore();
    }

    protected void onInitEmpty(BaseListEmptyView emptyView) {
        emptyView.setInfo(R.drawable.img_list_empty, ResourceUtils.getString((int)R.string.short_title_no_follow_title), ResourceUtils.getString((int)R.string.tips_no_follow_tips));
    }

    @Override
    public void clearStatus() {
        this.clearListStatus();
    }
}

