/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.followlist;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.PageData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.fans.FansUserDetails;
import com.yy.hiyo.relation.followlist.FollowListModel;
import com.yy.hiyo.relation.followlist.FollowListMvp;
import com.yy.hiyo.relation.hiido.FollowStatisHelper;

public class FollowListPresenter
extends BasePresenter<IMvpContext>
implements FollowListMvp.IPresenter {
    private MutableLiveData<PageData<FansUserDetails>> nextPageData = new MutableLiveData();
    private MutableLiveData<Integer> listTotalData = new MutableLiveData();
    private FollowListMvp.IModel followListMode;
    private FollowListMvp.IView followListView;
    private String roomId;
    private DialogLinkManager mDialogLinkManager;

    public FollowListPresenter(IMvpContext mvpContext, FollowListMvp.IView view, long uid, String roomId) {
        super(mvpContext);
        this.roomId = roomId;
        this.followListView = view;
        this.followListMode = new FollowListModel(uid);
    }

    @Override
    public void onFollowListRefresh() {
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u5217\u8868\u5237\u65b0", (Object[])new Object[0]);
        this.followListMode.listRefresh((ICommonCallback)new ICommonCallback<PageData<FansUserDetails>>(){

            public void onSuccess(PageData<FansUserDetails> data, Object ... ext) {
                FollowListPresenter.this.followListView.clearStatus();
                FollowListPresenter.this.listTotalData.setValue((Object)data.getTotal());
                FollowListPresenter.this.nextPageData.setValue(data);
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u5217\u8868\u5237\u65b0\u6210\u529f, %s", (Object[])new Object[]{data});
            }

            public void onFail(int code, String msg, Object ... ext) {
                FollowListPresenter.this.followListView.clearStatus();
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u7c7b\u8868\u5237\u65b0\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        }, false);
    }

    @Override
    public void onFollowListLoadmore() {
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875", (Object[])new Object[0]);
        this.followListMode.listNextPage((ICommonCallback)new ICommonCallback<PageData<FansUserDetails>>(){

            public void onSuccess(PageData<FansUserDetails> data, Object ... ext) {
                FollowListPresenter.this.followListView.clearStatus();
                FollowListPresenter.this.nextPageData.setValue(data);
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u6210\u529f, %s", (Object[])new Object[]{data});
            }

            public void onFail(int code, String msg, Object ... ext) {
                FollowListPresenter.this.followListView.clearStatus();
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    @Override
    public void onFansStatusClicked(final FansUserDetails followUserDetails) {
        if (followUserDetails == null) {
            return;
        }
        if (followUserDetails.getUserInfoKS() == null) {
            return;
        }
        this.followListMode.onFansStatusClicked(this.getDialogLinkManager(), followUserDetails, new OkCancelDialogListener(){

            public void onCancel() {
                FollowStatisHelper.reportUnfollowCancelClick(followUserDetails.getUserInfoKS().uid, FollowListPresenter.this.roomId, 4);
            }

            public void onOk() {
                FollowStatisHelper.reportUnfollowOkClick(followUserDetails.getUserInfoKS().uid, FollowListPresenter.this.roomId, 4);
            }
        });
        RelationInfo mRelation = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(followUserDetails.getUserInfoKS().uid);
        if (mRelation.isFollow()) {
            FollowStatisHelper.reportUnfollowClick(followUserDetails.getUserInfoKS().uid, this.roomId, 4);
            FollowStatisHelper.reportUnfollowPop();
        } else {
            FollowStatisHelper.reportUnfollowClick(followUserDetails.getUserInfoKS().uid, this.roomId, 4);
            FollowStatisHelper.reportUnfollowPop();
        }
    }

    @Override
    public LiveData<PageData<FansUserDetails>> nextPage() {
        return this.nextPageData;
    }

    @Override
    public LiveData<Integer> listCount() {
        return this.listTotalData;
    }

    @Override
    public String getRoomId() {
        return this.roomId;
    }

    private DialogLinkManager getDialogLinkManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.getMvpContext().getContext());
        }
        return this.mDialogLinkManager;
    }
}

