/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.followlist;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import biz.CInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.VersionData;
import com.yy.appbase.data.PageData;
import com.yy.appbase.datacenter.DataCenter;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.recommend.bean.ChannelBase;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.relation.base.data.DataSource;
import com.yy.hiyo.relation.base.data.IRelationRepository;
import com.yy.hiyo.relation.base.fans.FansUserDetails;
import com.yy.hiyo.relation.data.RelationRepository;
import com.yy.hiyo.relation.followlist.FollowHandler;
import com.yy.hiyo.relation.followlist.FollowListMvp;
import com.yy.hiyo.relation.proto.ProtoHelper;
import common.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.ihago.channel.srv.follow.ChannelFollowInfo;
import net.ihago.channel.srv.follow.GetFollowListReq;
import net.ihago.channel.srv.follow.GetFollowListRes;
import net.ihago.room.srv.follow.FollowUserInfo;
import net.ihago.room.srv.follow.PullFollowListReq;
import net.ihago.room.srv.follow.PullFollowListRes;
import org.jetbrains.annotations.NotNull;

public class FollowListModel
implements FollowListMvp.IModel {
    private static final String TAG = "FollowListModel";
    private long uid;
    private List<FollowUserInfo> followUidList;
    private List<ChannelFollowInfo> followCidList;
    private int pageSize = 50;
    private int pageIndex = 0;
    private Page mPage = null;
    private long mCursor = 0L;
    private FollowHandler mFollowHandler;
    private boolean requestedChannel = false;
    private boolean mNeedRequstChannel = true;
    private VersionData<PullFollowListRes> followListData = new VersionData();

    public FollowListModel(long uid) {
        this.uid = uid;
    }

    public void setNeedRequstChannel(boolean needRequstChannel) {
        this.mNeedRequstChannel = needRequstChannel;
    }

    public void listRefresh(final ICommonCallback<PageData<FansUserDetails>> callback, boolean saveTimestamp) {
        this.requestFollowUserListData(this.uid, new IFollowProtoCallback<PullFollowListRes>(){

            public void onSuccess(@NotNull PullFollowListRes data) {
                FollowListModel.this.pageSize = FP.orInt((Long)data.page_size);
                FollowListModel.this.followUidList = data.users;
                FollowListModel.this.pageIndex = 0;
                FollowListModel.this.requestPageData(0, (ICommonCallback<PageData<FansUserDetails>>)callback);
                MLog.info((Object)FollowListModel.TAG, (String)("listRefresh size:" + FollowListModel.this.pageSize), (Object[])new Object[0]);
            }

            public void onFail(int code, String msg) {
                ProtoHelper.INSTANCE.handleOnFailInMain(callback, code, msg);
            }
        });
    }

    public void listNextPage(ICommonCallback<PageData<FansUserDetails>> callback) {
        int reqPageIndex = this.pageIndex + 1;
        if (this.requestedChannel) {
            this.requestFollowChannelListData(this.uid, reqPageIndex, null, callback);
        } else {
            this.requestPageData(reqPageIndex, callback);
        }
    }

    private void requestPageData(int reqPageIndex, ICommonCallback<PageData<FansUserDetails>> callback) {
        ArrayList<FollowUserInfo> pageFollowUserList = new ArrayList<FollowUserInfo>();
        PageData pageData = new PageData();
        pageData.setPageIndex(reqPageIndex);
        if (this.followUidList != null && this.followUidList.size() > 0) {
            int index;
            int startIndex = reqPageIndex * this.pageSize;
            int endIndex = startIndex + this.pageSize;
            for (index = startIndex; index < this.followUidList.size() && index < endIndex; ++index) {
                FollowUserInfo followUserInfo = this.followUidList.get(index);
                if (followUserInfo == null) continue;
                pageFollowUserList.add(followUserInfo);
            }
            if (index < this.followUidList.size()) {
                pageData.setHasNextPage(true);
            } else {
                pageData.setHasNextPage(false);
            }
            pageData.setTotal(this.followUidList.size());
        } else {
            pageData.setHasNextPage(false);
            pageData.setTotal(0);
        }
        this.requestPageDataUserDetails((PageData<FansUserDetails>)pageData, pageFollowUserList, callback);
    }

    private void requestPageDataUserDetails(final PageData<FansUserDetails> pageData, final List<FollowUserInfo> pageFollowList, final ICommonCallback<PageData<FansUserDetails>> callback) {
        this.requestedChannel = false;
        if (pageFollowList != null && pageFollowList.size() > 0) {
            ArrayList<Long> uidList = new ArrayList<Long>();
            for (FollowUserInfo followUserInfo : pageFollowList) {
                uidList.add(followUserInfo.uid);
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    ArrayList<FansUserDetails> followUserDetailsList = new ArrayList<FansUserDetails>();
                    HashMap<Long, UserInfoKS> userInfoMap = new HashMap<Long, UserInfoKS>();
                    if (userInfoKSList != null) {
                        for (UserInfoKS userInfoKS : userInfoKSList) {
                            if (userInfoKS == null) continue;
                            userInfoMap.put(userInfoKS.uid, userInfoKS);
                        }
                    }
                    for (FollowUserInfo followUserInfo : pageFollowList) {
                        UserInfoKS userInfoKS = (UserInfoKS)userInfoMap.get(followUserInfo.uid);
                        if (userInfoKS == null) continue;
                        FansUserDetails userDetails = new FansUserDetails();
                        userDetails.setUserInfoKS(userInfoKS);
                        userDetails.setUserFrom(followUserInfo.path.intValue());
                        followUserDetailsList.add(userDetails);
                    }
                    pageData.setData(followUserDetailsList);
                    FollowListModel.this.pageIndex = pageData.getPageIndex();
                    if (!pageData.isHasNextPage()) {
                        FollowListModel.this.requestFollowChannelListData(FollowListModel.this.uid, FollowListModel.this.pageIndex, (PageData<FansUserDetails>)pageData, (ICommonCallback<PageData<FansUserDetails>>)callback);
                    } else {
                        ProtoHelper.INSTANCE.handleOnSuccessInMain(callback, pageData, new Object[0]);
                    }
                }

                public void onFail(int id2, String msg, String response) {
                    ProtoHelper.INSTANCE.handleOnFailInMain(callback, 5000, msg);
                }

                public int id() {
                    return 0;
                }
            });
        } else {
            this.pageIndex = pageData.getPageIndex();
            if (!pageData.isHasNextPage()) {
                this.requestFollowChannelListData(this.uid, this.pageIndex, pageData, callback);
            } else {
                ProtoHelper.INSTANCE.handleOnSuccessInMain(callback, pageData, new Object[0]);
            }
        }
    }

    private void requestFollowUserListData(final long uid, final IFollowProtoCallback<PullFollowListRes> callback) {
        boolean net = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        MLog.info((Object)TAG, (String)"requestFollowUserListData, uid= %d, net: %b", (Object[])new Object[]{uid, net});
        if (!net) {
            ProtoHelper.INSTANCE.handleOnFail(callback, 250, "network is invalid");
            return;
        }
        final long startTime = SystemClock.uptimeMillis();
        PullFollowListReq req = new PullFollowListReq.Builder().uid(Long.valueOf(uid)).version(Long.valueOf(this.followListData.getVersion())).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<PullFollowListRes>(){

            public void onResponse(@Nullable PullFollowListRes message) {
                long useTime = SystemClock.uptimeMillis() - startTime;
                if (message == null) {
                    ProtoHelper.INSTANCE.statMetric("follow/followlist", useTime, false, 5002L);
                    ProtoHelper.INSTANCE.handleOnFail(callback, 5002, "result is null");
                } else if (ProtoHelper.INSTANCE.isFail(message.err)) {
                    ProtoHelper.INSTANCE.statMetric("follow/followlist", useTime, false, FP.orInt((Long)message.err.code));
                    ProtoHelper.INSTANCE.handleOnFail(callback, FP.orInt((Long)message.err.code), message.err.tips);
                } else {
                    ProtoHelper.INSTANCE.statMetric("follow/followlist", useTime, true, 0L);
                    if (message.version.longValue() == FollowListModel.this.followListData.getVersion()) {
                        FollowListModel.this.followListData.setVersion(message.version.longValue());
                        ProtoHelper.INSTANCE.handleOnSuccess(callback, FollowListModel.this.followListData.getData());
                    } else {
                        YYTaskExecutor.execute(() -> FollowListModel.this.updateRelation(message));
                        FollowListModel.this.followListData.setVersion(message.version.longValue());
                        FollowListModel.this.followListData.setData((Object)message);
                        ProtoHelper.INSTANCE.handleOnSuccess(callback, message);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)FollowListModel.TAG, (String)"requestFollowUserListData, uid=%s, timeout", (Object[])new Object[]{uid});
                ProtoHelper.INSTANCE.statMetric("follow/followlist", SystemClock.uptimeMillis() - startTime, false, 99L);
                ProtoHelper.INSTANCE.handleOnFail(callback, 5001, "request timeout");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)FollowListModel.TAG, (String)"requestFollowUserListData, uid=%s, error code=%d, reason=%s", (Object[])new Object[]{uid, code, reason});
                ProtoHelper.INSTANCE.statMetric("follow/followlist", SystemClock.uptimeMillis() - startTime, false, code);
                ProtoHelper.INSTANCE.handleOnFail(callback, code, reason);
                return false;
            }
        });
    }

    private void requestFollowChannelListData(long uid, int reqPageIndex, final PageData<FansUserDetails> pageData, final ICommonCallback<PageData<FansUserDetails>> callback) {
        MLog.info((Object)TAG, (String)"requestFollowChannelListData, uid= %d,mNeedRequstChannel = %s", (Object[])new Object[]{uid, this.mNeedRequstChannel});
        if (!this.mNeedRequstChannel) {
            ProtoHelper.INSTANCE.handleOnSuccessInMain(callback, pageData, new Object[0]);
            return;
        }
        if (reqPageIndex == 0 || !this.requestedChannel || this.mPage == null) {
            this.mPage = new Page(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L));
        }
        this.requestedChannel = true;
        PageData<FansUserDetails> temp = new PageData<FansUserDetails>();
        temp.setPageIndex(reqPageIndex);
        final PageData<FansUserDetails> newPageData = pageData == null ? temp : pageData;
        CInfo cInfo = new CInfo.Builder().cid("1").room_avatar("1").name("1").owner(Long.valueOf(1L)).carousel_type(Integer.valueOf(1)).build();
        GetFollowListReq req = new GetFollowListReq.Builder().uid(Long.valueOf(uid)).page(this.mPage).cursor(Long.valueOf(this.mCursor)).with_cinfo(Boolean.valueOf(true)).selector(cInfo).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetFollowListRes>(){

            public void onResponse(@NonNull @NotNull GetFollowListRes res, long code, String msgTip) {
                MLog.info((Object)FollowListModel.TAG, (String)"requestFollowChannelListData,onResponse, code=%s, msg=$s", (Object[])new Object[]{code, msgTip});
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    FollowListModel.this.mPage = res.page;
                    FollowListModel.this.mCursor = res.cursor;
                    pageData.setHasNextPage(((FollowListModel)FollowListModel.this).mPage.offset < ((FollowListModel)FollowListModel.this).mPage.total);
                    ArrayList<FansUserDetails> channels = new ArrayList<FansUserDetails>();
                    if (!FP.empty((Collection)newPageData.getData())) {
                        channels.addAll(newPageData.getData());
                    }
                    if (!FP.empty((Collection)res.channels)) {
                        for (ChannelFollowInfo info : res.channels) {
                            channels.add(FollowListModel.this.convertCinfo(info.cinfo));
                        }
                        pageData.setData(channels);
                    }
                }
                ProtoHelper.INSTANCE.handleOnSuccessInMain(callback, pageData, new Object[0]);
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.info((Object)FollowListModel.TAG, (String)"requestFollowChannelListData,onError,code=%s, msg=$s", (Object[])new Object[]{code, reason});
                ProtoHelper.INSTANCE.handleOnFailInMain(callback, 5000, reason);
            }
        });
    }

    private FansUserDetails convertCinfo(CInfo cInfo) {
        FansUserDetails userDetails = new FansUserDetails();
        ChannelBase channelBase = new ChannelBase(cInfo.cid);
        channelBase.setChannelAvatar(cInfo.room_avatar);
        channelBase.setOwnerUid(cInfo.owner.longValue());
        channelBase.setName(cInfo.name);
        channelBase.setCarouselType(cInfo.carousel_type.intValue());
        userDetails.setChannelInfo(channelBase);
        return userDetails;
    }

    public void onFansStatusClicked(@NotNull DialogLinkManager dialogLinkManager2, @org.jetbrains.annotations.Nullable FansUserDetails followUserDetails, @org.jetbrains.annotations.Nullable OkCancelDialogListener dialogListener) {
        if (this.mFollowHandler == null) {
            this.mFollowHandler = new FollowHandler();
        }
        this.mFollowHandler.onFansStatusClicked(dialogLinkManager2, followUserDetails, dialogListener);
    }

    private void updateRelation(PullFollowListRes message) {
        if (message == null || FP.empty((Collection)message.users)) {
            return;
        }
        IRelationRepository iRep = (IRelationRepository)DataCenter.INSTANCE.getRepository(IRelationRepository.class);
        if (iRep instanceof RelationRepository) {
            RelationRepository repository = (RelationRepository)iRep;
            for (FollowUserInfo info : message.users) {
                repository.updateRelation((long)info.uid, info.relation.intValue(), DataSource.NET, (int)info.path);
            }
        }
    }
}

