/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.followlist;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.PageMvpContext;
import com.yy.hiyo.relation.R;
import com.yy.hiyo.relation.base.follow.FollowMsgDef;
import com.yy.hiyo.relation.followlist.ui.FollowListUiCallback;
import com.yy.hiyo.relation.followlist.ui.FollowListWindow;

public class FollowListController
extends DefaultController
implements FollowListUiCallback {
    public FollowListController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg.what == FollowMsgDef.OPEN_FOLLOW_LIST) {
            Bundle bundle = msg.getData();
            long uid = AccountUtil.getUid();
            String roomId = "";
            if (bundle != null) {
                uid = bundle.getLong("uid", AccountUtil.getUid());
                roomId = bundle.getString("room_id", "");
            }
            this.openFollowList(uid, roomId);
        }
    }

    private void openFollowList(long uid, String roomId) {
        FollowListWindow followFollowListWindow = new FollowListWindow((IMvpContext)PageMvpContext.Companion.of((Context)this.getActivity()), (UICallBacks)this, uid, roomId);
        followFollowListWindow.initDatas();
        this.mWindowMgr.pushWindow((AbstractWindow)followFollowListWindow, true);
    }

    public String getWindowTitle() {
        return ResourceUtils.getString((int)R.string.short_title_follow_list_title);
    }

    public void closeListWindow(AbstractWindow window) {
        if (window == null) {
            return;
        }
        this.mWindowMgr.popWindow(true, window);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
    }
}

