/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.fanslist.ui;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.R;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.user.UserBBSMedalInfo;
import com.yy.appbase.user.UserMedalBubbleUtil;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.relation.R;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.fans.FansUserDetails;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import java.util.List;
import net.ihago.medal.srv.mgr.MedalInfo;
import net.ihago.uinfo.api.uinfo.ESexType;
import org.jetbrains.annotations.NotNull;

public class FansViewHolder
extends BaseItemBinder.ViewHolder<FansUserDetails>
implements View.OnClickListener {
    private CircleImageView mAvatar;
    private YYTextView mNickName;
    private YYTextView mTvUserAge;
    private YYTextView mTvUserAddress;
    private FollowView mFollowView;
    private RecycleImageView mBBSLogo;
    private YYRelativeLayout mRlInfo;
    private OnItemActionListener mItemActionListener;
    private KvoBinder mBinder = new KvoBinder((Object)this);
    private UserBBSMedalInfo mMedalInfo;

    public FansViewHolder(View itemView) {
        super(itemView);
        this.mAvatar = (CircleImageView)itemView.findViewById(R.id.avatar);
        this.mNickName = (YYTextView)itemView.findViewById(R.id.nick_name);
        this.mTvUserAge = (YYTextView)itemView.findViewById(R.id.tv_user_age);
        this.mTvUserAddress = (YYTextView)itemView.findViewById(R.id.tv_user_address);
        this.mFollowView = (FollowView)itemView.findViewById(R.id.follow_view);
        this.mRlInfo = (YYRelativeLayout)itemView.findViewById(R.id.rl_info);
        this.mBBSLogo = (RecycleImageView)itemView.findViewById(R.id.flic_bbs_logo);
        this.mFollowView.setBoldStyle();
        this.mFollowView.setClickInterceptor(new IFollowClickInterceptor(){

            public boolean interceptor(@NotNull RelationInfo followStatus) {
                if (FansViewHolder.this.mItemActionListener != null) {
                    FansViewHolder.this.mItemActionListener.onStatusClicked((FansUserDetails)FansViewHolder.this.getData());
                }
                return true;
            }
        });
        this.mRlInfo.setOnClickListener((View.OnClickListener)this);
        this.mBBSLogo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserMedalBubbleUtil.showBubble((View)FansViewHolder.this.mBBSLogo);
            }
        });
    }

    public void setData(FansUserDetails data) {
        super.setData((Object)data);
        if (data == null) {
            return;
        }
        UserInfoKS userInfoKS = data.getUserInfoKS();
        if (userInfoKS != null) {
            String avatarUrl = userInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75);
            ImageLoader.loadImage((ImageView)this.mAvatar, (String)avatarUrl, (int)0, (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex));
            this.mNickName.setText((CharSequence)userInfoKS.nick);
            LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.mTvUserAge, (int)(userInfoKS.sex == ESexType.ESTFemale.getValue() ? R.drawable.icon_female : R.drawable.icon_male), (int)0, (int)0, (int)0);
            this.mTvUserAge.setBackgroundResource(userInfoKS.sex == ESexType.ESTFemale.getValue() ? R.drawable.bg_profile_sex_female : R.drawable.bg_profile_sex_male);
            this.mTvUserAge.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%d", (Object[])new Object[]{DateUtils.getAge((String)userInfoKS.birthday)}));
            if (userInfoKS.hideLocation == 1L) {
                this.mTvUserAddress.setVisibility(8);
            } else {
                this.mTvUserAddress.setVisibility(0);
                if (!TextUtils.isEmpty((CharSequence)userInfoKS.lastLoginLocation)) {
                    this.mTvUserAddress.setText((CharSequence)userInfoKS.lastLoginLocation);
                } else {
                    this.mTvUserAddress.setText((CharSequence)ResourceUtils.getString((int)R.string.profile_no_location));
                }
            }
            this.mMedalInfo = UserBBSMedalInfo.info((long)userInfoKS.uid);
            this.mBinder.singleBindSourceTo((KvoSource)this.mMedalInfo);
            this.mFollowView.bindFollowStatus(userInfoKS.uid);
        }
    }

    public void onViewAttach() {
        super.onViewAttach();
        if (this.mMedalInfo != null) {
            this.mBinder.singleBindSourceTo((KvoSource)this.mMedalInfo);
        }
    }

    public void onViewDetach() {
        super.onViewDetach();
        this.mBinder.clearAllKvoConnections();
        this.mMedalInfo = null;
    }

    @KvoMethodAnnotation(name="medalInfoList", sourceClass=UserBBSMedalInfo.class, thread=1)
    public void onUserBBSMedal(KvoEventIntent kvoEvent) {
        List medalInfoList = (List)kvoEvent.newValue();
        if (medalInfoList == null || medalInfoList.isEmpty()) {
            this.mBBSLogo.setVisibility(8);
        } else {
            this.mBBSLogo.setVisibility(0);
            ImageLoader.loadImage((ImageView)this.mBBSLogo, (String)((MedalInfo)medalInfoList.get((int)0)).url);
        }
    }

    public void setItemActionListener(OnItemActionListener itemActionListener) {
        this.mItemActionListener = itemActionListener;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.rl_info && this.mItemActionListener != null) {
            this.mItemActionListener.onItemClicked((FansUserDetails)this.getData());
        }
    }

    public static BaseItemBinder getItemBinder(final OnItemActionListener statusClickListener) {
        return new BaseItemBinder<FansUserDetails, FansViewHolder>(){

            @NonNull
            protected FansViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View itemView = inflater.inflate(R.layout.follow_list_item_channel, parent, false);
                FansViewHolder fansViewHolder = new FansViewHolder(itemView);
                fansViewHolder.setItemActionListener(statusClickListener);
                return fansViewHolder;
            }
        };
    }

    public static interface OnItemActionListener {
        public void onStatusClicked(FansUserDetails var1);

        public void onItemClicked(FansUserDetails var1);
    }
}

