/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.fanslist.ui;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.data.PageData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.R;
import com.yy.hiyo.relation.base.fans.FansUserDetails;
import com.yy.hiyo.relation.base.widget.BaseListEmptyView;
import com.yy.hiyo.relation.base.widget.BaseListWindow;
import com.yy.hiyo.relation.fanslist.FansListMvp;
import com.yy.hiyo.relation.fanslist.FansListPresenter;
import com.yy.hiyo.relation.fanslist.ui.FansViewHolder;
import com.yy.hiyo.relation.hiido.FollowStatisHelper;
import com.yy.hiyo.user.base.NavigationUtils;
import me.drakeet.multitype.ItemViewBinder;

@SuppressLint(value={"ViewConstructor"})
public class FansListWindow
extends BaseListWindow
implements FansListMvp.IView {
    private FansListMvp.IPresenter fansListPresenter;
    private FansUserDetails mToProfilePageUser;
    private String mRoomId;

    public FansListWindow(IMvpContext mvpContext, UICallBacks callBacks, long uid, String roomId) {
        super(mvpContext, callBacks, "FansListWindow");
        this.mRoomId = roomId;
        this.fansListPresenter = new FansListPresenter(this.getMvpContext(), this, uid, roomId);
        this.initDataObserve();
    }

    private void initDataObserve() {
        this.fansListPresenter.listCount().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                FansListWindow.this.setListCount(integer);
            }
        });
        this.fansListPresenter.nextPage().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<PageData<FansUserDetails>>(){

            public void onChanged(@Nullable PageData<FansUserDetails> fansUserDetailsPageData) {
                FansListWindow.this.setPageData(fansUserDetailsPageData);
            }
        });
    }

    protected void onInitData() {
        this.fansListPresenter.onFansListRefresh();
    }

    protected void onRegisterViewHolder() {
        super.onRegisterViewHolder();
        this.mAdapter.register(FansUserDetails.class, (ItemViewBinder)FansViewHolder.getItemBinder(new FansViewHolder.OnItemActionListener(){

            @Override
            public void onStatusClicked(FansUserDetails fansUserDetails) {
                FansListWindow.this.fansListPresenter.onFansStatusClicked(fansUserDetails);
            }

            @Override
            public void onItemClicked(FansUserDetails fansUserDetails) {
                UserInfoKS userInfoKS = fansUserDetails.getUserInfoKS();
                if (userInfoKS == null) {
                    return;
                }
                MLog.info((Object)"FansListWindow", (String)"open profile window:%s", (Object[])new Object[]{userInfoKS.uid});
                NavigationUtils.navigateToProfilePage((long)userInfoKS.uid, (String)FansListWindow.this.mRoomId);
                FansListWindow.this.mToProfilePageUser = fansUserDetails;
                FollowStatisHelper.reportFansItemClick();
            }
        }));
    }

    public void onShown() {
        super.onShown();
        FollowStatisHelper.reportFansListShow();
    }

    protected void onListRefresh() {
        this.fansListPresenter.onFansListRefresh();
    }

    protected void onListLoadmore() {
        this.fansListPresenter.onFansListLoadmore();
    }

    protected void onInitEmpty(BaseListEmptyView emptyView) {
        emptyView.setInfo(R.drawable.img_list_empty, ResourceUtils.getString((int)R.string.short_title_no_fans_title), ResourceUtils.getString((int)R.string.tips_channel_no_fans_tips));
    }

    @Override
    public void clearStatus() {
        this.clearListStatus();
    }
}

