/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.fanslist;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.PageData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.fans.FansUserDetails;
import com.yy.hiyo.relation.base.fans.IFansModel;
import com.yy.hiyo.relation.base.friend.IFriendServices;
import com.yy.hiyo.relation.fanslist.FansListMvp;
import com.yy.hiyo.relation.hiido.FollowStatisHelper;

public class FansListPresenter
extends BasePresenter<IMvpContext>
implements FansListMvp.IPresenter {
    private MutableLiveData<PageData<FansUserDetails>> nextPageData = new MutableLiveData();
    private MutableLiveData<Integer> listTotalData = new MutableLiveData();
    private IFansModel fansListModel;
    private FansListMvp.IView fansListView;
    private String mRoomId;
    private DialogLinkManager mDialogLinkManager;

    public FansListPresenter(IMvpContext mvpContext, FansListMvp.IView view, long uid, String roomId) {
        super(mvpContext);
        this.mRoomId = roomId;
        this.fansListView = view;
        this.fansListModel = ((IFriendServices)ServiceManagerProxy.getInstance().getService(IFriendServices.class)).createFansModel(AccountUtil.getUid());
    }

    @Override
    public void onFansListRefresh() {
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u7c89\u4e1d\u5217\u8868\u5237\u65b0", (Object[])new Object[0]);
        this.fansListModel.listRefresh((ICommonCallback)new ICommonCallback<PageData<FansUserDetails>>(){

            public void onSuccess(PageData<FansUserDetails> data, Object ... ext) {
                FansListPresenter.this.fansListView.clearStatus();
                FansListPresenter.this.nextPageData.setValue(data);
                FansListPresenter.this.listTotalData.setValue((Object)data.getTotal());
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u7c89\u4e1d\u5217\u8868\u5237\u65b0\u6210\u529f, %s", (Object[])new Object[]{data});
            }

            public void onFail(int code, String msg, Object ... ext) {
                FansListPresenter.this.fansListView.clearStatus();
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u7c89\u4e1d\u5217\u8868\u5237\u65b0\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        }, false);
    }

    @Override
    public void onFansListLoadmore() {
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u7c89\u4e1d\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875", (Object[])new Object[0]);
        this.fansListModel.listNextPage((ICommonCallback)new ICommonCallback<PageData<FansUserDetails>>(){

            public void onSuccess(PageData<FansUserDetails> data, Object ... ext) {
                FansListPresenter.this.fansListView.clearStatus();
                FansListPresenter.this.nextPageData.setValue(data);
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u7c89\u4e1d\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u6210\u529f, %s", (Object[])new Object[]{data});
            }

            public void onFail(int code, String msg, Object ... ext) {
                FansListPresenter.this.fansListView.clearStatus();
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u7c89\u4e1d\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    @Override
    public void onFansStatusClicked(final FansUserDetails fansUserDetails) {
        if (fansUserDetails == null) {
            return;
        }
        if (fansUserDetails.getUserInfoKS() == null) {
            return;
        }
        this.fansListModel.onFansStatusClicked(this.getDialogLinkManager(), fansUserDetails, new OkCancelDialogListener(){

            public void onCancel() {
                FollowStatisHelper.reportUnfollowCancelClick(fansUserDetails.getUserInfoKS().uid, FansListPresenter.this.mRoomId, 3);
            }

            public void onOk() {
                FollowStatisHelper.reportUnfollowOkClick(fansUserDetails.getUserInfoKS().uid, FansListPresenter.this.mRoomId, 3);
            }
        });
        RelationInfo mRelation = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(fansUserDetails.getUserInfoKS().uid);
        if (mRelation.isFollow()) {
            FollowStatisHelper.reportUnfollowClick(fansUserDetails.getUserInfoKS().uid, this.mRoomId, 3);
            FollowStatisHelper.reportUnfollowPop();
        } else {
            FollowStatisHelper.reportFollowClick(fansUserDetails.getUserInfoKS().uid, this.mRoomId, 3);
        }
    }

    @Override
    public LiveData<PageData<FansUserDetails>> nextPage() {
        return this.nextPageData;
    }

    @Override
    public LiveData<Integer> listCount() {
        return this.listTotalData;
    }

    private DialogLinkManager getDialogLinkManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.getMvpContext().getContext());
        }
        return this.mDialogLinkManager;
    }
}

