/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.fanslist;

import com.squareup.wire.AndroidMessage;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.PageData;
import com.yy.appbase.datacenter.DataCenter;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.relation.base.data.DataSource;
import com.yy.hiyo.relation.base.data.IRelationRepository;
import com.yy.hiyo.relation.base.fans.FansUserDetails;
import com.yy.hiyo.relation.base.friend.INewFansAndFriendHandler;
import com.yy.hiyo.relation.data.RelationRepository;
import com.yy.hiyo.relation.fanslist.FansListMvp;
import com.yy.hiyo.relation.followlist.FollowHandler;
import com.yy.hiyo.relation.proto.ProtoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.ihago.room.srv.follow.FansUserInfo;
import net.ihago.room.srv.follow.PullFansListReq;
import net.ihago.room.srv.follow.PullFansListRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FansListModel
implements FansListMvp.IModel {
    private static final String TAG = "FansListModel";
    private long uid;
    private int pageIndex = 0;
    private FollowHandler mFollowHandler;
    private INewFansAndFriendHandler newFansHandler;

    public FansListModel(long uid, INewFansAndFriendHandler newFansHandler) {
        this.uid = uid;
        this.newFansHandler = newFansHandler;
    }

    public void listRefresh(ICommonCallback<PageData<FansUserDetails>> callback, boolean saveTimestamp) {
        boolean reqPageIndex = false;
        this.requestPageData(0, callback, saveTimestamp);
    }

    public void listNextPage(ICommonCallback<PageData<FansUserDetails>> callback) {
        int reqPageIndex = this.pageIndex + 1;
        this.requestPageData(reqPageIndex, callback, false);
    }

    private void requestPageData(final int reqPageIndex, final ICommonCallback<PageData<FansUserDetails>> callback, final boolean saveTimestamp) {
        long time = saveTimestamp ? this.newFansHandler.getFansTimestamp() : -1L;
        this.requestFansListData(this.uid, reqPageIndex, time, new IFollowProtoCallback<PullFansListRes>(){

            public void onSuccess(@NotNull PullFansListRes data) {
                if (saveTimestamp && data.timestamp > 0L && FansListModel.this.newFansHandler != null) {
                    FansListModel.this.newFansHandler.saveFansTimestamp(data.timestamp.longValue());
                }
                ArrayList<FansUserInfo> pageFansList = new ArrayList<FansUserInfo>();
                PageData pageData = new PageData();
                pageData.setTotal(FP.orInt((Long)data.total));
                pageData.setPageIndex(reqPageIndex);
                List fansUserList = data.users;
                if (fansUserList != null && fansUserList.size() > 0) {
                    int pageSize = data.page_size.intValue();
                    if (fansUserList.size() < pageSize) {
                        pageData.setHasNextPage(false);
                    } else {
                        pageData.setHasNextPage(true);
                    }
                    for (FansUserInfo fansUserInfo : fansUserList) {
                        if (fansUserInfo == null) continue;
                        pageFansList.add(fansUserInfo);
                    }
                } else {
                    pageData.setHasNextPage(false);
                }
                FansListModel.this.requestPageDataUserDetails((PageData<FansUserDetails>)pageData, pageFansList, (ICommonCallback<PageData<FansUserDetails>>)callback, new Object[]{data.timestamp});
            }

            public void onFail(int code, String msg) {
                ProtoHelper.INSTANCE.handleOnFailInMain(callback, code, msg);
            }
        });
    }

    private void requestPageDataUserDetails(final PageData<FansUserDetails> pageData, final List<FansUserInfo> pageFansList, final ICommonCallback<PageData<FansUserDetails>> callback, final Object ... ext) {
        if (pageFansList != null && pageFansList.size() > 0) {
            ArrayList<Long> uidList = new ArrayList<Long>();
            for (FansUserInfo fansUserInfo : pageFansList) {
                uidList.add(fansUserInfo.uid);
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    ArrayList<FansUserDetails> fansUserDetailsList = new ArrayList<FansUserDetails>();
                    HashMap<Long, UserInfoKS> userInfoMap = new HashMap<Long, UserInfoKS>();
                    for (UserInfoKS userInfoKS : userInfoKSList) {
                        if (userInfoKS == null) continue;
                        userInfoMap.put(userInfoKS.uid, userInfoKS);
                    }
                    for (FansUserInfo fansUserInfo : pageFansList) {
                        UserInfoKS userInfoKS = (UserInfoKS)userInfoMap.get(fansUserInfo.uid);
                        if (userInfoKS == null) continue;
                        FansUserDetails fansUserDetails = new FansUserDetails();
                        fansUserDetails.setIsNew(fansUserInfo.is_new.booleanValue());
                        fansUserDetails.setUserInfoKS(userInfoKS);
                        fansUserDetails.setUserFrom(fansUserInfo.path.intValue());
                        int relation = fansUserInfo.relation.intValue();
                        fansUserDetailsList.add(fansUserDetails);
                    }
                    FansListModel.this.pageIndex = pageData.getPageIndex();
                    pageData.setData(fansUserDetailsList);
                    ProtoHelper.INSTANCE.handleOnSuccessInMain(callback, pageData, ext);
                }

                public void onFail(int id2, String msg, String response) {
                    ProtoHelper.INSTANCE.handleOnFailInMain(callback, 5000, msg);
                }

                public int id() {
                    return 0;
                }
            });
        } else {
            this.pageIndex = pageData.getPageIndex();
            ProtoHelper.INSTANCE.handleOnSuccessInMain(callback, pageData, new Object[0]);
        }
    }

    private void requestFansListData(final long uid, int pageIndex, long timestamp, final IFollowProtoCallback<PullFansListRes> callback) {
        MLog.info((Object)TAG, (String)("requestFansListData, uid=" + uid), (Object[])new Object[0]);
        PullFansListReq req = new PullFansListReq.Builder().uid(Long.valueOf(uid)).cur_page(Long.valueOf(pageIndex)).timestamp(Long.valueOf(timestamp)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<PullFansListRes>(){

            public void onResponse(@androidx.annotation.Nullable PullFansListRes message) {
                if (message == null) {
                    ProtoHelper.INSTANCE.handleOnFail(callback, 5002, "result is null");
                } else if (ProtoHelper.INSTANCE.isFail(message.err)) {
                    ProtoHelper.INSTANCE.handleOnFail(callback, FP.orInt((Long)message.err.code), message.err.tips);
                } else {
                    YYTaskExecutor.execute(() -> FansListModel.this.updateRelation(message));
                    ProtoHelper.INSTANCE.handleOnSuccess(callback, message);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)FansListModel.TAG, (String)"requestFansListData, uid=%s, timeout", (Object[])new Object[]{uid});
                ProtoHelper.INSTANCE.handleOnFail(callback, 5001, "request timeout");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)FansListModel.TAG, (String)"requestFansListData, uid=%s, error code=%d, reason=%s", (Object[])new Object[]{uid, code, reason});
                ProtoHelper.INSTANCE.handleOnFail(callback, code, reason);
                return false;
            }
        });
    }

    public void onFansStatusClicked(@NotNull DialogLinkManager dialogLinkManager2, @Nullable FansUserDetails followUserDetails, @Nullable OkCancelDialogListener dialogListener) {
        if (this.mFollowHandler == null) {
            this.mFollowHandler = new FollowHandler();
        }
        this.mFollowHandler.onFansStatusClicked(dialogLinkManager2, followUserDetails, dialogListener);
    }

    private void updateRelation(PullFansListRes message) {
        if (message == null || FP.empty((Collection)message.users)) {
            return;
        }
        IRelationRepository iRep = (IRelationRepository)DataCenter.INSTANCE.getRepository(IRelationRepository.class);
        if (iRep instanceof RelationRepository) {
            RelationRepository repository = (RelationRepository)iRep;
            for (FansUserInfo info : message.users) {
                repository.updateRelation((long)info.uid, info.relation.intValue(), DataSource.NET, (int)info.path);
            }
        }
    }
}

