/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.fanslist;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.PageMvpContext;
import com.yy.hiyo.relation.R;
import com.yy.hiyo.relation.base.follow.FollowMsgDef;
import com.yy.hiyo.relation.fanslist.ui.FansListUiCallback;
import com.yy.hiyo.relation.fanslist.ui.FansListWindow;

public class FansListController
extends DefaultController
implements FansListUiCallback {
    public FansListController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg.what == FollowMsgDef.OPEN_FANS_LIST) {
            long uid = AccountUtil.getUid();
            String roomId = "";
            Bundle bundle = msg.getData();
            if (bundle != null) {
                uid = bundle.getLong("uid", AccountUtil.getUid());
                roomId = bundle.getString("room_id", "");
            }
            this.openFansList(uid, roomId);
        }
    }

    private void openFansList(long uid, String roomId) {
        FansListWindow fansListWindow = new FansListWindow((IMvpContext)PageMvpContext.Companion.of((Context)this.getActivity()), (UICallBacks)this, uid, roomId);
        fansListWindow.initDatas();
        this.mWindowMgr.pushWindow((AbstractWindow)fansListWindow, true);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
    }

    public String getWindowTitle() {
        return ResourceUtils.getString((int)R.string.short_title_fans_list_title);
    }

    public void closeListWindow(AbstractWindow window) {
        if (window == null) {
            return;
        }
        this.mWindowMgr.popWindow(true, window);
    }
}

