/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.blacklist.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.appbase.ui.widget.EndlessListScrollListener;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.base.yyprotocol.Uint32;
import com.yy.hiyo.relation.R;
import com.yy.hiyo.relation.base.blacklist.data.BlacklistUserInfo;
import com.yy.hiyo.relation.blacklist.data.UserInfo;
import com.yy.hiyo.relation.blacklist.ui.BlackListAdapter;
import com.yy.hiyo.relation.blacklist.ui.BlacklistController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlacklistPage
extends YYFrameLayout
implements BlackListAdapter.OnItemDeleteListener {
    private View view;
    private View mRootView;
    private Context mContext;
    private TextView mTvDefault;
    private BlacklistController mUICallBacks;
    private PullToRefreshListView mListView;
    private BlackListAdapter mAdapter;
    private EndlessListScrollListener mEndlessListScrollListener;
    private boolean isLastPage = false;
    private boolean shouldClear = true;
    private boolean isFirstLoad = true;
    private List<Long> uids = new ArrayList<Long>();
    private Map<Long, Uint32> authVMap = new HashMap<Long, Uint32>();
    private Map<Long, Integer> isAnchorMap = new HashMap<Long, Integer>();
    private SimpleTitleBar mStbTitleBar;
    private CommonStatusLayout statusLayout;
    private long mPage;
    private final long mCount = 100L;
    private List<Long> userIdList = new ArrayList<Long>();
    private List<UserInfo> userInfoList = new ArrayList<UserInfo>();
    AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"UserFansListFragment", (String)("position = " + position), (Object[])new Object[0]);
            }
            try {
                if (BlacklistPage.this.mAdapter != null && BlacklistPage.this.mListView != null && BlacklistPage.this.mAdapter.getCount() > 0 && position > 0 && position - ((ListView)BlacklistPage.this.mListView.getRefreshableView()).getHeaderViewsCount() >= 0) {
                    BlacklistPage.this.mUICallBacks.onItemclick(position - 1);
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)this, (Throwable)throwable);
            }
        }
    };

    public BlacklistPage(Context context, BlacklistController controller) {
        super(context);
        this.mContext = context;
        this.mUICallBacks = controller;
        this.createView();
    }

    private void createView() {
        this.mRootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_blacklist_pager, (ViewGroup)this);
        this.initTitle();
        this.initListView();
    }

    private void initTitle() {
        this.mStbTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mStbTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.black_list));
        this.mStbTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                BlacklistPage.this.mUICallBacks.finish();
            }
        });
    }

    private void initListView() {
        this.mTvDefault = (TextView)this.findViewById(R.id.tv_default);
        this.mListView = (PullToRefreshListView)this.findViewById(R.id.black_list);
        this.statusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mListView.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
        this.mListView.setScrollingWhileRefreshingEnabled(true);
        this.mAdapter = new BlackListAdapter(this.getContext());
        this.mAdapter.setOnItemDeleteClickListener(this);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        ((ListView)this.mListView.getRefreshableView()).setOnItemClickListener(this.onItemClickListener);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener2)new PullToRefreshBase.OnRefreshListener2<ListView>(){

            public void onPullDownToRefresh(PullToRefreshBase<ListView> refreshView) {
                BlacklistPage.this.refresh();
            }

            public void onPullUpToRefresh(PullToRefreshBase<ListView> refreshView) {
                BlacklistPage.this.refresh();
            }
        });
        this.mEndlessListScrollListener = new EndlessListScrollListener((CommonStatusLayout)this.findViewById(R.id.status_layout));
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                BlacklistPage.this.shouldClear = true;
                BlacklistPage.this.mPage = BlacklistPage.this.mAdapter.getCount();
                BlacklistPage.this.mUICallBacks.requestBlackList(BlacklistPage.this.mPage, 50L);
            }

            public boolean shouldLoadData() {
                if (BlacklistPage.this.isLastPage || !BlacklistPage.this.isNetworkAvailable()) {
                    BlacklistPage.this.getHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            BlacklistPage.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 500L);
                    return false;
                }
                return true;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.userInfoList.add(new UserInfo("team", "  Pull the black time:2018/09/14"));
        this.userInfoList.add(new UserInfo("sysytem", "Pull the black time:2018/09/13"));
        this.onRequestBasicUserInfo(this.userIdList, this.userInfoList, true, "");
    }

    @Override
    public void onDeleteClick(int position) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            SingleToastUtil.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        this.mUICallBacks.onItemDeleteClick(position);
        this.shouldClear = true;
    }

    public void onRequestBasicUserInfo(List<Long> userIdList, List<UserInfo> userInfoList, boolean isLocalData, String ctx) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)this, (String)("onRequestBasicUserInfo userIdList = " + userIdList.size() + " userInfoList = " + userInfoList.size()), (Object[])new Object[0]);
        }
        if (this.uids.containsAll(userIdList)) {
            this.uids.removeAll(userIdList);
        }
    }

    public void updateData(List<BlacklistUserInfo> userList) {
        if (this.shouldClear) {
            if (FP.empty(userList)) {
                this.mTvDefault.setVisibility(4);
            } else {
                this.mTvDefault.setVisibility(4);
            }
            this.mAdapter.setData(userList);
        } else {
            this.mAdapter.addData(userList);
        }
        this.complete();
    }

    public void complete() {
        this.mAdapter.notifyDataSetChanged();
        this.mListView.onRefreshComplete();
        this.mEndlessListScrollListener.onLoadComplete();
        if (FP.empty(this.mAdapter.getData())) {
            this.showNoData();
        } else {
            this.statusLayout.hideNoData();
        }
    }

    public void refresh() {
        this.shouldClear = true;
        this.mPage = 0L;
        this.mUICallBacks.requestBlackList(this.mPage, 50L);
    }

    public void requestTimeoutTask() {
        this.statusLayout.hideAllStatus();
        this.mListView.onRefreshComplete();
        this.mEndlessListScrollListener.onLoadComplete();
        if (FP.empty(this.mAdapter.getData())) {
            this.showNoData();
        } else {
            this.statusLayout.hideNoData();
        }
    }

    public void showNoData() {
        this.statusLayout.showNoData(R.drawable.default_no_data, this.getContext().getString(R.string.content_empty_tips), null);
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext());
    }
}

