/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.blacklist.ui;

import android.os.Message;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.relation.base.blacklist.data.BlacklistUserInfo;
import com.yy.hiyo.relation.blacklist.ui.BlacklistWindow;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import okhttp3.Call;

public class BlacklistController
extends DefaultWindowController
implements INotify,
UICallBacks {
    private static final String TAG = "BlacklistController";
    private BlacklistWindow mWindow;
    private List<BlacklistUserInfo> mUserInfoList = new ArrayList<BlacklistUserInfo>();
    private boolean mHide = false;

    public BlacklistController(Environment env) {
        super(env);
    }

    public void finish() {
        this.sendMessage(UserMsgDef.CLOSE_WINDOW_BLACKLIST);
    }

    public void requestBlackList(final long page, long count) {
        ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).requestBlacklist(page, count, (ICommonCallback)new ICommonCallback<List<BlacklistUserInfo>>(){

            public void onSuccess(List<BlacklistUserInfo> blacklistUserInfos, Object ... ext) {
                if (page == 0L) {
                    BlacklistController.this.mUserInfoList = blacklistUserInfos;
                } else if (blacklistUserInfos != null && blacklistUserInfos.size() > 0) {
                    BlacklistController.this.mUserInfoList.addAll(blacklistUserInfos);
                }
                if (BlacklistController.this.mUserInfoList != null && BlacklistController.this.mUserInfoList.size() > 0) {
                    Collections.sort(BlacklistController.this.mUserInfoList, new BlockComparator());
                }
                if (BlacklistController.this.mWindow != null && BlacklistController.this.mWindow.getPager() != null) {
                    BlacklistController.this.mWindow.getPager().updateData(BlacklistController.this.mUserInfoList);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (BlacklistController.this.mWindow != null && BlacklistController.this.mWindow.getPager() != null) {
                            BlacklistController.this.mWindow.getPager().complete();
                        }
                    }
                });
            }
        });
    }

    public void onItemclick(int position) {
        if (this.mUserInfoList != null && this.mUserInfoList.size() > position) {
            BlacklistUserInfo userInfo = this.mUserInfoList.get(position);
            MLog.info((Object)TAG, (String)"onItemclick open profile window:%s", (Object[])new Object[]{String.valueOf(userInfo.getUserInfo().uid)});
            ProfileReportBean bean = new ProfileReportBean();
            bean.setUid(Long.valueOf(userInfo.getUserInfo().uid));
            bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getFriends()));
            bean.setSource(9);
            this.sendMessage(UserMsgDef.OPEN_WINDOW_NEW_PROFILE, -1, -1, bean);
        }
    }

    public void onItemDeleteClick(final int position) {
        BlacklistUserInfo userInfo;
        if (this.mUserInfoList != null && this.mUserInfoList.size() > position && (userInfo = this.mUserInfoList.get(position)) != null) {
            ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).unBlackUid(userInfo.getUserInfo().uid, new INetRespCallback(){

                public void onError(Call call, Exception e, int id2) {
                }

                public void onResponse(String response, BaseResponseBean res, int id2) {
                    try {
                        BlacklistController.this.mUserInfoList.remove(position);
                        if (BlacklistController.this.mWindow != null && BlacklistController.this.mWindow.getPager() != null) {
                            BlacklistController.this.mWindow.getPager().updateData(BlacklistController.this.mUserInfoList);
                        }
                    }
                    catch (Exception ex) {
                        MLog.error((Object)BlacklistController.TAG, (Throwable)ex);
                    }
                }
            });
        }
    }

    public void handleMessage(Message msg) {
        if (msg.what == UserMsgDef.SHOW_WINDOW_BLACKLIST) {
            if (this.mWindow == this.mWindowMgr.getCurrentWindow()) {
                return;
            }
            if (this.mWindow == null) {
                this.mWindow = new BlacklistWindow(this.mContext, this);
            }
            this.requestBlackList(0L, 50L);
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_BLACKLIST && this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mHide) {
            if (this.mWindow != null && this.mWindow.getPager() != null) {
                this.mWindow.getPager().refresh();
            }
            this.mHide = false;
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        this.mHide = true;
    }

    static class BlockComparator
    implements Comparator<BlacklistUserInfo> {
        BlockComparator() {
        }

        @Override
        public int compare(BlacklistUserInfo o1, BlacklistUserInfo o2) {
            long dif = o2.getBlack().getTimestamp() - o1.getBlack().getTimestamp();
            return dif < 0L ? -1 : (dif > 0L ? 1 : 0);
        }
    }
}

