/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.blacklist.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.yyprotocol.Uint32;
import com.yy.hiyo.relation.R;
import com.yy.hiyo.relation.base.blacklist.data.BlacklistUserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackListAdapter
extends BaseAdapter {
    private Context context;
    private List<BlacklistUserInfo> mData = new ArrayList<BlacklistUserInfo>();
    public Map<Long, Integer> isAnchorMap = new HashMap<Long, Integer>();
    public Map<Long, Uint32> authVMap = new HashMap<Long, Uint32>();
    private OnItemDeleteListener mOnItemDeleteListener;

    public BlackListAdapter(Context context) {
        this.context = context;
    }

    public void addData(List<BlacklistUserInfo> data) {
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void setData(List<BlacklistUserInfo> data) {
        this.mData.clear();
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public List<BlacklistUserInfo> getData() {
        return this.mData;
    }

    public int getCount() {
        return this.mData.size();
    }

    public BlacklistUserInfo getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.layout_user_blacklist_item, parent, false);
            holder.portraitIv = (CircleImageView)convertView.findViewById(R.id.bl_portrait_headIcon);
            holder.nameTv = (TextView)convertView.findViewById(R.id.tv_name);
            holder.blackTime = (TextView)convertView.findViewById(R.id.black_time_txt);
            holder.delete = (YYImageView)convertView.findViewById(R.id.bl_delete);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BlackListAdapter.this.mOnItemDeleteListener != null) {
                    BlackListAdapter.this.mOnItemDeleteListener.onDeleteClick(position);
                }
            }
        });
        BlacklistUserInfo info = this.getItem(position);
        if (info != null) {
            holder.nameTv.setText((CharSequence)info.getUserInfo().nick);
            String date = DateUtils.dateToString((long)info.getBlack().getTimestamp(), (String)"yyyy-MM-dd");
            String time = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.block_time), (Object[])new Object[]{date});
            holder.blackTime.setText((CharSequence)time);
            ImageLoader.loadImage((ImageView)holder.portraitIv, (String)(info.getUserInfo().avatar + YYImageUtils.getThumbnailPostfix((int)75)));
        }
        return convertView;
    }

    public void setOnItemDeleteClickListener(OnItemDeleteListener mOnItemDeleteListener) {
        this.mOnItemDeleteListener = mOnItemDeleteListener;
    }

    class ViewHolder {
        CircleImageView portraitIv;
        TextView blackTime;
        TextView nameTv;
        YYImageView delete;

        ViewHolder() {
        }
    }

    public static interface OnItemDeleteListener {
        public void onDeleteClick(int var1);
    }
}

