/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.record;

import android.app.Activity;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.record.RecordUtils;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.AudioRecordConfig;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.hiyo.record.a;
import com.yy.hiyo.record.ag;
import com.yy.hiyo.record.ah;
import com.yy.hiyo.record.ak;
import com.yy.hiyo.record.base.AudioDownloadInfo;
import com.yy.hiyo.record.base.AudioErrorInfo;
import com.yy.hiyo.record.base.AudioPlayInfo;
import com.yy.hiyo.record.base.AudioRecordInfo;
import com.yy.hiyo.record.base.AudioUploadInfo;
import com.yy.hiyo.record.base.IRecordService;
import com.yy.hiyo.record.base.RecordOption;
import com.yy.hiyo.record.c;
import com.yy.hiyo.record.t;
import java.io.File;

public class af
extends DefaultController
implements ak.a,
IRecordService {
    private AudioRecordInfo a;
    private t b;
    private AudioPlayInfo c;
    private c d;
    private final ah e;
    private final ak f;
    private final LruCache<String, String> g = new LruCache(1000);
    private volatile Boolean h = null;
    private final KvoBinder i = new KvoBinder((Object)this);

    public af(Environment environment) {
        super(environment);
        this.e = new ah();
        this.f = new ak(this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        int n2 = notification.id;
    }

    public int isRecordSupport() {
        boolean bl = PermissionHelper.hasRecordAudioPermission((Activity)this.getActivity());
        if (!bl) {
            return 2;
        }
        if (this.h != null && this.h.booleanValue()) {
            return 3;
        }
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.AUDIO_RECORD_CONFIG);
        if (aConfigData instanceof AudioRecordConfig) {
            AudioRecordConfig audioRecordConfig = (AudioRecordConfig)aConfigData;
            if (!audioRecordConfig.getSwitch()) {
                this.h = true;
                return 3;
            }
            if (audioRecordConfig.isInBlackList(AccountUtil.getUid())) {
                this.h = true;
                return 3;
            }
            if (audioRecordConfig.isInBlackList(CommonHttpHeader.getDeviceType())) {
                this.h = true;
                return 3;
            }
        }
        this.h = false;
        return 1;
    }

    @Nullable
    public AudioRecordInfo startRecord(String string, String string2, int n2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"startRecord business: %s, subBusiness: %s, maxDuration: %s", (Object[])new Object[]{string, string2, n2});
        }
        if (this.isRecordSupport() != 1) {
            MLog.error((Object)"RecordController", (String)"startRecord is not support to record", (Object[])new Object[0]);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("business or subBusiness must not be empty!");
        }
        if (this.b != null && this.b.isRecording() && this.a != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"RecordController", (String)"startRecord is recording and can not start anther recorder, recording's business: %s, recording's subBusiness: %s, business: %s, subBusiness: %s", (Object[])new Object[]{this.a.getBusiness(), this.a.getSubBusiness(), string, string2});
            }
            return null;
        }
        if (this.a != null) {
            this.i.clearKvoConnection(AudioRecordInfo.class.getName());
        }
        this.a = this.a(string, string2, n2);
        this.a.isProgress = true;
        this.i.singleBindSourceTo((KvoSource)this.a);
        this.b = t.a(this.a);
        String string3 = RecordUtils.getRecordPath((String)this.a.getLocalId());
        FileUtils.createNewFile((String)string3);
        this.a.setFilePath(string3);
        this.b.startRecord();
        return this.a;
    }

    public void cancelRecord(@NonNull AudioRecordInfo audioRecordInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"cancelRecord AudioRecordInfo: %s", (Object[])new Object[]{audioRecordInfo});
        }
        if (audioRecordInfo != this.a) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"RecordController", (String)"cancelRecord is not recording inforecording's business: %s, recording's subBusiness: %s, business: %s, subBusiness: %s", (Object[])new Object[]{this.a.getBusiness(), this.a.getSubBusiness(), audioRecordInfo.getBusiness(), audioRecordInfo.getSubBusiness()});
            }
            audioRecordInfo.error = new AudioErrorInfo(100, "can not cancel record, for the info is not current recording");
            audioRecordInfo.setState(AudioRecordInfo.State.ERROR);
            return;
        }
        if (this.b != null && this.b.isRecording()) {
            this.b.cancelRecord();
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"cancelRecord,  is not recording can not cancel", (Object[])new Object[0]);
        }
    }

    public void stopRecord(@NonNull AudioRecordInfo audioRecordInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"stopRecord AudioRecordInfo: %s", (Object[])new Object[]{audioRecordInfo});
        }
        this.stopRecord(audioRecordInfo, false);
    }

    public void stopRecord(@NonNull AudioRecordInfo audioRecordInfo, boolean bl) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"stopRecord AudioRecordInfo: %s, upload: %s", (Object[])new Object[]{audioRecordInfo, bl});
        }
        if (audioRecordInfo != this.a) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"RecordController", (String)"stopRecord is not recording inforecording's business: %s, recording's subBusiness: %s, business: %s, subBusiness: %s", (Object[])new Object[]{this.a.getBusiness(), this.a.getSubBusiness(), audioRecordInfo.getBusiness(), audioRecordInfo.getSubBusiness()});
            }
            audioRecordInfo.error = new AudioErrorInfo(101, "can not stop or upload record, for the info is not current recording");
            audioRecordInfo.setState(AudioRecordInfo.State.ERROR);
            return;
        }
        if (this.b != null && this.b.isRecording()) {
            audioRecordInfo.isUpload = bl;
            this.b.stopRecord();
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"stopRecord, is not recording can not stop", (Object[])new Object[0]);
        }
    }

    @NonNull
    public AudioPlayInfo playRecord(String string) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"playRecord recordId: %s", (Object[])new Object[]{string});
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("playRecord recordId must not be empty!");
        }
        c c2 = this.d;
        AudioPlayInfo audioPlayInfo = this.c;
        if (c2 != null && c2.isPlaying() && audioPlayInfo != null) {
            c2.stopPlay();
            audioPlayInfo.error = new AudioErrorInfo(202, "be forced to stop by start play other record");
            audioPlayInfo.setState(AudioPlayInfo.State.ERROR);
        }
        AudioPlayInfo audioPlayInfo2 = this.b(string);
        if (this.b != null && this.b.isRecording()) {
            MLog.error((Object)"RecordController", (String)"is recording, can not play audio", (Object[])new Object[0]);
            audioPlayInfo2.error = new AudioErrorInfo(203, " is recording, can not play audio");
            audioPlayInfo2.setState(AudioPlayInfo.State.ERROR);
            return audioPlayInfo2;
        }
        this.c = audioPlayInfo2;
        this.d = com.yy.hiyo.record.c.a(this.c);
        if (!TextUtils.isEmpty((CharSequence)this.c.getRecordUrl())) {
            this.a(this.c.getRecordUrl());
        } else {
            String string2 = (String)this.g.get((Object)this.c.getLocalId());
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                this.a(string2);
            } else {
                String string3 = RecordUtils.getRecordPath((String)this.c.getLocalId());
                if (YYFileUtils.isFileExisted((String)string3)) {
                    this.c.setFilePath(string3);
                    this.d.play();
                } else {
                    this.c.error = new AudioErrorInfo(210, "can not found audio for localId: " + this.c.getLocalId());
                    this.c.setState(AudioPlayInfo.State.ERROR);
                }
            }
        }
        return this.c;
    }

    private void a(String string) {
        File file;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"playWithUrl url: %s", (Object[])new Object[]{string});
        }
        if ((file = com.yy.hiyo.record.a.a(string).b(string)) != null && file.exists()) {
            this.c.setFilePath(file.getAbsolutePath());
            this.d.play();
        } else {
            this.c.setState(AudioPlayInfo.State.DOWNLOADING);
            AudioDownloadInfo audioDownloadInfo = this.downloadRecord(string);
            this.i.singleBindSourceTo(string + "_download", (KvoSource)audioDownloadInfo);
        }
    }

    public void pausePlayRecord(@NonNull AudioPlayInfo audioPlayInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"pausePlayRecord AudioPlayInfo: %s, mCurPlayInfo: %s", (Object[])new Object[]{audioPlayInfo, this.c});
        }
        if (audioPlayInfo != this.c) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"RecordController", (String)"pausePlayRecord is not playing infoplaying's recordUrl: %s, playing's localId: %s, recordUrl: %s, localId: %s", (Object[])new Object[]{this.c == null ? "" : this.c.getRecordUrl(), this.c == null ? "" : this.c.getLocalId(), audioPlayInfo.getRecordUrl(), audioPlayInfo.getLocalId()});
            }
            audioPlayInfo.error = new AudioErrorInfo(200, "can pause play, for the info is not current playing");
            audioPlayInfo.setState(AudioPlayInfo.State.ERROR);
            return;
        }
        if (this.d != null) {
            this.d.pausePlay();
        }
    }

    public void resumePlayRecord(@NonNull AudioPlayInfo audioPlayInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"resumePlayRecord AudioPlayInfo: %s", (Object[])new Object[]{audioPlayInfo});
        }
        if (audioPlayInfo != this.c) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"RecordController", (String)"resumePlayRecord is not playing infoplaying's recordUrl: %s, playing's localId: %s, recordUrl: %s, localId: %s", (Object[])new Object[]{this.c == null ? "" : this.c.getRecordUrl(), this.c == null ? "" : this.c.getLocalId(), audioPlayInfo.getRecordUrl(), audioPlayInfo.getLocalId()});
            }
            audioPlayInfo.error = new AudioErrorInfo(201, "can resume play, for the info is not current playing");
            audioPlayInfo.setState(AudioPlayInfo.State.ERROR);
            return;
        }
        if (this.d != null) {
            this.d.resumePlay();
        }
    }

    public void stopPlayRecord(@NonNull AudioPlayInfo audioPlayInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"stopPlayRecord AudioPlayInfo: %s", (Object[])new Object[]{audioPlayInfo});
        }
        if (audioPlayInfo != this.c) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"RecordController", (String)"stopPlayRecord is not playing infoplaying's recordUrl: %s, playing's localId: %s, recordUrl: %s, localId: %s", (Object[])new Object[]{this.c == null ? "" : this.c.getRecordUrl(), this.c == null ? "" : this.c.getLocalId(), audioPlayInfo.getRecordUrl(), audioPlayInfo.getLocalId()});
            }
            audioPlayInfo.error = new AudioErrorInfo(201, "can stop play, for the info is not current playing");
            audioPlayInfo.setState(AudioPlayInfo.State.ERROR);
            return;
        }
        if (this.d != null) {
            this.d.stopPlay();
        }
    }

    public AudioDownloadInfo downloadRecord(@NonNull String string) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"downloadRecord recordUrl: %s", (Object[])new Object[]{string});
        }
        AudioDownloadInfo audioDownloadInfo = new AudioDownloadInfo();
        audioDownloadInfo.setUrl(string);
        this.e.a(audioDownloadInfo);
        return audioDownloadInfo;
    }

    public void cancelDownloadRecord(@NonNull AudioDownloadInfo audioDownloadInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"cancelDownloadRecord AudioDownloadInfo: %s", (Object[])new Object[]{audioDownloadInfo});
        }
        this.e.b(audioDownloadInfo);
    }

    public AudioUploadInfo uploadRecord(String string) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"uploadRecord localId: %s", (Object[])new Object[]{string});
        }
        AudioUploadInfo audioUploadInfo = new AudioUploadInfo();
        audioUploadInfo.setLocalId(string);
        audioUploadInfo.setUrlPath(RecordUtils.getUrlPath((String)string));
        audioUploadInfo.setFilePath(RecordUtils.getRecordPath((String)string));
        this.f.a(audioUploadInfo);
        this.i.singleBindSourceTo(string + "_upload", (KvoSource)audioUploadInfo);
        return audioUploadInfo;
    }

    public void cancelUploadRecord(@NonNull AudioUploadInfo audioUploadInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RecordController", (String)"cancelUploadRecord AudioDownloadInfo: %s", (Object[])new Object[]{audioUploadInfo});
        }
        this.f.b(audioUploadInfo);
    }

    @KvoMethodAnnotation(sourceClass=AudioRecordInfo.class, name="state", thread=2)
    public void onAudioRecordStateChanged(KvoEventIntent kvoEventIntent) {
        if (kvoEventIntent.isStickyNotify()) {
            return;
        }
        AudioRecordInfo.State state = (AudioRecordInfo.State)kvoEventIntent.newValue();
        AudioRecordInfo audioRecordInfo = (AudioRecordInfo)kvoEventIntent.source();
        if (state == AudioRecordInfo.State.UPLOADING && audioRecordInfo.isUpload) {
            YYTaskExecutor.execute((Runnable)new ag(this));
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=AudioDownloadInfo.class, thread=2)
    public void onAudioDownloadStateChanged(KvoEventIntent kvoEventIntent) {
        AudioDownloadInfo.State state = (AudioDownloadInfo.State)kvoEventIntent.newValue();
        AudioDownloadInfo audioDownloadInfo = (AudioDownloadInfo)kvoEventIntent.source();
        String string = audioDownloadInfo.getUrl();
        if (state == AudioDownloadInfo.State.CANCEL || state == AudioDownloadInfo.State.FAILED) {
            this.i.clearKvoConnection(string + "_download");
            if (this.c != null && string.equals(this.c.getRecordUrl())) {
                this.c.error = new AudioErrorInfo(204, "download record failed");
                this.c.setState(AudioPlayInfo.State.DOWNLOAD_FAILED);
            }
        } else if (state == AudioDownloadInfo.State.COMPLETE) {
            this.i.clearKvoConnection(string + "_download");
            if (this.d != null && this.c != null && string.equals(this.c.getRecordUrl())) {
                this.c.setFilePath(audioDownloadInfo.getFilePath());
                this.d.play();
                this.c.setState(AudioPlayInfo.State.DOWNLOAD_SUCCESS);
            }
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=AudioUploadInfo.class)
    public void onAudioUploadStateChanged(KvoEventIntent kvoEventIntent) {
        AudioUploadInfo.State state = (AudioUploadInfo.State)kvoEventIntent.newValue();
        AudioUploadInfo audioUploadInfo = (AudioUploadInfo)kvoEventIntent.source();
        String string = audioUploadInfo.getFilePath();
        if (state == AudioUploadInfo.State.CANCEL || state == AudioUploadInfo.State.FAILED) {
            this.i.clearKvoConnection(audioUploadInfo.getLocalId() + "_upload");
            if (this.a != null && string.equals(this.a.getFilePath())) {
                this.a.setState(AudioRecordInfo.State.UPLOAD_FAILED);
            }
        } else if (state == AudioUploadInfo.State.COMPLETE) {
            this.i.clearKvoConnection(audioUploadInfo.getLocalId() + "_upload");
            if (this.a != null && string.equals(this.a.getFilePath())) {
                this.g.put((Object)this.a.getLocalId(), (Object)audioUploadInfo.getUrl());
                this.a.setRecordUrl(audioUploadInfo.getUrl());
                this.a.setState(AudioRecordInfo.State.UPLOAD_SUCCESS);
            }
        }
    }

    private AudioRecordInfo a(String string, String string2, int n2) {
        Object object;
        AudioRecordInfo audioRecordInfo = new AudioRecordInfo();
        if (n2 > 0) {
            object = new RecordOption();
            object.maxDuration = n2;
            audioRecordInfo.setOption(object);
        }
        audioRecordInfo.setBusiness(string);
        audioRecordInfo.setSubBusiness(string2);
        object = RecordUtils.genLocalId((String)string, (String)string2);
        audioRecordInfo.setLocalId((String)object);
        return audioRecordInfo;
    }

    private AudioPlayInfo b(String string) {
        AudioPlayInfo audioPlayInfo = new AudioPlayInfo();
        audioPlayInfo.isProgress = true;
        audioPlayInfo.setRecordId(string);
        if (string.startsWith("http")) {
            audioPlayInfo.setRecordUrl(string);
        } else {
            audioPlayInfo.setLocalId(string);
        }
        return audioPlayInfo;
    }

    @Override
    public IOOSService a() {
        return (IOOSService)this.getServiceManager().getService(IOOSService.class);
    }

    static /* synthetic */ AudioRecordInfo a(af af2) {
        return af2.a;
    }

    static /* synthetic */ KvoBinder b(af af2) {
        return af2.i;
    }
}

