/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.seat;

import android.graphics.Point;
import android.view.View;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.plugins.radio.seat.BaseRadioSeatViewWrapper;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatPresenter;
import java.util.HashMap;
import java.util.Map;

public class RadioVideoPkSeatViewWrapper
extends BaseRadioSeatViewWrapper {
    Map<Long, Point> realLoctionMap = new HashMap<Long, Point>();
    IPkVidoSeatCallback mCallback;

    public RadioVideoPkSeatViewWrapper(IPkVidoSeatCallback callback2, IEnteredChannel channel, RadioSeatPresenter.OnAnchorSeatChangedListener listener2) {
        super(listener2, channel);
        this.mCallback = callback2;
    }

    @Override
    public void setOnLayoutChangeListener(View.OnLayoutChangeListener listener2) {
        if (this.mCallback != null) {
            this.mCallback.setOnLayoutChangeListener(listener2);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mCallback = null;
    }

    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        int[] newLoction;
        long uid = this.mChannel.getDataService().getChannelDetailInfo(null).baseInfo.ownerUid;
        if (this.mCallback != null && (newLoction = this.mCallback.getPkOwnerSeat(isAbsolute)) != null && newLoction.length == 2) {
            int[] loction = newLoction;
            this.realLoctionMap.clear();
            this.realLoctionMap.put(uid, new Point(loction[0], loction[1]));
        }
        return this.realLoctionMap;
    }

    public int getSeatFaceSize() {
        return ResolutionUtils.dip2Px((float)18.0f);
    }

    public int[] getSeatViewPosition() {
        if (this.mCallback != null) {
            return this.mCallback.getPkOwnerSeat(true);
        }
        return new int[]{-1, -1};
    }

    public static interface IPkVidoSeatCallback {
        public int[] getPkOwnerSeat(boolean var1);

        public void setOnLayoutChangeListener(View.OnLayoutChangeListener var1);
    }
}

