/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.screenrecord.impl;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import androidx.annotation.RequiresApi;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.BaseEncoder;
import com.yy.hiyo.voice.base.bean.event.VoiceCallBack;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 92\u00020\u00012\u00020\u0002:\u000289B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0014H\u0002J*\u0010!\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016J.\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010(2\b\u0010\"\u001a\u0004\u0018\u00010\u00192\u0006\u0010*\u001a\u00020\nH\u0016J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\fH\u0016J(\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\fH\u0002J\u0006\u00104\u001a\u00020\u0014J\b\u00105\u001a\u00020\u001fH\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u00100\u001a\u00020-H\u0002J\u0010\u00107\u001a\u00020\u00142\u0006\u00100\u001a\u00020-H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/AudioEncoder;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder;", "Lcom/yy/hiyo/voice/base/bean/event/VoiceCallBack;", "mediaService", "Lcom/yy/hiyo/channel/base/service/IMediaService;", "(Lcom/yy/hiyo/channel/base/service/IMediaService;)V", "audioDataList", "Ljava/util/LinkedList;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/AudioEncoder$AudioData;", "audioStartTime", "", "availIndex", "", "mHandler", "Landroid/os/Handler;", "getMHandler", "()Landroid/os/Handler;", "setMHandler", "(Landroid/os/Handler;)V", "mIsOnlyMicMode", "", "mIsOnlySpeakerMode", "getMediaService", "()Lcom/yy/hiyo/channel/base/service/IMediaService;", "micDataList", "", "offerCount", "speakerDataList", "createMediaFormat", "Landroid/media/MediaFormat;", "enablePcmDataCallback", "", "enable", "onAudioCapturePcmData", "data", "dataSize", "sampleRate", "channel", "onAudioPlayData", "roomId", "", "uid", "duration", "onInputBufferAvailable", "codec", "Landroid/media/MediaCodec;", "index", "sendDataToEncode", "encoder", "input", "presentationTimeNs", "inputBufferIndex", "startRecord", "stop", "tryMixAudioData", "trySendDataToEncode", "AudioData", "Companion", "radio_release"})
@RequiresApi(value=21)
public final class AudioEncoder
extends BaseEncoder
implements VoiceCallBack {
    private long audioStartTime;
    private int offerCount;
    private final LinkedList<Integer> availIndex;
    private final LinkedList<byte[]> speakerDataList;
    private final LinkedList<byte[]> micDataList;
    private final LinkedList<AudioData> audioDataList;
    @Nullable
    private Handler mHandler;
    private boolean mIsOnlyMicMode;
    private boolean mIsOnlySpeakerMode;
    @NotNull
    private final IMediaService mediaService;
    @NotNull
    public static final String TAG = "AudioRecorder";
    public static final int AUDIO_SAMPLE_RATE = 16000;
    public static final int AUDIO_MAX_INPUT_SIZE = 320;
    public static final int AUDIO_BIT_RATE = 128000;
    public static final int SELF_RECORD_CHANNEL = 1;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Handler getMHandler() {
        return this.mHandler;
    }

    public final void setMHandler(@Nullable Handler handler) {
        this.mHandler = handler;
    }

    public final boolean startRecord() {
        this.audioStartTime = 0L;
        this.offerCount = 0;
        this.start();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("Start Record : " + this.audioDataList.size() + ' ' + this.availIndex.size()), (Object[])new Object[0]);
        }
        this.audioDataList.clear();
        this.availIndex.clear();
        this.speakerDataList.clear();
        this.micDataList.clear();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
            final /* synthetic */ AudioEncoder this$0;

            public final void run() {
                this.this$0.getMediaService().registerOnSpeakListener((VoiceCallBack)this.this$0);
                AudioEncoder.access$enablePcmDataCallback(this.this$0, true);
            }
            {
                this.this$0 = audioEncoder;
            }
        });
        return true;
    }

    private final void enablePcmDataCallback(boolean enable) {
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).enableRenderPcmDataCallBack(enable, 16000, 1);
        IServiceManager iServiceManager2 = ServiceManagerProxy.getServiceManager();
        if (iServiceManager2 == null) {
            Intrinsics.throwNpe();
        }
        ((IKtvLiveServiceExtend)iServiceManager2.getService(IKtvLiveServiceExtend.class)).enableCapturePcmDataCallBack(enable, 16000, 1);
    }

    public void onAudioPlayData(@Nullable String roomId, @Nullable String uid, @Nullable byte[] data, long duration) {
        block2: {
            if (data == null) {
                return;
            }
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)("onAudioPlayData " + data.length + ' ' + duration), (Object[])new Object[0]);
            }
            Handler handler = this.mHandler;
            if (handler == null) break block2;
            handler.post(new Runnable(this, data){
                final /* synthetic */ AudioEncoder this$0;
                final /* synthetic */ byte[] $data;

                public final void run() {
                    MediaCodec mediaCodec = this.this$0.getEncoder();
                    if (mediaCodec == null) {
                        return;
                    }
                    MediaCodec encoder = mediaCodec;
                    if (AudioEncoder.access$getAudioStartTime$p(this.this$0) < 1L) {
                        AudioEncoder.access$setAudioStartTime$p(this.this$0, System.nanoTime());
                    }
                    AudioEncoder.access$getSpeakerDataList$p(this.this$0).add(this.$data);
                    if (AudioEncoder.access$getSpeakerDataList$p(this.this$0).size() - AudioEncoder.access$getMicDataList$p(this.this$0).size() > 10) {
                        AudioEncoder.access$setMIsOnlySpeakerMode$p(this.this$0, true);
                    }
                    AudioEncoder.access$setMIsOnlyMicMode$p(this.this$0, false);
                    AudioEncoder.access$tryMixAudioData(this.this$0, encoder);
                }
                {
                    this.this$0 = audioEncoder;
                    this.$data = byArray;
                }
            });
        }
    }

    public void onAudioCapturePcmData(@Nullable byte[] data, int dataSize, int sampleRate, int channel) {
        block2: {
            if (data == null) {
                return;
            }
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)("onAudioCapturePcmData " + dataSize + ' ' + sampleRate), (Object[])new Object[0]);
            }
            Handler handler = this.mHandler;
            if (handler == null) break block2;
            handler.post(new Runnable(this, data){
                final /* synthetic */ AudioEncoder this$0;
                final /* synthetic */ byte[] $data;

                public final void run() {
                    MediaCodec mediaCodec = this.this$0.getEncoder();
                    if (mediaCodec == null) {
                        return;
                    }
                    MediaCodec encoder = mediaCodec;
                    if (AudioEncoder.access$getAudioStartTime$p(this.this$0) < 1L) {
                        AudioEncoder.access$setAudioStartTime$p(this.this$0, System.nanoTime());
                    }
                    AudioEncoder.access$getMicDataList$p(this.this$0).add(this.$data);
                    if (AudioEncoder.access$getMicDataList$p(this.this$0).size() - AudioEncoder.access$getSpeakerDataList$p(this.this$0).size() > 10) {
                        AudioEncoder.access$setMIsOnlyMicMode$p(this.this$0, true);
                    }
                    AudioEncoder.access$setMIsOnlySpeakerMode$p(this.this$0, false);
                    AudioEncoder.access$tryMixAudioData(this.this$0, encoder);
                }
                {
                    this.this$0 = audioEncoder;
                    this.$data = byArray;
                }
            });
        }
    }

    @Override
    public void stop() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
            final /* synthetic */ AudioEncoder this$0;

            public final void run() {
                AudioEncoder.access$enablePcmDataCallback(this.this$0, false);
                this.this$0.getMediaService().unregisterOnSpeakListener((VoiceCallBack)this.this$0);
            }
            {
                this.this$0 = audioEncoder;
            }
        });
        this.audioDataList.clear();
        this.availIndex.clear();
        this.speakerDataList.clear();
        this.micDataList.clear();
        this.mHandler = null;
        super.stop();
    }

    @Override
    @NotNull
    protected MediaFormat createMediaFormat() {
        MediaFormat audioFormat = new MediaFormat();
        audioFormat.setString("mime", "audio/mp4a-latm");
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("sample-rate", 16000);
        audioFormat.setInteger("channel-count", 1);
        audioFormat.setInteger("bitrate", 128000);
        audioFormat.setInteger("max-input-size", 320);
        return audioFormat;
    }

    public void onInputBufferAvailable(@NotNull MediaCodec codec, int index) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
            Handler handler = this.mHandler;
            if (handler == null) break block0;
            handler.post(new Runnable(this, index){
                final /* synthetic */ AudioEncoder this$0;
                final /* synthetic */ int $index;

                public final void run() {
                    MediaCodec mediaCodec = this.this$0.getEncoder();
                    if (mediaCodec == null) {
                        return;
                    }
                    MediaCodec encoder = mediaCodec;
                    AudioEncoder.access$getAvailIndex$p(this.this$0).add(this.$index);
                    AudioEncoder.access$trySendDataToEncode(this.this$0, encoder);
                }
                {
                    this.this$0 = audioEncoder;
                    this.$index = n;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void tryMixAudioData(MediaCodec encoder) {
        while ((this.micDataList.size() > 0 || this.mIsOnlySpeakerMode) && (this.speakerDataList.size() > 0 || this.mIsOnlyMicMode)) {
            int n;
            byte[] byArray;
            byte[] mic;
            byte[] speaker = this.speakerDataList.isEmpty() ? null : this.speakerDataList.remove(0);
            byte[] byArray2 = mic = this.micDataList.isEmpty() ? null : this.micDataList.remove(0);
            if (speaker == null) {
                byArray = mic;
            } else if (mic == null) {
                byArray = speaker;
            } else {
                byte[] input = new byte[speaker.length];
                int n2 = 0;
                n = speaker.length;
                while (n2 < n) {
                    void i;
                    input[i] = (byte)((mic[i] + speaker[i]) / 2);
                    ++i;
                }
                byArray = input;
            }
            if (byArray == null) {
                return;
            }
            byte[] input = byArray;
            long presentationTimeStampNs = (long)this.offerCount * (1000000000L * (long)input.length * 1L / (long)32000) + this.audioStartTime;
            n = this.offerCount;
            this.offerCount = n + 1;
            this.audioDataList.add(new AudioData(input, presentationTimeStampNs));
            boolean result = this.trySendDataToEncode(encoder);
            if (!RuntimeContext.sIsDebuggable) continue;
            MLog.debug((Object)TAG, (String)(" offerAudioEncoder " + result + "  " + this.audioDataList.size() + ' ' + this.availIndex.size()), (Object[])new Object[0]);
        }
    }

    private final boolean trySendDataToEncode(MediaCodec encoder) {
        if (this.audioDataList.size() > 0 && this.availIndex.size() > 0) {
            AudioData audioData = this.audioDataList.remove(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)audioData, (String)"audioDataList.removeAt(0)");
            AudioData data = audioData;
            Integer n = this.availIndex.remove(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"availIndex.removeAt(0)");
            int index = ((Number)n).intValue();
            return this.sendDataToEncode(encoder, data.getInput(), data.getTimeNs(), index);
        }
        return false;
    }

    private final boolean sendDataToEncode(MediaCodec encoder, byte[] input, long presentationTimeNs, int inputBufferIndex) {
        try {
            long presentationTimeUs = presentationTimeNs / (long)1000;
            ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
            byte[] byArray = input;
            boolean bl = false;
            if (byArray.length == 0 || inputBuffer == null) {
                encoder.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("Input BUFFER_FLAG_END_OF_STREAM " + presentationTimeUs), (Object[])new Object[0]);
                }
            } else {
                inputBuffer.put(input);
                encoder.queueInputBuffer(inputBufferIndex, 0, input.length, presentationTimeUs, 0);
            }
            return true;
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, (String)("_offerAudioEncoder exception " + inputBufferIndex), (Throwable)t, (Object[])new Object[0]);
            return false;
        }
    }

    @NotNull
    public final IMediaService getMediaService() {
        return this.mediaService;
    }

    public AudioEncoder(@NotNull IMediaService mediaService) {
        Intrinsics.checkParameterIsNotNull((Object)mediaService, (String)"mediaService");
        this.mediaService = mediaService;
        this.availIndex = new LinkedList();
        this.speakerDataList = new LinkedList();
        this.micDataList = new LinkedList();
        this.audioDataList = new LinkedList();
    }

    public static final /* synthetic */ void access$enablePcmDataCallback(AudioEncoder $this, boolean enable) {
        $this.enablePcmDataCallback(enable);
    }

    public static final /* synthetic */ long access$getAudioStartTime$p(AudioEncoder $this) {
        return $this.audioStartTime;
    }

    public static final /* synthetic */ void access$setAudioStartTime$p(AudioEncoder $this, long l) {
        $this.audioStartTime = l;
    }

    public static final /* synthetic */ LinkedList access$getSpeakerDataList$p(AudioEncoder $this) {
        return $this.speakerDataList;
    }

    public static final /* synthetic */ LinkedList access$getMicDataList$p(AudioEncoder $this) {
        return $this.micDataList;
    }

    public static final /* synthetic */ boolean access$getMIsOnlySpeakerMode$p(AudioEncoder $this) {
        return $this.mIsOnlySpeakerMode;
    }

    public static final /* synthetic */ void access$setMIsOnlySpeakerMode$p(AudioEncoder $this, boolean bl) {
        $this.mIsOnlySpeakerMode = bl;
    }

    public static final /* synthetic */ boolean access$getMIsOnlyMicMode$p(AudioEncoder $this) {
        return $this.mIsOnlyMicMode;
    }

    public static final /* synthetic */ void access$setMIsOnlyMicMode$p(AudioEncoder $this, boolean bl) {
        $this.mIsOnlyMicMode = bl;
    }

    public static final /* synthetic */ void access$tryMixAudioData(AudioEncoder $this, MediaCodec encoder) {
        $this.tryMixAudioData(encoder);
    }

    public static final /* synthetic */ LinkedList access$getAvailIndex$p(AudioEncoder $this) {
        return $this.availIndex;
    }

    public static final /* synthetic */ boolean access$trySendDataToEncode(AudioEncoder $this, MediaCodec encoder) {
        return $this.trySendDataToEncode(encoder);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/AudioEncoder$AudioData;", "", "input", "", "timeNs", "", "([BJ)V", "getInput", "()[B", "setInput", "([B)V", "getTimeNs", "()J", "setTimeNs", "(J)V", "radio_release"})
    public static final class AudioData {
        @NotNull
        private byte[] input;
        private long timeNs;

        @NotNull
        public final byte[] getInput() {
            return this.input;
        }

        public final void setInput(@NotNull byte[] byArray) {
            Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
            this.input = byArray;
        }

        public final long getTimeNs() {
            return this.timeNs;
        }

        public final void setTimeNs(long l) {
            this.timeNs = l;
        }

        public AudioData(@NotNull byte[] input, long timeNs) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            this.input = input;
            this.timeNs = timeNs;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/AudioEncoder$Companion;", "", "()V", "AUDIO_BIT_RATE", "", "AUDIO_MAX_INPUT_SIZE", "AUDIO_SAMPLE_RATE", "SELF_RECORD_CHANNEL", "TAG", "", "radio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

