/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.bubble.util;

import android.graphics.PointF;

public class BubbleBezierUtils {
    public static PointF calculateBezierPointFor1(float t, PointF p0, PointF p1) {
        PointF point = new PointF();
        float temp = 1.0f - t;
        point.x = temp * p0.x + t * p1.x;
        point.y = temp * p0.y + t * p1.y;
        return point;
    }

    public static PointF calculateBezierPointForQuadratic(float t, PointF p0, PointF p1, PointF p2) {
        PointF point = new PointF();
        float temp = 1.0f - t;
        point.x = temp * temp * p0.x + 2.0f * t * temp * p1.x + t * t * p2.x;
        point.y = temp * temp * p0.y + 2.0f * t * temp * p1.y + t * t * p2.y;
        return point;
    }

    public static PointF calculateBezierPointForCubic(float t, PointF p0, PointF p1, PointF p2, PointF p3) {
        PointF point = new PointF();
        float temp = 1.0f - t;
        float tempQuadratic = temp * temp;
        float tempCubed = tempQuadratic * temp;
        float tQuadratic = t * t;
        float tCubed = tQuadratic * t;
        point.x = p0.x * tempCubed + 3.0f * p1.x * t * tempQuadratic + 3.0f * p2.x * tQuadratic * temp + p3.x * tCubed;
        point.y = p0.y * tempCubed + 3.0f * p1.y * t * tempQuadratic + 3.0f * p2.y * tQuadratic * temp + p3.y * tCubed;
        return point;
    }

    public static PointF calculateBezierPointFor4(float t, PointF p0, PointF p1, PointF p2, PointF p3, PointF p4) {
        PointF point = new PointF();
        float temp = 1.0f - t;
        point.x = p0.x * temp * temp * temp * temp + 4.0f * p1.x * t * temp * temp * temp + 6.0f * p2.x * t * t * temp * temp + 4.0f * p3.x * t * t * t * temp + p4.x * t * t * t * t;
        point.y = p0.y * temp * temp * temp * temp + 4.0f * p1.y * t * temp * temp * temp + 6.0f * p2.y * t * t * temp * temp + 4.0f * p3.y * t * t * t * temp + p4.y * t * t * t * t;
        return point;
    }
}

