/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.FacePoint;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.GloatToastUtils;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.RadioLiveConfig;
import com.yy.appbase.unifyconfig.config.RadioLiveConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hago.media.MEAudienceLinkMic;
import com.yy.hago.media.MEBizCode;
import com.yy.hago.media.MEVideoPK;
import com.yy.hago.media.MediaEntity;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.bean.video.LiveVideoStreamInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.cbase.module.lunmic.ILunMicPresenter;
import com.yy.hiyo.channel.cbase.module.radio.live.OnLinkMicTypeChangedListener;
import com.yy.hiyo.channel.cbase.module.radio.live.VideoStreamCallback;
import com.yy.hiyo.channel.component.bottombar.ChannelToolsPresenter;
import com.yy.hiyo.channel.component.debug.DebugPresenter;
import com.yy.hiyo.channel.component.theme.ThemePresenter;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.channel.module.main.enter.LoadingBgHellper;
import com.yy.hiyo.channel.module.recommend.base.bean.MiniInfo;
import com.yy.hiyo.channel.plugins.radio.DR;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.RadioPage;
import com.yy.hiyo.channel.plugins.radio.RadioPresenter;
import com.yy.hiyo.channel.plugins.radio.RadioUtil;
import com.yy.hiyo.channel.plugins.radio.SecureScreenUtils;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatInfo;
import com.yy.hiyo.channel.plugins.radio.seat.view.RadioVideoSeatView;
import com.yy.hiyo.channel.plugins.radio.video.UserLinkMicPresenter;
import com.yy.hiyo.channel.plugins.radio.video.VideoPresenter;
import com.yy.hiyo.channel.plugins.radio.video.live.RadioPlayCallback;
import com.yy.hiyo.channel.plugins.radio.video.live.RadioPlayPresenter;
import com.yy.hiyo.channel.plugins.radio.video.top.bar.RadioVideoTopView;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakRunnable;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.OnRecvMediaExtraInfoListener;
import com.yy.hiyo.voice.base.mediav1.bean.IMediaRoom;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import java.util.List;
import java.util.Map;
import net.ihago.channel.srv.mgr.JoinMicStatus;
import net.ihago.channel.srv.mgr.JoinMicType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioNewPresenter
extends AbsPluginPresenter
implements INotify {
    private static final String TAG = "RadioNewPresenter";
    private static final int THEME_UNKNOWN = 0;
    private static final int THEME_VIDEO_PK = 1;
    private static final int THEME_USER_LINK_MIC = 2;
    private Runnable mThemeDelayRunnable = null;
    private RadioPlayPresenter mPlayPresenter;
    private IPluginService.IPluginDataChangedCallBack pluginCallBack;
    private ICallBack myStepCallback;
    private boolean isResetTheme = false;
    private boolean needPreLinkMicVideoSize = true;
    private int mCurrentTheme = 0;
    private ISeatUpdateListener iSeatUpdateListener = null;
    protected boolean presenterRealExecuted = false;
    private OnRecvMediaExtraInfoListener mOnRecvMediaExtraInfoListener = (uid, info) -> this.recvMediaExtraInfo(uid, info);

    public void init(ICallBack callBack) {
        this.myStepCallback = callBack;
        NotificationCenter.getGlobalInstance().register(ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ChannelNotifyDef.VIDEO_WARN_NOTIFY, (INotify)this);
        boolean played = this.play();
        if (played) {
            if (this.getPlayPresenter().isVideoStarted()) {
                this.onStreamVideoStarted();
            }
        } else {
            this.onStreamVideoStoped();
        }
        if (!this.getPage().isPageVisible()) {
            ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(new IPageLifeCycle(){

                public void onShown() {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RadioNewPresenter.this.myStepCallback.onWindowShown();
                            if (RadioNewPresenter.this.mPlayPresenter != null) {
                                RadioNewPresenter.this.mPlayPresenter.onPageShown();
                            }
                        }
                    });
                }
            });
        } else {
            this.myStepCallback.onWindowShown();
            if (this.mPlayPresenter != null) {
                this.mPlayPresenter.onPageShown();
            }
        }
        this.getPlayPresenter().setVideoStreamCallback(new VideoStreamCallback(){

            public void onVideoStart(long anchorId, int width, int height, boolean isCdn) {
                if (RadioNewPresenter.this.isDestroyed()) {
                    return;
                }
                ((RadioPage)RadioNewPresenter.this.getPage()).onVideoStart(RadioNewPresenter.this.isMeShowing(), anchorId, width, height, isCdn);
                RadioNewPresenter.this.onStreamVideoStarted();
                RadioNewPresenter.this.checkCurrentTheme(width, height);
            }

            public void videoStreamOpen(long anchorId, LiveVideoStreamInfo streamInfo) {
                if (RadioNewPresenter.this.isDestroyed()) {
                    return;
                }
                if (streamInfo.getWidth() > 0 && streamInfo.getHeight() > 0) {
                    ((RadioPage)RadioNewPresenter.this.getPage()).onVideoSizeChange(RadioNewPresenter.this.isMeShowing(), anchorId, streamInfo.getWidth(), streamInfo.getHeight(), streamInfo.getRotation());
                }
                RadioNewPresenter.this.checkCurrentTheme(streamInfo.getWidth(), streamInfo.getHeight());
            }

            public void videoStreamClose(long anchorId) {
                RadioNewPresenter.this.onStreamVideoClose();
            }

            public void onVideoSizeChange(long anchorId, int width, int height, int rotation) {
                if (RadioNewPresenter.this.isDestroyed()) {
                    return;
                }
                ((RadioPage)RadioNewPresenter.this.getPage()).onVideoSizeChange(RadioNewPresenter.this.isMeShowing(), anchorId, width, height, rotation);
                RadioNewPresenter.this.checkCurrentTheme(width, height);
                MLog.info((Object)"RadioPlugin", (String)"onVideoSizeChange anchorId: %d, ownerUid: %d", (Object[])new Object[]{anchorId, RadioNewPresenter.this.getChannel().getOwnerUid()});
            }
        });
        this.registerMediaExtend();
    }

    protected void onStreamVideoStarted() {
        this.myStepCallback.onVideoStarted();
    }

    protected void onStreamVideoStoped() {
        this.myStepCallback.onVideoStoped();
    }

    protected void onStreamVideoClose() {
    }

    private void recvMediaExtraInfo(@Nullable String uid, @Nullable MediaEntity info) {
        if (info == null) {
            return;
        }
        if (info.bizCode.intValue() == MEBizCode.kVideoPK.getValue()) {
            this.onRecMediaPkInfo(info);
        } else if (info.bizCode.intValue() == MEBizCode.KAudienceLinkMic.getValue()) {
            this.onRecMediaAudienceLinkMic(info);
        }
    }

    private void onRecMediaPkInfo(MediaEntity info) {
        if (!this.needPreLinkMicVideoSize) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            try {
                MEVideoPK pk = (MEVideoPK)MEVideoPK.ADAPTER.decode(info.info);
                if (pk.isLinkMic.booleanValue()) {
                    this.needPreLinkMicVideoSize = false;
                    YYTaskExecutor.postToMainThread(() -> {
                        if (this.isDestroyed()) {
                            return;
                        }
                        this.checkCurrentTheme(true, 1);
                        ((RadioPage)this.getPage()).preLinkMicVideoSize(true);
                    });
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        });
    }

    private void onRecMediaAudienceLinkMic(MediaEntity info) {
        if (!this.needPreLinkMicVideoSize) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            try {
                MEAudienceLinkMic linker = (MEAudienceLinkMic)MEAudienceLinkMic.ADAPTER.decode(info.info);
                if (linker.status.intValue() == JoinMicStatus.JOIN_MIC_GOING.getValue() && linker.joinMicType.intValue() == JoinMicType.JAT_VIDEO.getValue()) {
                    this.needPreLinkMicVideoSize = false;
                    YYTaskExecutor.postToMainThread(() -> {
                        if (this.isDestroyed()) {
                            return;
                        }
                        this.checkCurrentTheme(true, 2);
                        ((RadioPage)this.getPage()).preLinkMicVideoSize(false);
                    });
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        });
    }

    private void checkCurrentTheme(int streamWidth, int streamHeight) {
        if (streamWidth == 0 || streamHeight == 0 || this.isResetTheme) {
            return;
        }
        this.checkCurrentTheme(streamWidth > streamHeight, 0);
    }

    private void checkCurrentTheme(boolean isLinkMic, int theme) {
        if (isLinkMic) {
            if (this.mThemeDelayRunnable != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mThemeDelayRunnable);
                this.mThemeDelayRunnable = null;
            }
            switch (theme) {
                case 1: {
                    this.mCurrentTheme = 2;
                    ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().postValue((Object)new DrawableResThemeBean(R.drawable.audio_pk_blue_vs_red_bg_min, com.yy.hiyo.pk.base.DR.audio_pk_blue_vs_red_bg, false));
                    break;
                }
                case 2: {
                    this.mCurrentTheme = 3;
                    ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().postValue((Object)new DrawableResThemeBean(LoadingBgHellper.getLoadingBgDefaultResId(), DR.bg_link_mic));
                    break;
                }
                case 0: {
                    this.mThemeDelayRunnable = () -> {
                        this.mCurrentTheme = 1;
                        ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().postValue((Object)new DrawableResThemeBean(LoadingBgHellper.getLoadingBgDefaultResId()));
                        this.mThemeDelayRunnable = null;
                    };
                    YYTaskExecutor.postToMainThread((Runnable)this.mThemeDelayRunnable, (long)250L);
                    break;
                }
            }
            this.isResetTheme = true;
        }
    }

    public int getCurrentTheme() {
        return this.mCurrentTheme;
    }

    public RadioPlayPresenter getPlayPresenter() {
        if (this.mPlayPresenter == null) {
            long uid = 0L;
            if (this.getChannelDetailInfo() != null && this.getChannelDetailInfo().baseInfo != null) {
                uid = this.getChannelDetailInfo().baseInfo.ownerUid;
            }
            this.mPlayPresenter = new RadioPlayPresenter((IChannel)this.getChannel(), (RadioPage)this.getPage(), uid, new RadioPlayCallback(){

                @Override
                public void setSecureScreen(boolean isSecure) {
                    Window window = ((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).getContext().getWindow();
                    if (window != null) {
                        SecureScreenUtils.INSTANCE.secureScreen(window, isSecure);
                    }
                }

                @Override
                public boolean isMeShowing() {
                    return RadioNewPresenter.this.isMeShowing();
                }

                @Override
                public void setOnLinkMicTypeChangedListener(@NotNull OnLinkMicTypeChangedListener listener2) {
                    if (!RadioNewPresenter.this.isDestroyed()) {
                        ((UserLinkMicPresenter)RadioNewPresenter.this.getPresenter(UserLinkMicPresenter.class)).setOnLinkMicTypeChangedListener(listener2);
                    }
                }

                @Override
                public int getLinkMicType() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return JoinMicType.JOIN_MIC_TYPE_NONE.getValue();
                    }
                    return ((UserLinkMicPresenter)RadioNewPresenter.this.getPresenter(UserLinkMicPresenter.class)).getCurrentLinkMicType();
                }

                @Override
                public boolean isLinkMicAudience() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((UserLinkMicPresenter)RadioNewPresenter.this.getPresenter(UserLinkMicPresenter.class)).isLinkMicAudience();
                }

                @Override
                public boolean isLinkMicTwoSourceVideoMode() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((VideoPresenter)RadioNewPresenter.this.getPresenter(VideoPresenter.class)).isWatchTwoUserSourceLive();
                }

                @Override
                public void showQualityGuide() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return;
                    }
                    ((ChannelToolsPresenter)RadioNewPresenter.this.getPresenter(ChannelToolsPresenter.class)).openPanelWithQualitySwitchGuide();
                }

                @Override
                public boolean isCurrLinkMic() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((VideoPresenter)RadioNewPresenter.this.getPresenter(VideoPresenter.class)).isLinkMic();
                }

                @Override
                public boolean isRadioReady() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).hasPresenter(RadioPresenter.class);
                }

                @Override
                public void showDebugInfo(final String debugInfo) {
                    if (RuntimeContext.sIsDebuggable) {
                        YYTaskExecutor.postToMainThread((Runnable)WeakRunnable.of((IDestroyable)RadioNewPresenter.this, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((DebugPresenter)RadioNewPresenter.this.getPresenter(DebugPresenter.class)).updateSubDebugInfo(debugInfo);
                            }
                        }), (long)5000L);
                    }
                }

                @Override
                public boolean isLoopMicRoomAndNoLiving() {
                    if (!((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).isDestroy() && ((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).hasPresenter(ILunMicPresenter.class)) {
                        return ((ILunMicPresenter)((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).getPresenter(ILunMicPresenter.class)).isAnchorNotInSeat();
                    }
                    return false;
                }
            });
            this.getPlayPresenter().setMode(1);
        }
        return this.mPlayPresenter;
    }

    public boolean play() {
        if (this.pluginCallBack == null) {
            this.pluginCallBack = new IPluginService.IPluginDataChangedCallBack(){

                public void onVideoModeChanged(String channelId, boolean isVideoMode) {
                    if (RadioNewPresenter.this.isDestroyed() || RadioNewPresenter.this.isMeShowing()) {
                        return;
                    }
                    if (isVideoMode) {
                        ((RadioPage)RadioNewPresenter.this.getPage()).setLiveViewVisible(true);
                        RadioNewPresenter.this.getPlayPresenter().startWatch();
                        if (RadioNewPresenter.this.getPlayPresenter().isVideoStarted()) {
                            RadioNewPresenter.this.onStreamVideoStarted();
                        }
                    } else {
                        ((RadioPage)RadioNewPresenter.this.getPage()).setLiveViewVisible(false);
                        RadioNewPresenter.this.getPlayPresenter().stopWatchLive();
                        RadioNewPresenter.this.onStreamVideoStoped();
                    }
                }
            };
        }
        this.getChannel().getPluginService().addPluginDataListener(this.pluginCallBack);
        if (!this.isMeShowing()) {
            if (this.isVideoMode()) {
                ((RadioPage)this.getPage()).setLiveViewVisible(true);
                this.getPlayPresenter().startWatch();
                boolean isLoopMicRoom = this.getChannel().getChannelDetail().baseInfo.isLoopMicRoom();
                if (isLoopMicRoom || this.isPageSupportReuse()) {
                    this.addPreLoadSeatUpdateListener(isLoopMicRoom);
                }
                return true;
            }
            ((RadioPage)this.getPage()).setLiveViewVisible(false);
            this.getPlayPresenter().stopWatchLive();
            return false;
        }
        return false;
    }

    protected void addPreLoadSeatUpdateListener(boolean isLoopMicRoom) {
        this.iSeatUpdateListener = new PreLoadSeatUpdateListener(isLoopMicRoom);
        this.getChannel().getSeatService().getSeatData().addSeatUpdateListener(this.iSeatUpdateListener);
    }

    protected void onSeatUpdateHaveUid(Long uid) {
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.RADIO_LIVE_CONFIG);
        if (configData instanceof RadioLiveConfig) {
            IMediaRoom room;
            RadioLiveConfigData data = ((RadioLiveConfig)configData).getData();
            IMediaRoomService mediaRoomService = (IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class);
            if (data != null && data.getLoopMicSeatUidSet() && mediaRoomService != null && (room = mediaRoomService.getRoom(this.getChannelId())) != null) {
                room.updateCurrentLiveAnchor(uid.longValue());
            }
        }
    }

    private void removeSeatUpdateListener() {
        if (this.iSeatUpdateListener != null) {
            this.getChannel().getSeatService().getSeatData().removeSeatUpdateListener(this.iSeatUpdateListener);
            this.iSeatUpdateListener = null;
        }
    }

    protected void preloadSeatView(Long uid) {
        View seatView = this.getPage().findViewById(R.id.seatViewHolder);
        RadioVideoSeatView targetView = null;
        if (seatView instanceof RadioVideoSeatView) {
            targetView = (RadioVideoSeatView)seatView;
        } else if (seatView != null && !(seatView instanceof YYPlaceHolderView)) {
            View topView = this.getPage().findViewById(R.id.topBarHolder);
            if (topView instanceof RadioVideoTopView) {
                ((RadioVideoTopView)topView).updateSpaceWidth(false);
            }
            YYPlaceHolderView view = new YYPlaceHolderView((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            RadioUtil.INSTANCE.replaceSelfWithView(seatView, (View)view);
            targetView = new RadioVideoSeatView((Context)((IChannelPageContext)this.getMvpContext()).getContext(), null, null, (IChannel)this.getChannel());
            view.inflate((View)targetView);
        }
        if (targetView != null) {
            UserInfoKS user = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid.longValue());
            String userNick = user.nick;
            String userAvatar = user.avatar;
            if (uid.equals(this.getChannel().getEnterParam().getExtra("key_radio_owner_uid", (Object)0L))) {
                if (TextUtils.isEmpty((CharSequence)userNick)) {
                    userNick = (String)this.getChannel().getEnterParam().getExtra("key_radio_owner_nick", (Object)"");
                }
                if (TextUtils.isEmpty((CharSequence)userAvatar)) {
                    userAvatar = (String)this.getChannel().getEnterParam().getExtra("key_radio_owner_avatar", (Object)"");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)userNick)) {
                MLog.debug((Object)"RadioPlugin", (String)("preloadSeatView: " + uid), (Object[])new Object[0]);
                targetView.updateSeat(new RadioSeatInfo(uid, userNick, AccountUtil.getUid() == uid), false);
                targetView.setRootLayoutVisible(true);
            }
            if (!TextUtils.isEmpty((CharSequence)userAvatar)) {
                targetView.setAvatar(userAvatar, uid, user.sex);
            }
        }
    }

    public void onDestroy() {
        MLog.debug((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        super.onDestroy();
        NotificationCenter.getGlobalInstance().unregister(ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(ChannelNotifyDef.VIDEO_WARN_NOTIFY, (INotify)this);
        this.removeSeatUpdateListener();
        if (this.mPlayPresenter != null) {
            this.mPlayPresenter.destroy();
            this.mPlayPresenter = null;
        }
        if (this.mThemeDelayRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mThemeDelayRunnable);
            this.mThemeDelayRunnable = null;
        }
        if (this.pluginCallBack != null) {
            this.getChannel().getPluginService().removePluginDataListener(this.pluginCallBack);
            this.pluginCallBack = null;
        }
        this.unregisterMediaExtend();
    }

    private void registerMediaExtend() {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).registerMediaExtraInfoReceiver(MEBizCode.kVideoPK.getValue(), this.mOnRecvMediaExtraInfoListener);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).registerMediaExtraInfoReceiver(MEBizCode.KAudienceLinkMic.getValue(), this.mOnRecvMediaExtraInfoListener);
    }

    private void unregisterMediaExtend() {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).unRegisterMediaExtraInfoReceiver(MEBizCode.kVideoPK.getValue(), this.mOnRecvMediaExtraInfoListener);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).unRegisterMediaExtraInfoReceiver(MEBizCode.KAudienceLinkMic.getValue(), this.mOnRecvMediaExtraInfoListener);
    }

    public void notify(Notification notification) {
        if (notification == null || this.isDestroyed()) {
            return;
        }
        if (notification.id == ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED) {
            if (notification.extObj instanceof MiniInfo) {
                MiniInfo miniInfo = (MiniInfo)notification.extObj;
                if (SettingFlags.getBoolean((String)"adjustensureradippresenter", (boolean)true)) {
                    if (miniInfo.isMinimized() && this.myStepCallback != null) {
                        this.myStepCallback.ensurePresentersInit();
                    }
                    if (this.myStepCallback != null && this.myStepCallback.isPresentersInited()) {
                        ((RadioPresenter)this.getPresenter(RadioPresenter.class)).handleMini(miniInfo);
                    }
                } else {
                    if (this.myStepCallback != null) {
                        this.myStepCallback.ensurePresentersInit();
                    }
                    ((RadioPresenter)this.getPresenter(RadioPresenter.class)).handleMini(miniInfo);
                }
                this.getPlayPresenter().onWindowSizeChanged(!miniInfo.isMinimized());
                this.getPlayPresenter().showOrHideFuzzyBg(miniInfo.isMinimized());
            }
        } else if (notification.id == ChannelNotifyDef.VIDEO_WARN_NOTIFY && notification.extObj instanceof String && this.isMeShowing() && this.isVideoMode() && StringUtils.equal((String)this.getChannelId(), (String)((String)notification.extObj))) {
            int marginTop = ResolutionUtils.getScreenHeight() / 2 - ResolutionUtils.dip2Px((float)100.0f);
            GloatToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_video_warn), (long)15000L, (float)marginTop, (boolean)false);
        }
    }

    public boolean canChangeSeat() {
        return true;
    }

    public boolean haveSelfFaceLocation() {
        return false;
    }

    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return null;
    }

    public boolean interceptRunningState() {
        return false;
    }

    public boolean isVideoMode() {
        ChannelPluginData data = this.getChannel().getPluginService().getCurPluginData();
        return data != null && data.isVideoMode();
    }

    public boolean isVideoStart() {
        if (this.mPlayPresenter != null) {
            return this.mPlayPresenter.isVideoStarted();
        }
        return false;
    }

    public void setPresenterRealExecuted() {
        this.presenterRealExecuted = true;
    }

    public boolean isMeShowing() {
        return this.getChannel().getRoleService().isMeAnchor();
    }

    public long getShowingUid() {
        return this.getChannel().getRoleService().getAnchorUid();
    }

    public static interface ICallBack {
        public void onVideoStarted();

        public void onVideoStoped();

        public void ensurePresentersInit();

        public void onWindowShown();

        public boolean isPresentersInited();
    }

    private class PreLoadSeatUpdateListener
    implements ISeatUpdateListener {
        private final boolean isLoopMic;

        PreLoadSeatUpdateListener(boolean isLoopMic) {
            this.isLoopMic = isLoopMic;
            if (isLoopMic && RadioNewPresenter.this.isPageSupportReuse()) {
                RadioNewPresenter.this.preloadSeatView(0L);
            }
        }

        public void onSeatUpdate(List<SeatUser> seatUserList) {
            if (RadioNewPresenter.this.isDestroyed()) {
                return;
            }
            RadioNewPresenter.this.removeSeatUpdateListener();
            if (this.isLoopMic) {
                if (seatUserList == null || seatUserList.isEmpty() || seatUserList.get((int)0).uid == 0L) {
                    RadioNewPresenter.this.onStreamVideoStoped();
                } else {
                    RadioNewPresenter.this.onSeatUpdateHaveUid(seatUserList.get((int)0).uid);
                }
            } else if (RadioNewPresenter.this.isPageSupportReuse() && seatUserList != null && !seatUserList.isEmpty()) {
                RadioNewPresenter.this.preloadSeatView(seatUserList.get((int)0).uid);
            }
        }
    }
}

