/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.sticker;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.sticker.base.StickerInfo;
import com.yy.hiyo.channel.plugins.radio.sticker.callback.IApplyStickerCallback;
import com.yy.hiyo.channel.plugins.radio.sticker.callback.IStickerViewCallback;
import com.yy.hiyo.pk.base.ui.dialog.InputCallback;
import com.yy.hiyo.pk.base.ui.dialog.PkInputDialog;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ihago.omega.api.stickies.ErrCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 02\u00020\u0001:\u00010B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0012\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010$\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\fJ\u0012\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\"H\u0016J\u0006\u0010(\u001a\u00020\u001dJ\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\fH\u0002J\u0010\u0010+\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\fJ\b\u0010,\u001a\u00020\u001dH\u0002J\b\u0010-\u001a\u00020\u001dH\u0002J\b\u0010.\u001a\u00020\u001dH\u0002J\b\u0010/\u001a\u00020\u001dH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/sticker/StickerView;", "Lcom/yy/base/memoryrecycle/views/YYConstraintLayout;", "context", "Landroid/content/Context;", "stickerInfo", "Lcom/yy/hiyo/channel/plugins/radio/sticker/base/StickerInfo;", "isLive", "", "callback", "Lcom/yy/hiyo/channel/plugins/radio/sticker/callback/IStickerViewCallback;", "(Landroid/content/Context;Lcom/yy/hiyo/channel/plugins/radio/sticker/base/StickerInfo;ZLcom/yy/hiyo/channel/plugins/radio/sticker/callback/IStickerViewCallback;)V", "dialogText", "", "value", "info", "getInfo", "()Lcom/yy/hiyo/channel/plugins/radio/sticker/base/StickerInfo;", "setInfo", "(Lcom/yy/hiyo/channel/plugins/radio/sticker/base/StickerInfo;)V", "mCallback", "mDialogView", "Lcom/yy/hiyo/pk/base/ui/dialog/PkInputDialog;", "mIsLive", "mMoveLimit", "", "mMoveX", "", "mMoveY", "changeVideoMode", "", "isVideoMode", "createView", "dispatchTouchEvent", "ev", "Landroid/view/MotionEvent;", "onInterceptTouchEvent", "onSend", "content", "onTouchEvent", "event", "resetPos", "setPos", "pos", "setText", "showInputDialog", "updateDimension", "updateInfo", "updatePos", "Companion", "radio_debug"})
public final class StickerView
extends YYConstraintLayout {
    private PkInputDialog mDialogView;
    private float mMoveX;
    private float mMoveY;
    private IStickerViewCallback mCallback;
    private String dialogText;
    private int mMoveLimit;
    @NotNull
    private StickerInfo info;
    private boolean mIsLive;
    private static final String TAG = "Sticker_StickerView";
    @NotNull
    public static final String INIT_POSITION = "25_150";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @NotNull
    public final StickerInfo getInfo() {
        return this.info;
    }

    public final void setInfo(@NotNull StickerInfo value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.info = value;
        this.updateInfo();
    }

    private final void createView() {
        this.updateDimension();
        ((YYTextView)this._$_findCachedViewById(R.id.tvContent)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ StickerView this$0;

            public final void onClick(View it) {
                if (StickerView.access$getMCallback$p(this.this$0).isOwnerOrAnchor()) {
                    StickerView.access$showInputDialog(this.this$0);
                    RadioUtils.INSTANCE.reportStickerEditClick(this.this$0.getInfo().getId());
                }
            }
            {
                this.this$0 = stickerView;
            }
        });
    }

    private final void showInputDialog() {
        block2: {
            if (this.mDialogView == null) {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                this.mDialogView = new PkInputDialog(context, new InputCallback(this){
                    final /* synthetic */ StickerView this$0;

                    public void onClickSave(@NotNull String msg, int type) {
                        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                        PkInputDialog pkInputDialog = StickerView.access$getMDialogView$p(this.this$0);
                        if (pkInputDialog != null) {
                            pkInputDialog.dismiss();
                        }
                        this.this$0.onSend(msg);
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
                this.dialogText = this.info.getContent();
            }
            PkInputDialog pkInputDialog = this.mDialogView;
            if (pkInputDialog != null) {
                pkInputDialog.updateType(131072, this.dialogText);
            }
            PkInputDialog pkInputDialog2 = this.mDialogView;
            if (pkInputDialog2 == null) break block2;
            pkInputDialog2.show();
        }
    }

    public final void onSend(@Nullable String content) {
        int n = this.info.getId();
        String string2 = this.info.getUrl();
        String string3 = content;
        if (string3 == null) {
            string3 = "";
        }
        StickerInfo stickerInfo = new StickerInfo(n, string2, string3, this.info.getPosition(), this.info.getAlign(), this.info.getSeqId());
        this.mCallback.onContentChanged(stickerInfo, new IApplyStickerCallback(this){
            final /* synthetic */ StickerView this$0;

            public void onSuccess(@NotNull StickerInfo sticker) {
                Intrinsics.checkParameterIsNotNull((Object)sticker, (String)"sticker");
                YYTextView yYTextView = (YYTextView)this.this$0._$_findCachedViewById(R.id.tvContent);
                Intrinsics.checkExpressionValueIsNotNull((Object)yYTextView, (String)"tvContent");
                yYTextView.setText((CharSequence)sticker.getContent());
                StickerView.access$setDialogText$p(this.this$0, sticker.getContent());
                this.this$0.getInfo().setContent(sticker.getContent());
            }

            public void onError(int code) {
                if (code == ErrCode.TABOO_TEXT.getValue()) {
                    ToastUtils.showToast((Context)this.this$0.getContext(), (int)R.string.toast_save_sticker_failed);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void setPos(String pos) {
        List posArray = TextUtils.isEmpty((CharSequence)pos) ? StringsKt.split$default((CharSequence)INIT_POSITION, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null) : (StringsKt.contains$default((CharSequence)pos, (CharSequence)"_", (boolean)false, (int)2, null) ? StringsKt.split$default((CharSequence)pos, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null) : StringsKt.split$default((CharSequence)pos, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null));
        this.info.setPosition(pos);
        this.setTranslationX(ResolutionUtils.dip2Px((float)StringUtils.safeParseFloat((String)((String)posArray.get(0)))));
        this.setTranslationY(ResolutionUtils.dip2Px((float)StringUtils.safeParseFloat((String)((String)posArray.get(1)))));
    }

    public final void resetPos() {
        this.setPos(INIT_POSITION);
    }

    public final void changeVideoMode(boolean isVideoMode) {
        this.mIsLive = isVideoMode;
        this.updateDimension();
    }

    private final void updateDimension() {
        int n;
        if (this.mIsLive) {
            ScreenUtils screenUtils = ScreenUtils.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils, (String)"ScreenUtils.getInstance()");
            n = (int)((double)screenUtils.getWidthPixels() * 0.417);
        } else {
            ScreenUtils screenUtils = ScreenUtils.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils, (String)"ScreenUtils.getInstance()");
            n = (int)((double)screenUtils.getWidthPixels() * 0.417 * 0.8);
        }
        int width = n;
        ConstraintLayout.LayoutParams layoutParams = new ConstraintLayout.LayoutParams(width, width / 3);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        float radio = this.mIsLive ? 1.0f : 0.8f;
        ((YYTextView)this._$_findCachedViewById(R.id.tvContent)).setAutoSizeTextTypeUniformWithConfiguration((int)((float)9 * radio), (int)((float)12 * radio), 1, 1);
    }

    private final void updateInfo() {
        if (this.info.getId() == 1) {
            ImageLoader.loadImage((ImageView)((RecycleImageView)this._$_findCachedViewById(R.id.ivBg)), (String)this.info.getUrl(), (int)R.drawable.icon_sticker_inner);
        } else {
            ImageLoader.loadImage((ImageView)((RecycleImageView)this._$_findCachedViewById(R.id.ivBg)), (String)this.info.getUrl());
        }
        YYTextView yYTextView = (YYTextView)this._$_findCachedViewById(R.id.tvContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYTextView, (String)"tvContent");
        ViewGroup.LayoutParams layoutParams = yYTextView.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
        switch (this.info.getAlign()) {
            case 0: {
                layoutParams2.horizontalBias = 0.5f;
                break;
            }
            case 1: {
                layoutParams2.horizontalBias = 0.786f;
                break;
            }
        }
        this.setText(this.info.getContent());
        this.setPos(this.info.getPosition());
    }

    public final void setText(@Nullable String content) {
        YYTextView yYTextView = (YYTextView)this._$_findCachedViewById(R.id.tvContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYTextView, (String)"tvContent");
        String string2 = content;
        yYTextView.setText(string2 != null ? (CharSequence)string2 : (CharSequence)"");
    }

    public boolean onInterceptTouchEvent(@Nullable MotionEvent ev) {
        Integer n;
        MotionEvent motionEvent = ev;
        Integer n2 = n = motionEvent != null ? Integer.valueOf(motionEvent.getAction()) : null;
        int n3 = 0;
        if (n2 != null && n2 == 0) {
            this.mMoveX = ev.getX();
            this.mMoveY = ev.getY();
        } else {
            Integer n4 = n;
            n3 = 2;
            if (n4 != null && n4 == n3) {
                double d = ev.getX() - this.mMoveX;
                double d2 = 2.0;
                boolean bl = false;
                double d3 = Math.pow(d, d2);
                d = ev.getY() - this.mMoveY;
                d2 = 2.0;
                double d4 = d3;
                bl = false;
                double d5 = Math.pow(d, d2);
                d = d4 + d5;
                boolean bl2 = false;
                int move = (int)Math.sqrt(d);
                return move > this.mMoveLimit;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        block1: {
            block4: {
                int n;
                Integer n2;
                block3: {
                    boolean isLimit;
                    int[] limit;
                    block2: {
                        if (!this.mCallback.isOwnerOrAnchor()) break block1;
                        limit = this.mCallback.getLimit();
                        MotionEvent motionEvent = event;
                        Integer n3 = n2 = motionEvent != null ? Integer.valueOf(motionEvent.getAction()) : null;
                        n = 0;
                        if (n3 == null || n3 != 0) break block2;
                        this.mMoveX = event.getX();
                        this.mMoveY = event.getY();
                        break block1;
                    }
                    Integer n4 = n2;
                    n = 2;
                    if (n4 == null || n4 != n) break block3;
                    float toX = this.getX() + (event.getX() - this.mMoveX);
                    float toY = this.getY() + (event.getY() - this.mMoveY);
                    boolean bl = LanguageUtils.isLtr() ? toY + (float)this.getHeight() >= (float)limit[1] && toX <= (float)limit[0] : (isLimit = toY + (float)this.getHeight() >= (float)limit[1] && toX + (float)this.getWidth() >= (float)limit[0]);
                    if (this.mIsLive || !isLimit) {
                        this.setTranslationX(toX);
                        this.setTranslationY(toY);
                        this.updatePos();
                    }
                    this.mCallback.onStickerMoving(this.info);
                    break block1;
                }
                Integer n5 = n2;
                n = 1;
                if (n5 != null && n5 == n) break block4;
                Integer n6 = n2;
                n = 3;
                if (n6 == null || n6 != n) break block1;
            }
            this.updatePos();
            this.mCallback.onStickerPosChanged(this.info);
            RadioUtils.INSTANCE.reportDragSticker(this.info.getId());
        }
        return true;
    }

    private final void updatePos() {
        int xDp = ResolutionUtils.px2Dip((int)((int)this.getTranslationX()));
        int yDp = ResolutionUtils.px2Dip((int)((int)this.getTranslationY()));
        String string2 = String.valueOf(xDp) + "_" + String.valueOf(yDp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder(xDp.toStri\u2026Dp.toString()).toString()");
        String pos = string2;
        this.info.setPosition(pos);
    }

    public boolean dispatchTouchEvent(@Nullable MotionEvent ev) {
        ViewParent viewParent = this.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)viewParent, (String)"parent");
        viewParent.getParent().requestDisallowInterceptTouchEvent(true);
        return super.dispatchTouchEvent(ev);
    }

    public StickerView(@NotNull Context context, @NotNull StickerInfo stickerInfo, boolean isLive, @NotNull IStickerViewCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)stickerInfo, (String)"stickerInfo");
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        super(context);
        this.dialogText = "";
        this.mMoveLimit = ResolutionUtils.dip2Px((float)6.0f);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_sticker_view, (ViewGroup)this);
        this.setInfo(stickerInfo);
        this.mIsLive = isLive;
        this.mCallback = callback2;
        this.createView();
    }

    public static final /* synthetic */ IStickerViewCallback access$getMCallback$p(StickerView $this) {
        return $this.mCallback;
    }

    public static final /* synthetic */ void access$setMCallback$p(StickerView $this, IStickerViewCallback iStickerViewCallback) {
        $this.mCallback = iStickerViewCallback;
    }

    public static final /* synthetic */ void access$showInputDialog(StickerView $this) {
        $this.showInputDialog();
    }

    public static final /* synthetic */ PkInputDialog access$getMDialogView$p(StickerView $this) {
        return $this.mDialogView;
    }

    public static final /* synthetic */ void access$setMDialogView$p(StickerView $this, PkInputDialog pkInputDialog) {
        $this.mDialogView = pkInputDialog;
    }

    public static final /* synthetic */ String access$getDialogText$p(StickerView $this) {
        return $this.dialogText;
    }

    public static final /* synthetic */ void access$setDialogText$p(StickerView $this, String string2) {
        $this.dialogText = string2;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/sticker/StickerView$Companion;", "", "()V", "INIT_POSITION", "", "TAG", "radio_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

