/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio;

import android.content.Context;
import android.os.Message;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.FacePoint;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.R;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.anchorfansclub.IFansClubService;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsChannelWindow;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.IAbsPageCallBack;
import com.yy.hiyo.channel.cbase.IPluginCallBack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.radio.IRadioLiveEndPresenter;
import com.yy.hiyo.channel.cbase.module.radio.IRadioModulePresenter;
import com.yy.hiyo.channel.cbase.module.radio.IRadioPage;
import com.yy.hiyo.channel.cbase.module.radio.IVideoLinkMicPresenter;
import com.yy.hiyo.channel.cbase.module.radio.config.LiveConfigPresenter;
import com.yy.hiyo.channel.cbase.module.radio.screen.ScreenSwipeHelper;
import com.yy.hiyo.channel.cbase.module.videopk.H5VideoPkParam;
import com.yy.hiyo.channel.cbase.utils.perf.ChannelPathLog;
import com.yy.hiyo.channel.cbase.view.VerticalSlidingLayout;
import com.yy.hiyo.channel.component.announcement.NoticePresenter;
import com.yy.hiyo.channel.component.base.ProxyPresenter;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.channelswipe.PreCreateRadioPage;
import com.yy.hiyo.channel.component.contribution.GiftContributionPresenter;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.voiceroom.VoiceRoomInvitePresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.IOperationStrategy;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardPresenter;
import com.yy.hiyo.channel.component.seat.SeatLocationPresenter;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.theme.ThemePresenter;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.channel.component.topact.ChannelTLCornerActPresenter;
import com.yy.hiyo.channel.component.topbar.TopPresenter;
import com.yy.hiyo.channel.module.follow.FollowPresenter;
import com.yy.hiyo.channel.module.main.ChannelWindow;
import com.yy.hiyo.channel.module.publicspeak.ScreenSpeakGuidePresenter;
import com.yy.hiyo.channel.plugins.base.CommonStylePage;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.RadioJsEventPresenter;
import com.yy.hiyo.channel.plugins.radio.RadioNAB;
import com.yy.hiyo.channel.plugins.radio.RadioNewPresenter;
import com.yy.hiyo.channel.plugins.radio.RadioPage;
import com.yy.hiyo.channel.plugins.radio.RadioPresenter;
import com.yy.hiyo.channel.plugins.radio.RadioUtil;
import com.yy.hiyo.channel.plugins.radio.bottom.RadioBottomPresenterV2;
import com.yy.hiyo.channel.plugins.radio.bottommore.RadioBottomMorePresenter;
import com.yy.hiyo.channel.plugins.radio.bottommore.RadioProxyPresenter;
import com.yy.hiyo.channel.plugins.radio.bubble.BubblePresenter;
import com.yy.hiyo.channel.plugins.radio.end.RadioLiveEndPresenter;
import com.yy.hiyo.channel.plugins.radio.fansclub.FansClubGuidePresenter;
import com.yy.hiyo.channel.plugins.radio.fansclub.FansClubPresenter;
import com.yy.hiyo.channel.plugins.radio.forecast.ForeCastPresenter;
import com.yy.hiyo.channel.plugins.radio.ktv.VideoLyricViewModel;
import com.yy.hiyo.channel.plugins.radio.previewsnapshot.PreviewSnapShotPresenter;
import com.yy.hiyo.channel.plugins.radio.screenrecord.CaptureScreenPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatPresenter;
import com.yy.hiyo.channel.plugins.radio.star.StarEntryVM;
import com.yy.hiyo.channel.plugins.radio.sticker.StickerPresenter;
import com.yy.hiyo.channel.plugins.radio.video.VideoFollowPresenter;
import com.yy.hiyo.channel.plugins.radio.video.VideoPkPresenter;
import com.yy.hiyo.channel.plugins.radio.video.VideoPresenter;
import com.yy.hiyo.channel.plugins.radio.video.live.LiveHeartBeatMonitorPresenter;
import com.yy.hiyo.channel.plugins.radio.video.live.RadioLiveHeartBeatPresenter;
import com.yy.hiyo.channel.plugins.radio.video.top.RadioGiftContributionPresenter;
import com.yy.hiyo.channel.plugins.radio.video.top.RadioNoticePresenter;
import com.yy.hiyo.channel.plugins.radio.video.top.RadioTLCornerActPresenter;
import com.yy.hiyo.channel.plugins.radio.video.top.RadioTopBarPresenter;
import com.yy.hiyo.channel.plugins.radio.voice.VoicePresenter;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.channel.plugins.voiceroom.AbsVoiceRoomPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.RoomPageContext;
import com.yy.hiyo.channel.plugins.voiceroom.base.bottombar.more.BottomMorePresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.radio.IRadioPluginPresenter;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.webservice.event.IJsEventCallback;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

public class RadioPlugin
extends AbsVoiceRoomPlugin {
    public String logTag = "RadioPlugin";
    private RadioNewPresenter mPresenter;
    private AbsRoomPage radioPage;
    @Nullable
    private RadioPage tempCachePage;
    private boolean presenterRealExecuted;

    public RadioPlugin(@NotNull IChannel channel, @NotNull EnterParam enterParam, @NotNull ChannelPluginData pluginData, @NotNull Environment env, @NotNull IPluginCallBack pluginCallback) {
        super(channel, enterParam, pluginData, env, pluginCallback);
        this.logTag = "RadioPlugin_" + channel.getChannelId();
    }

    @NotNull
    protected Class<? extends AbsPluginPresenter> getPluginPresenterClass() {
        return RadioPresenter.class;
    }

    @NotNull
    protected RoomPageContext createPageContext(@NotNull ChannelPluginData pluginData) {
        RoomPageContext pageContext = (RoomPageContext)super.createPageContext(pluginData);
        if (RadioUtil.INSTANCE.isSupportPageReuse()) {
            BaseChannelPresenter.Companion.setCurMvpContextCache(new WeakReference<RoomPageContext>(pageContext));
        }
        return pageContext;
    }

    protected void initPresenter(@NotNull AbsRoomPage page, @NotNull RoomPageContext mvpContext) {
        this.radioPage = page;
        this.initSnapshot(page, mvpContext);
        this.initTheme(page, mvpContext);
        MLog.info((Object)this.logTag, (String)"initPresenter", (Object[])new Object[0]);
        this.mPresenter = (RadioNewPresenter)mvpContext.getPresenter(RadioNewPresenter.class);
        this.mPresenter.init(new RadioNewPresenter.ICallBack(){

            @Override
            public void onVideoStarted() {
                MLog.info((Object)RadioPlugin.this.logTag, (String)"onVideoStarted", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RadioPlugin.this.initPresenterReal();
                    }
                }, (long)500L);
            }

            @Override
            public void onVideoStoped() {
                MLog.info((Object)RadioPlugin.this.logTag, (String)"onVideoStoped", (Object[])new Object[0]);
                RadioPlugin.this.initPresenterReal();
            }

            @Override
            public void ensurePresentersInit() {
                MLog.info((Object)RadioPlugin.this.logTag, (String)"ensureOtherPresentersInit", (Object[])new Object[0]);
                RadioPlugin.this.initPresenterReal();
            }

            @Override
            public boolean isPresentersInited() {
                return RadioPlugin.this.presenterRealExecuted;
            }

            @Override
            public void onWindowShown() {
                MLog.info((Object)RadioPlugin.this.logTag, (String)"onWindowShown", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RadioPlugin.this.initPresenterReal();
                    }
                }, (long)3000L);
            }
        });
    }

    private void initSnapshot(@NotNull AbsRoomPage page, @NotNull RoomPageContext mvpContext) {
        ((PreviewSnapShotPresenter)mvpContext.getPresenter(PreviewSnapShotPresenter.class)).setContainer(page.findViewById(R.id.snapHolder));
    }

    private void initTheme(@NotNull AbsRoomPage page, @NotNull RoomPageContext mvpContext) {
        ((ThemePresenter)mvpContext.getPresenter(ThemePresenter.class)).setContainer(page.findViewById(R.id.themeHolder));
        ((ThemePresenter)mvpContext.getPresenter(ThemePresenter.class)).getModeTheme().setValue((Object)new DrawableResThemeBean(R.drawable.bg_black_cc));
    }

    private void initPresenterReal() {
        if (this.mPresenter.isDestroyed() || this.presenterRealExecuted) {
            return;
        }
        MLog.info((Object)this.logTag, (String)"initPresenterReal", (Object[])new Object[0]);
        this.presenterRealExecuted = true;
        super.initPresenter((CommonStylePage)this.radioPage, (IChannelPageContext)((RoomPageContext)this.getMvpContext()));
        this.mPresenter.setPresenterRealExecuted();
        this.reportHeartBeatData();
    }

    protected void initFinalPresenter(@NotNull AbsRoomPage page, @NotNull RoomPageContext mvpContext) {
        MLog.info((Object)this.logTag, (String)"initFinalPresenter", (Object[])new Object[0]);
        super.initFinalPresenter((CommonStylePage)page, (IChannelPageContext)mvpContext);
        mvpContext.getPresenter(IRadioModulePresenter.class);
        ((RadioPresenter)mvpContext.getPresenter(RadioPresenter.class)).setDebugInfo();
        mvpContext.getPresenter(ScreenSpeakGuidePresenter.class);
        mvpContext.getPresenter(VideoPresenter.class);
        mvpContext.getPresenter(VoicePresenter.class);
        mvpContext.getPresenter(RadioJsEventPresenter.class);
        mvpContext.getPresenter(RadioLiveEndPresenter.class);
        mvpContext.getPresenter(CaptureScreenPresenter.class);
        mvpContext.getPresenter(FansClubPresenter.class);
        if (mvpContext.getChannel().getOwnerUid() == AccountUtil.getUid()) {
            mvpContext.getViewModel(StarEntryVM.class);
        }
        mvpContext.getPresenter(LiveHeartBeatMonitorPresenter.class);
        mvpContext.getViewModel(VideoLyricViewModel.class);
        mvpContext.getPresenter(ForeCastPresenter.class);
        mvpContext.getPresenter(FansClubGuidePresenter.class);
    }

    public long getFinalPresenteDelayTime() {
        if (this.mPresenter.isVideoMode()) {
            if (this.mPresenter.isVideoStart()) {
                return 500L;
            }
            return 1000L;
        }
        return 500L;
    }

    @NotNull
    protected Function0<Map<Class<? extends ViewModel>, Class<? extends ViewModel>>> createPresenterClassInterceptor() {
        return () -> {
            LinkedHashMap<Class<LiveHeartBeatMonitorPresenter>, Class<Object>> map = new LinkedHashMap<Class<LiveHeartBeatMonitorPresenter>, Class<Object>>();
            Map su = (Map)super.createPresenterClassInterceptor().invoke();
            if (su != null) {
                map.putAll(su);
            }
            map.put(AbsPluginPresenter.class, this.getPluginPresenterClass());
            map.put(SeatPresenter.class, RadioSeatPresenter.class);
            map.put(ProfileCardPresenter.class, VoiceRoomProfileCardPresenter.class);
            map.put(InvitePresenter.class, VoiceRoomInvitePresenter.class);
            map.put(ProxyPresenter.class, RadioProxyPresenter.class);
            map.put(BottomMorePresenter.class, RadioBottomMorePresenter.class);
            map.put(TopPresenter.class, RadioTopBarPresenter.class);
            map.put(LiveConfigPresenter.class, LiveConfigPresenter.class);
            map.put(BottomPresenter.class, RadioBottomPresenterV2.class);
            map.put(GiftContributionPresenter.class, RadioGiftContributionPresenter.class);
            map.put(FollowPresenter.class, VideoFollowPresenter.class);
            map.put(NoticePresenter.class, RadioNoticePresenter.class);
            map.put(ChannelTLCornerActPresenter.class, RadioTLCornerActPresenter.class);
            map.put(IVideoLinkMicPresenter.class, VideoPkPresenter.class);
            map.put(IRadioPluginPresenter.class, RadioPresenter.class);
            map.put(IRadioLiveEndPresenter.class, RadioLiveEndPresenter.class);
            map.put(LiveHeartBeatMonitorPresenter.class, RadioLiveHeartBeatPresenter.class);
            return map;
        };
    }

    protected void initCommonPresenter(@NotNull AbsRoomPage page, @NotNull RoomPageContext mvpContext) {
        super.initCommonPresenter((CommonStylePage)page, (IChannelPageContext)mvpContext);
        MLog.info((Object)this.logTag, (String)"initCommonPresenter", (Object[])new Object[0]);
        if (this.haveSelfFaceLocation()) {
            ((SeatLocationPresenter)mvpContext.getPresenter(SeatLocationPresenter.class)).setSeatLocationMutable(this.getFaceLocation());
        }
        ((StickerPresenter)mvpContext.getPresenter(StickerPresenter.class)).setContainer(page.getPageView().findViewById(R.id.stickerHolder));
        if (RadioNAB.INSTANCE.isOpenBubble()) {
            ((BubblePresenter)mvpContext.getPresenter(BubblePresenter.class)).setContainer(page.getPageView().findViewById(R.id.touchBubbleLayout));
        }
        ((ProfileCardPresenter)mvpContext.getPresenter(ProfileCardPresenter.class)).setOperationStrategy(new IOperationStrategy(){

            public boolean canOpSeat() {
                return false;
            }

            public boolean canOpMic() {
                return true;
            }

            public boolean canOpVideo() {
                return false;
            }
        });
    }

    public boolean haveSelfFaceLocation() {
        return true;
    }

    @NotNull
    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return ((SeatPresenter)this.getMvpContext().getPresenter(SeatPresenter.class)).getRealRelSeatMapLocation();
    }

    @NotNull
    protected AbsRoomPage createPage(@NotNull AbsChannelWindow window) {
        ChannelPathLog.getEnterChannelLogger((String)this.getChannelId()).add("createPage", new Object[0]);
        RadioPage page = null;
        IRadioPage prePage = PreCreateRadioPage.INSTANCE.getPreCreateRadioPage(this.getChannelId());
        if (prePage instanceof RadioPage) {
            page = (RadioPage)prePage;
        }
        if (page != null) {
            MLog.info((Object)"ReusedPage", (String)"createPage cache page:%d", (Object[])new Object[]{page.hashCode()});
            page.updateWindow(window, (IAbsPageCallBack)this);
            PreCreateRadioPage.INSTANCE.destroyRp(this.getChannelId());
        } else {
            prePage = PreCreateRadioPage.INSTANCE.getReuseCacheRadioPage();
            if (prePage instanceof RadioPage) {
                page = (RadioPage)prePage;
            }
            if (page != null) {
                MLog.info((Object)"ReusedPage", (String)"reuse page:%d", (Object[])new Object[]{page.hashCode()});
                page.updateWindow(window, (IAbsPageCallBack)this);
            } else {
                page = new RadioPage(window, (IAbsPageCallBack)this);
                MLog.info((Object)"ReusedPage", (String)"createPage new a page:%d", (Object[])new Object[]{page.hashCode()});
            }
        }
        page.setBackClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RadioPlugin.this.onBackClick();
            }
        });
        boolean isPageReuse = RadioUtil.INSTANCE.isSupportPageReuse();
        MLog.info((Object)this.logTag, (String)("createPage end, isPageReuse: " + isPageReuse), (Object[])new Object[0]);
        if (isPageReuse) {
            this.tempCachePage = page;
            this.tempCachePage.setSupportReuse(true);
        }
        this.initPageSwipeConfig(window, page);
        return page;
    }

    private void initPageSwipeConfig(AbsChannelWindow window, RadioPage page) {
        if (this.getChannel().getEnterParam().swipeEnd) {
            if (this.tempCachePage != null && this.tempCachePage.getScreenContainer().getVisibility() != 4) {
                this.tempCachePage.getScreenContainer().setVisibility(4);
            }
            ScreenSwipeHelper helper = new ScreenSwipeHelper();
            helper.initSwipeView(window.getContext(), page.getScreenContainer(), page.getPageView(), window.getExtLayer(), this.getChannel().getDataService());
            helper.setScreenSwipeContainerVisible(false);
            VerticalSlidingLayout layout2 = ((ChannelWindow)window).getSlidingLayout();
            if (layout2 != null) {
                layout2.setCanSetLimitArea(false);
            }
        }
    }

    public boolean onBackClick() {
        if (this.checkShowExitDialog()) {
            return true;
        }
        if (!this.getChannel().getSeatService().getSeatData().hasUserInSeat() && !this.getMvpContext().isDestroy() && ((RadioLiveEndPresenter)this.getMvpContext().getPresenter(RadioLiveEndPresenter.class)).isEndPageVisible()) {
            MLog.info((Object)"RadioPlugin", (String)"isEndPageVisible", (Object[])new Object[0]);
            this.sendMessage(AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL, -1, -1, this.getChannel().getChannelId());
            return true;
        }
        return super.onBackClick();
    }

    protected boolean checkShowExitDialog() {
        boolean isGroupParty = this.getChannel().getChannelDetail().baseInfo.isGroupParty();
        if ((!isGroupParty && this.getChannel().getRoleService().isMeOwner() || isGroupParty && this.getChannel().getRoleService().isMeAnchor()) && this.getChannel().getPluginService().getCurPluginData().isVideoMode()) {
            this.showExitDialog();
            return true;
        }
        return false;
    }

    protected void showExitDialog() {
        DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.getContext());
        OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_radio_video_back_dialog), (CharSequence)ResourceUtils.getString((int)R.string.btn_radio_video_back_dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.btn_radio_video_back_dialog_cancel), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                if (RadioPlugin.this.getChannel().getEnterParam().isFromChannelParty()) {
                    MLog.info((Object)"RadioPlugin", (String)"onOk SE_CHANNEL_PARTY", (Object[])new Object[0]);
                    RadioPlugin.this.sendMessage(AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL, -1, -1, RadioPlugin.this.getChannel().getChannelId());
                    String pid = RadioPlugin.this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo.pid;
                    RadioPlugin.this.openParentChannelAndParty(pid, false);
                } else {
                    MLog.info((Object)"RadioPlugin", (String)"onOk else", (Object[])new Object[0]);
                    RadioPlugin.this.sendMessage(AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL, -1, -1, RadioPlugin.this.getChannel().getChannelId());
                }
            }
        });
        dialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    public void handleMessageInner(@NotNull Message msg) {
        super.handleMessageInner(msg);
        if (msg.what == ChannelMsgDef.OPEN_VIDEO_PK_PANEL) {
            if (msg.obj instanceof IJsEventCallback) {
                ((RadioJsEventPresenter)this.getMvpContext().getPresenter(RadioJsEventPresenter.class)).openVideoPkInviteList((IJsEventCallback)msg.obj);
            }
        } else if (msg.what == ChannelMsgDef.START_VIDEO_PK_MATCH && msg.obj instanceof H5VideoPkParam) {
            ((RadioJsEventPresenter)this.getMvpContext().getPresenter(RadioJsEventPresenter.class)).startRandomMatch((H5VideoPkParam)msg.obj);
        }
    }

    public void onInitAfter() {
        super.onInitAfter();
        ((IKtvLiveServiceExtend)this.getServiceManager().getService(IKtvLiveServiceExtend.class)).setIsVideoMode(true);
    }

    private void reportHeartBeatData() {
        ChannelDetailInfo info = this.getChannel().getDataService().getCacheDetail();
        if (info != null) {
            if (info.baseInfo.carouselType > 0) {
                RuntimeContext.setShowType((String)this.getChannelId(), (String)(info.baseInfo.carouselType + ""));
            } else {
                RuntimeContext.setShowType((String)this.getChannelId(), (String)"3");
            }
        }
    }

    public void preDestroy() {
        super.preDestroy();
        if (this.presenterRealExecuted && this.tempCachePage != null && this.tempCachePage.isSupportReuse()) {
            ((ProxyPresenter)this.getMvpContext().getPresenter(ProxyPresenter.class)).getChannelListDrawerCallback().closeChannelListDrawer(false);
        }
        RuntimeContext.setShowAnchor((String)this.getChannelId(), (String)"");
        RuntimeContext.setShowType((String)this.getChannelId(), (String)"");
        ((IFansClubService)ServiceManagerProxy.getService(IFansClubService.class)).resetRechargeDialogState();
    }

    public void destroy() {
        MLog.info((Object)this.logTag, (String)"destroy", (Object[])new Object[0]);
        super.destroy();
        if (this.tempCachePage != null && this.tempCachePage.isSupportReuse()) {
            try {
                this.tempCachePage.resetViewState();
            }
            catch (Exception e) {
                MLog.error((Object)this.logTag, (String)"destroy", (Throwable)e, (Object[])new Object[0]);
            }
            this.tempCachePage.updateWindow(null, null);
            PreCreateRadioPage.INSTANCE.setReuseCacheRadioPage((IRadioPage)this.tempCachePage);
            this.tempCachePage.setBackClickListener(null);
        }
        this.tempCachePage = null;
        this.radioPage = null;
    }
}

