/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.push;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.HardwareUtils;
import com.yy.pushsvc.executor.IPushTaskExecutor;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class PushExecutor
implements IPushTaskExecutor {
    private static final String Tag = "PushExecutor";
    private static int MAX_CONCURRENCY_TASKS;
    private AtomicInteger mCurrentActiveTasks = new AtomicInteger(0);
    private ArrayList<PushRunnable> mRunnablesToPost = new ArrayList();

    private void onTaskFinished(PushRunnable pushRunnable) {
        this.mCurrentActiveTasks.decrementAndGet();
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        PushRunnable pushRunnable = null;
        PushExecutor pushExecutor = this;
        synchronized (pushExecutor) {
            if (this.mRunnablesToPost.size() > 0 && this.mCurrentActiveTasks.get() < MAX_CONCURRENCY_TASKS) {
                pushRunnable = this.mRunnablesToPost.get(0);
                this.mRunnablesToPost.remove(0);
                if (pushRunnable != null) {
                    this.mCurrentActiveTasks.incrementAndGet();
                }
            }
        }
        if (pushRunnable != null) {
            pushRunnable.postRunnable();
        }
    }

    public void postToMainThread(Runnable runnable, long l) {
        YYTaskExecutor.postToMainThread((Runnable)runnable, (long)l);
    }

    public void postIdleRunnableToMainThread(Runnable runnable) {
        YYTaskExecutor.postIdleRunnableToMainThread((Runnable)runnable);
    }

    public void removeRunnableFromMainThread(Runnable runnable) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)runnable);
    }

    public boolean isMainThread() {
        return YYTaskExecutor.isMainThread();
    }

    public com.yy.pushsvc.executor.IQueueTaskExecutor createAQueueExcuter() {
        return new PushAQueueExcuter();
    }

    public void execute(Runnable runnable, long l) {
        this.execute(runnable, null, -1L, 10);
    }

    public void execute(Runnable runnable, long l, int n) {
        this.execute(runnable, null, l, 10);
    }

    public void execute(Runnable runnable, Runnable runnable2, long l) {
        this.execute(runnable, runnable2, l, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, Runnable runnable2, long l, int n) {
        PushExecutor pushExecutor = this;
        synchronized (pushExecutor) {
            this.mRunnablesToPost.add(new PushRunnable(runnable, runnable2, l, n));
        }
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Runnable runnable) {
        PushRunnable pushRunnable = null;
        PushExecutor pushExecutor = this;
        synchronized (pushExecutor) {
            if (this.mRunnablesToPost.size() > 0) {
                for (PushRunnable pushRunnable2 : this.mRunnablesToPost) {
                    if (pushRunnable2 == null || pushRunnable2.mRunnable != runnable) continue;
                    pushRunnable = pushRunnable2;
                    break;
                }
            }
            if (pushRunnable != null) {
                this.mRunnablesToPost.remove(pushRunnable);
                this.mCurrentActiveTasks.decrementAndGet();
            }
        }
        if (pushRunnable != null) {
            pushRunnable.removeRunnable();
        }
    }

    static {
        int n = MAX_CONCURRENCY_TASKS = HardwareUtils.getCpuCoreCount() > 4 ? 6 : 4;
        if (PageResponse.isNewTaskPriorityEnable()) {
            MAX_CONCURRENCY_TASKS = HardwareUtils.getCpuCoreCount() > 4 && RuntimeContext.sPhoneType > 1 ? 3 : 2;
        }
    }

    private static class PushAQueueExcuter
    implements com.yy.pushsvc.executor.IQueueTaskExecutor {
        IQueueTaskExecutor mTaskExecutor = YYTaskExecutor.createAQueueExcuter();

        public void execute(Runnable runnable, long l) {
            this.mTaskExecutor.execute(runnable, l);
        }

        public void execute(Runnable runnable, long l, int n) {
            this.mTaskExecutor.execute(runnable, l, n);
        }

        public void execute(Runnable runnable, Runnable runnable2, long l) {
            this.mTaskExecutor.execute(runnable, runnable2, l);
        }

        public void execute(Runnable runnable, Runnable runnable2, long l, int n) {
            this.mTaskExecutor.execute(runnable, runnable2, l, n);
        }

        public void removeTask(Runnable runnable) {
            this.mTaskExecutor.removeTask(runnable);
        }
    }

    private class PushRunnable
    implements Runnable {
        Runnable mRunnable;
        private Runnable mMainRunnable;
        private long mDelayTime = -1L;
        private int mThePriority;

        public PushRunnable(Runnable runnable, Runnable runnable2, long l, int n) {
            this.mRunnable = runnable;
            this.mMainRunnable = runnable2;
            this.mDelayTime = l;
            this.mThePriority = n;
        }

        void postRunnable() {
            YYTaskExecutor.execute((Runnable)this.mRunnable, (Runnable)this.mMainRunnable, (long)this.mDelayTime, (int)this.mThePriority);
        }

        void removeRunnable() {
            YYTaskExecutor.removeTask((Runnable)this.mRunnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                try {
                    if (this.mRunnable != null) {
                        this.mRunnable.run();
                    }
                    PushExecutor.this.onTaskFinished(this);
                    if (!RuntimeContext.sIsDebuggable || this.mRunnable == null) break block8;
                    PushExecutor pushExecutor = PushExecutor.this;
                    synchronized (pushExecutor) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PushExecutor.Tag, (String)("onTaskFinished:" + this.mRunnable + "  RunnablesToPost" + PushExecutor.this.mRunnablesToPost.size()), (Object[])new Object[0]);
                        }
                    }
                }
                catch (Throwable throwable) {
                    PushExecutor.this.onTaskFinished(this);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PushExecutor.Tag, (String)("onTaskFinished:" + this.mRunnable + " error:" + throwable), (Object[])new Object[0]);
                    }
                    throw throwable;
                }
            }
        }
    }
}

