/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import android.os.Message;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import androidx.annotation.NonNull;
import biz.IMMsgItem;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.util.StringLengthUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.bbs.base.bean.TagBean;
import com.yy.hiyo.bbs.base.callback.IGetTagCallback;
import com.yy.hiyo.bbs.base.service.ITopicService;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.PublicScreenThemeUtil;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SysMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "SysMsgTransform";
    private static final int[] hasClgMsgIds = new int[]{R.string.short_tips_clg, R.string.short_tips_clg1};
    private static final int[] noHasClgMsgIds = new int[]{R.string.short_tips_no_clg, R.string.short_tips_no_clg1, R.string.short_tips_no_clg2, R.string.short_tips_no_clg3};

    @Override
    public BaseImMsg transform(String msgId, IMMsgItem msgItem) {
        SysTextMsg msg = new SysTextMsg(super.transform(msgId, msgItem));
        this.transformContent(msgId, msg);
        return msg;
    }

    private void transformContent(String msgId, SysTextMsg msg) {
        block103: {
            List sectionList = msg.getSections();
            if (sectionList != null && !sectionList.isEmpty()) {
                MsgSection section = (MsgSection)sectionList.get(0);
                String content = section.getContent();
                String extention = section.getExtention();
                int type = section.getType();
                if ((RuntimeContext.isInGray() || !MLog.isLogLevelAboveDebug()) && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"type:%d, content:%s, extends:%s", (Object[])new Object[]{type, content, extention});
                }
                if (type == 1) {
                    msg.setSysMsg((CharSequence)content);
                } else if (type == 1003) {
                    NotifyDataDefine.SetName theData = (NotifyDataDefine.SetName)JsonParser.parseJsonObject((String)content, NotifyDataDefine.SetName.class);
                    NotifyDataDefine.Extention extention1 = SysMsgTransform.parseJsonObject(extention);
                    String nick = extention1.nick;
                    String channelNick = this.getChannelNick((BaseImMsg)msg);
                    if (!FP.empty((CharSequence)channelNick)) {
                        nick = channelNick;
                    }
                    if (theData != null && theData.type != 1 && extention1 != null) {
                        String sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_rename_group_msg, (Object[])new Object[]{nick, theData.name});
                        SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                        SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                        msg.setSysMsg((Spannable)spannableString);
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 1004) {
                    NotifyDataDefine.Extention extention1 = SysMsgTransform.parseJsonObject(extention);
                    String nick = extention1.nick;
                    String channelNick = this.getChannelNick((BaseImMsg)msg);
                    if (!FP.empty((CharSequence)channelNick)) {
                        nick = channelNick;
                    }
                    if (extention1 != null) {
                        String sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_change_announce, (Object[])new Object[]{nick});
                        SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                        SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                        msg.setSysMsg((Spannable)spannableString);
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 3605) {
                    if (msg.getFrom() == AccountUtil.getUid()) {
                        msg.setSysMsg((CharSequence)content);
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 1104) {
                    NotifyDataDefine.SpeakBan speakBan = (NotifyDataDefine.SpeakBan)JsonParser.parseJsonObject((String)content, NotifyDataDefine.SpeakBan.class);
                    NotifyDataDefine.Extention extention1 = SysMsgTransform.parseJsonObject(extention);
                    String nick = extention1.nick;
                    String channelNick = this.getChannelNick((BaseImMsg)msg);
                    if (!FP.empty((CharSequence)channelNick)) {
                        nick = channelNick;
                    }
                    String sysMsgTips = null;
                    if (speakBan == null || extention1 == null) {
                        msg.setValid(false);
                    } else if (speakBan.uid == AccountUtil.getUid()) {
                        sysMsgTips = ResourceUtils.getString((int)(speakBan.banned ? R.string.tips_channel_has_been_baned : R.string.tips_channel_has_been_unbaned), (Object[])new Object[]{nick});
                        SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                        SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                        msg.setSysMsg((Spannable)spannableString);
                    } else if (extention1.uid == AccountUtil.getUid()) {
                        sysMsgTips = ResourceUtils.getString((int)(speakBan.banned ? R.string.tips_channel_band_someone : R.string.tips_channel_unband_someone), (Object[])new Object[]{speakBan.nick});
                        SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                        SysMsgTransform.addNickSpan(speakBan.nick, speakBan.uid, spannableString, (BaseImMsg)msg);
                        msg.setSysMsg((Spannable)spannableString);
                    } else {
                        sysMsgTips = ResourceUtils.getString((int)(speakBan.banned ? R.string.tips_channel_someone_baned : R.string.tips_channel_someone_unbaned), (Object[])new Object[]{speakBan.nick, nick});
                        SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                        SysMsgTransform.addNickSpan(speakBan.nick, speakBan.uid, spannableString, (BaseImMsg)msg);
                        SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                        msg.setSysMsg((Spannable)spannableString);
                    }
                } else if (type == 1105) {
                    NotifyDataDefine.KickOff kickOff = (NotifyDataDefine.KickOff)JsonParser.parseJsonObject((String)content, NotifyDataDefine.KickOff.class);
                    NotifyDataDefine.Extention extention1 = SysMsgTransform.parseJsonObject(extention);
                    String nick = extention1.nick;
                    String channelNick = this.getChannelNick((BaseImMsg)msg);
                    if (!FP.empty((CharSequence)channelNick)) {
                        nick = channelNick;
                    }
                    if (kickOff != null && extention1 != null) {
                        String sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_kickooff_msg, (Object[])new Object[]{nick, kickOff.nick});
                        SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                        SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                        SysMsgTransform.addNickSpan(kickOff.nick, kickOff.uid, spannableString, (BaseImMsg)msg);
                        msg.setSysMsg((Spannable)spannableString);
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 1005) {
                    NotifyDataDefine.SetSpeakMode speakMode = (NotifyDataDefine.SetSpeakMode)JsonParser.parseJsonObject((String)content, NotifyDataDefine.SetSpeakMode.class);
                    NotifyDataDefine.Extention extention1 = SysMsgTransform.parseJsonObject(extention);
                    String nick = extention1.nick;
                    String channelNick = this.getChannelNick((BaseImMsg)msg);
                    if (!FP.empty((CharSequence)channelNick)) {
                        nick = channelNick;
                    }
                    String sysMsgTips = null;
                    if (speakMode != null && extention1 != null) {
                        if (speakMode.mode == 1) {
                            sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_speak_not_ban, (Object[])new Object[]{nick});
                            SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                            SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                            msg.setSysMsg((Spannable)spannableString);
                        } else if (speakMode.mode == 3) {
                            sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_speak_ban_all, (Object[])new Object[]{nick});
                            SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                            SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                            msg.setSysMsg((Spannable)spannableString);
                        } else if (speakMode.mode == 2) {
                            sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_speak_ban_tourist, (Object[])new Object[]{nick});
                            SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                            SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                            msg.setSysMsg((Spannable)spannableString);
                        } else {
                            msg.setValid(false);
                        }
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 1007) {
                    NotifyDataDefine.SetJoinChannelMode mode = (NotifyDataDefine.SetJoinChannelMode)JsonParser.parseJsonObject((String)content, NotifyDataDefine.SetJoinChannelMode.class);
                    NotifyDataDefine.Extention extention1 = SysMsgTransform.parseJsonObject(extention);
                    String sysMsgTips = null;
                    String nick = extention1.nick;
                    String channelNick = this.getChannelNick((BaseImMsg)msg);
                    if (!FP.empty((CharSequence)channelNick)) {
                        nick = channelNick;
                    }
                    if (mode != null && extention1 != null) {
                        if (mode.mode == 2) {
                            if (extention1.uid == AccountUtil.getUid()) {
                                sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_join_mode_you_open);
                                msg.setSysMsg((CharSequence)sysMsgTips);
                            } else {
                                sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_join_mode_someone_open, (Object[])new Object[]{nick});
                                SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                                SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                                msg.setSysMsg((Spannable)spannableString);
                            }
                        } else if (mode.mode == 1) {
                            if (extention1.uid == AccountUtil.getUid()) {
                                sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_join_mode_you_close);
                                msg.setSysMsg((CharSequence)sysMsgTips);
                            } else {
                                sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_join_mode_someone_close, (Object[])new Object[]{nick});
                                SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                                SysMsgTransform.addNickSpan(nick, extention1.uid, spannableString, (BaseImMsg)msg);
                                msg.setSysMsg((Spannable)spannableString);
                            }
                        } else {
                            msg.setValid(false);
                        }
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 1103) {
                    msg.setValid(false);
                } else if (type == 1107) {
                    NotifyDataDefine.UserRoleChange userRoleChange = (NotifyDataDefine.UserRoleChange)JsonParser.parseJsonObject((String)content, NotifyDataDefine.UserRoleChange.class);
                    if (userRoleChange != null && userRoleChange.oldRoleType == 1 && userRoleChange.roleType == 5) {
                        String sysMsgTips = null;
                        if (AccountUtil.getUid() == userRoleChange.uid) {
                            String nick = "";
                            if (userRoleChange.changedUserInfo != null) {
                                nick = userRoleChange.changedUserInfo.nick;
                            }
                            sysMsgTips = "3".equals(userRoleChange.type) ? ResourceUtils.getString((int)R.string.tips_channel_invite_by_member, (Object[])new Object[]{nick, userRoleChange.operatorUserInfo.nick}) : ResourceUtils.getString((int)R.string.tips_you_has_join);
                            msg.setSysMsg((CharSequence)sysMsgTips);
                            msg.setType(1);
                        } else {
                            String nick = "";
                            long uid = 0L;
                            if (userRoleChange.changedUserInfo != null) {
                                nick = userRoleChange.changedUserInfo.nick;
                                uid = userRoleChange.changedUserInfo.uid;
                            }
                            msg.setType(1);
                            if ("3".equals(userRoleChange.type)) {
                                sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_invite_by_member, (Object[])new Object[]{nick, userRoleChange.operatorUserInfo.nick});
                                msg.setSysMsg((CharSequence)sysMsgTips);
                            } else {
                                sysMsgTips = ResourceUtils.getString((int)R.string.tips_someone_has_join, (Object[])new Object[]{nick});
                                SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                                SysMsgTransform.addNickSpan(nick, uid, spannableString, (BaseImMsg)msg);
                                msg.setSysMsg((Spannable)spannableString);
                            }
                        }
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 1101) {
                    NotifyDataDefine.JoinApprove joinApprove = (NotifyDataDefine.JoinApprove)JsonParser.parseJsonObject((String)content, NotifyDataDefine.JoinApprove.class);
                    if (joinApprove != null) {
                        if (joinApprove.applyUserInfo == null) {
                            msg.setValid(false);
                        } else {
                            String nick = joinApprove.applyUserInfo.nick;
                            boolean accept = joinApprove.accept;
                            long uid = joinApprove.applyUserInfo.uid;
                            String sysMsgTips = "";
                            if (!accept) {
                                if (uid == AccountUtil.getUid()) {
                                    sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_you_join_reject);
                                    msg.setSysMsg((CharSequence)sysMsgTips);
                                } else {
                                    sysMsgTips = ResourceUtils.getString((int)R.string.tips_channel_join_reject, (Object[])new Object[]{nick});
                                    SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                                    SysMsgTransform.addNickSpan(nick, uid, spannableString, (BaseImMsg)msg);
                                    msg.setSysMsg((Spannable)spannableString);
                                }
                            } else {
                                msg.setValid(false);
                            }
                        }
                    } else {
                        msg.setValid(false);
                        MLog.error((Object)TAG, (String)"ESTJoinApprove!!!", (Object[])new Object[0]);
                    }
                } else if (type == 2003) {
                    try {
                        JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                        String sid = jsonObject.optString("sid");
                        String mid = jsonObject.optString("msgid");
                        int reportType = jsonObject.optInt("wtype", 0);
                        String nick = "";
                        if (reportType == 2) {
                            nick = jsonObject.optString("nick", "");
                        }
                        if (StringUtils.isEmpty((String)mid)) {
                            msg.setValid(false);
                            return;
                        }
                        if (reportType == 1) {
                            msg.setValid(false);
                            break block103;
                        }
                        if (reportType == 0) {
                            msg.setSysMsg((CharSequence)ResourceUtils.getString((int)R.string.tips_group_report_withdraw_msg));
                            break block103;
                        }
                        if (reportType == 2) {
                            String sysTips = ResourceUtils.getString((int)R.string.tips_group_user_withdraw_msg, (Object[])new Object[]{nick});
                            SpannableString spannableString = new SpannableString((CharSequence)sysTips);
                            SysMsgTransform.addNickSpan(nick, msg.getFrom(), spannableString, (BaseImMsg)msg);
                            msg.setSysMsg((Spannable)spannableString);
                            break block103;
                        }
                        msg.setValid(false);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        msg.setValid(false);
                        MLog.error((Object)"FTRoomGroupSigNotify", (String)"parse hide msg exception!!!content:%s", (Object[])new Object[]{content});
                    }
                } else if (type == 3106) {
                    NotifyDataDefine.Challenge challenge = (NotifyDataDefine.Challenge)JsonParser.parseJsonObject((String)content, NotifyDataDefine.Challenge.class);
                    if (challenge != null) {
                        String sysMsgTips = "";
                        if (challenge.type == 2) {
                            GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(challenge.gid);
                            String gameName = gameInfo != null ? gameInfo.getGname() : "";
                            sysMsgTips = ResourceUtils.getString((int)R.string.short_tips_clg_result, (Object[])new Object[]{StringLengthUtils.parseLongString((String)challenge.nick), gameName, StringLengthUtils.parseLongString((String)challenge.fNick)});
                        } else {
                            int index;
                            int stringId = 0;
                            if (challenge.type == 0) {
                                index = (int)(Math.random() * (double)hasClgMsgIds.length);
                                stringId = index < hasClgMsgIds.length ? hasClgMsgIds[index] : R.string.short_tips_clg;
                            }
                            if (challenge.type == 1) {
                                index = (int)(Math.random() * (double)noHasClgMsgIds.length);
                                stringId = index < noHasClgMsgIds.length ? noHasClgMsgIds[index] : R.string.short_tips_no_clg;
                            }
                            sysMsgTips = ResourceUtils.getString((int)stringId, (Object[])new Object[]{StringLengthUtils.parseLongString((String)challenge.nick)});
                        }
                        SpannableString spannableString = new SpannableString((CharSequence)sysMsgTips);
                        SysMsgTransform.addNickSpan(StringLengthUtils.parseLongString((String)challenge.nick), challenge.uid, spannableString, (BaseImMsg)msg);
                        SysMsgTransform.addNickSpan(StringLengthUtils.parseLongString((String)challenge.fNick), challenge.fUid, spannableString, (BaseImMsg)msg);
                        msg.setSysMsg((Spannable)spannableString);
                    } else {
                        msg.setValid(false);
                    }
                } else if (type == 1012) {
                    if (!FP.empty((CharSequence)content)) {
                        this.inflateTagUpdated(msg, content);
                    }
                } else if (type == 3752) {
                    if (!FP.empty((CharSequence)content)) {
                        msg.setSysMsg((CharSequence)content);
                    } else {
                        msg.setValid(false);
                    }
                } else {
                    msg.setValid(false);
                }
            } else {
                msg.setValid(false);
            }
        }
    }

    private void inflateTagUpdated(final SysTextMsg msg, String content) {
        try {
            JSONObject json = JsonParser.obtainJSONObject((String)content);
            JSONArray tagIds = json.optJSONArray("tags");
            if (tagIds == null || tagIds.length() <= 0) {
                MLog.debug((Object)TAG, (String)"inflateTagUpdated %s", (Object[])new Object[]{content});
                msg.setValid(false);
                return;
            }
            final String tagId = tagIds.optString(0, "");
            if (!FP.empty((CharSequence)tagId) && ServiceManagerProxy.hadInit() && ServiceManagerProxy.getServiceManager().hasRegisterService(ITopicService.class)) {
                ((ITopicService)ServiceManagerProxy.getServiceManager().getService(ITopicService.class)).getTag(tagId, new IGetTagCallback(){

                    public void onSuccess(@NotNull TagBean tagBean) {
                        String tagName = "#" + (tagBean != null ? tagBean.getMText() : "");
                        String text = ResourceUtils.getString((int)R.string.short_tips_channel_tag_changed, (Object[])new Object[]{tagName});
                        int start = text.indexOf(tagName);
                        int end = start + tagName.length();
                        if (start < 0 || end < 0 || start > end || end > text.length() - 1) {
                            MLog.error((Object)SysMsgTransform.TAG, (String)"inflateTagUpdated text:%s, tagBean:%s, start:%s,end:%s", (Object[])new Object[]{text, tagBean, start, end});
                            return;
                        }
                        SpannableString span = new SpannableString((CharSequence)text);
                        span.setSpan((Object)TextSpan.of().bold(true).color(-16739841).size(12).build(), start, end, 17);
                        span.setSpan((Object)ChainSpan.ClickSpan.of(() -> {
                            Message action = Message.obtain();
                            action.what = ActionDefine.TAG_CLICK;
                            action.obj = tagId;
                            msg.getIFuncBridge().onSpanClick(action);
                        }), start, end, 17);
                        msg.setSysMsg((Spannable)span);
                    }

                    public void onError() {
                        msg.setValid(false);
                    }
                });
            } else {
                msg.setValid(false);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"msg %s, content %s", (Throwable)e, (Object[])new Object[]{msg, content});
            msg.setValid(false);
        }
    }

    private String getChannelNick(BaseImMsg msg) {
        if (msg == null) {
            return "";
        }
        if (!msg.isShowChannelNick()) {
            return "";
        }
        return msg.getChannelNick();
    }

    public SysTextMsg transform(String msgId, BaseImMsg msgItem) {
        SysTextMsg msg = new SysTextMsg(msgItem);
        this.transformContent(msgId, msg);
        return msg;
    }

    public static void addNickSpan(String nick, long uid, SpannableString content, BaseImMsg msg) {
        if (StringUtils.isEmpty((String)nick) || content == null || content.length() == 0) {
            return;
        }
        ClickSpan clickableSpan2 = new ClickSpan(uid, msg);
        int nickStartIndex = content.toString().indexOf(nick);
        if (nickStartIndex >= 0) {
            int endIndex = nickStartIndex + nick.length();
            content.setSpan((Object)clickableSpan2, nickStartIndex, endIndex, 17);
            content.setSpan((Object)new ForegroundColorSpan(PublicScreenThemeUtil.INSTANCE.getSYSTEXTLightColor()), nickStartIndex, endIndex, 17);
        }
    }

    public static NotifyDataDefine.Extention parseJsonObject(String extention) {
        NotifyDataDefine.Extention extention1 = (NotifyDataDefine.Extention)JsonParser.parseJsonObject((String)extention, NotifyDataDefine.Extention.class);
        if (extention1 == null) {
            extention1 = new NotifyDataDefine.Extention();
        }
        if (extention1.nick == null) {
            extention1.nick = "";
        }
        return extention1;
    }

    private static class ClickSpan
    extends ClickableSpan {
        long uid;
        BaseImMsg msg;

        public ClickSpan(long uid, BaseImMsg msg) {
            this.uid = uid;
            this.msg = msg;
        }

        public void onClick(@NonNull View widget) {
            if (this.msg != null && this.msg.getIFuncBridge() != null) {
                this.msg.getIFuncBridge().onNickClick(this.uid, this.msg);
            }
        }

        public void updateDrawState(@NonNull TextPaint ds) {
            super.updateDrawState(ds);
            ds.setUnderlineText(false);
        }
    }
}

