/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import biz.IMMsgItem;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.cbase.publicscreen.msg.OutsideGameInviteMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.utils.ChannelMsgUtils;
import com.yy.hiyo.component.publicscreen.MsgItemFactory;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.List;
import org.json.JSONObject;

public class OutsideGameInviteMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "OutsideGameInviteMsgTransform";

    public OutsideGameInviteMsg transform(String msgId, IMMsgItem msgItem) {
        OutsideGameInviteMsg msg = new OutsideGameInviteMsg(super.transform(msgId, msgItem));
        this.transformContent(msg);
        return msg;
    }

    private void transformContent(OutsideGameInviteMsg msg) {
        boolean userful = msg.calculateDelay(MsgItemFactory.getServerTsOrLocalTs()) > 0L;
        List sections = msg.getSections();
        if (sections != null && !sections.isEmpty()) {
            MsgSection section = (MsgSection)sections.get(0);
            String content = section.getContent();
            if (StringUtils.isNotEmpty((String)content)) {
                try {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"invite msgId:%s, content: %s", (Object[])new Object[]{msg.getMsgId(), content});
                    }
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                    String gameId = jsonObject.optString("game_id");
                    String inviteId = jsonObject.optString("invite_id");
                    int template = jsonObject.optInt("template");
                    msg.setInviteId(inviteId);
                    msg.setGid(gameId);
                    msg.setTemplate(template);
                    GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                    msg.setGameInfo(gameInfo);
                    msg.setUseful(userful && !ChannelMsgUtils.invalidTeams.contains(msg.getInviteId()));
                    if (gameInfo == null) {
                        MLog.error((Object)TAG, (String)"game info:%s null, pkId:%s , pass the msg!!!", (Object[])new Object[]{gameId, inviteId});
                        msg.setValid(false);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"parse error!!!, msgId:%s, content:%s", (Object[])new Object[]{msg.getMsgId(), content});
                    msg.setValid(false);
                }
            } else {
                MLog.error((Object)TAG, (String)"content empty!!!", (Object[])new Object[0]);
                msg.setValid(false);
            }
        } else {
            MLog.error((Object)TAG, (String)"section empty!!!", (Object[])new Object[0]);
            msg.setValid(false);
        }
    }

    public OutsideGameInviteMsg transform(String msgId, BaseImMsg msgItem) {
        OutsideGameInviteMsg msg = new OutsideGameInviteMsg(msgItem);
        this.transformContent(msg);
        return msg;
    }
}

