/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import biz.IMMsgItem;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.MsgItemFactory;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.List;
import org.json.JSONObject;

public class GameInviteMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "InviteMsgTransform";

    public GameInviteMsg transform(String msgId, IMMsgItem msgItem) {
        GameInviteMsg msg = new GameInviteMsg(super.transform(msgId, msgItem));
        this.transformContent(msg);
        return msg;
    }

    private void transformContent(GameInviteMsg msg) {
        long ts = msg.getTs();
        long currentTs = MsgItemFactory.getServerTsOrLocalTs() / 1000L;
        long distance = currentTs - ts;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"game invite msg, msgId:%s, ts:%d, distance:%d", (Object[])new Object[]{msg.getMsgId(), ts, distance});
        }
        boolean hasSetInviteState = false;
        if (distance >= 30L) {
            msg.getGameInviteState().setState(4);
            hasSetInviteState = true;
        } else {
            msg.getGameInviteState().setCountDown(30 - (int)distance);
        }
        GameInfo gameInfo = null;
        List sections = msg.getSections();
        if (sections != null && !sections.isEmpty()) {
            MsgSection section = (MsgSection)sections.get(0);
            String content = section.getContent();
            if (StringUtils.isNotEmpty((String)content)) {
                try {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"invite msgId:%s, msg:%s", (Object[])new Object[]{msg.getMsgId(), msg});
                    }
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                    String gameId = jsonObject.optString("game_id");
                    String inviteId = jsonObject.optString("invite_id");
                    msg.setPkId(inviteId);
                    msg.getGameInviteState().setGameId(gameId);
                    gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                    if (gameInfo == null) {
                        MLog.error((Object)TAG, (String)"game info:%s null, pkId:%s , pass the msg!!!", (Object[])new Object[]{gameId, inviteId});
                        msg.setValid(false);
                    }
                    msg.getGameInviteState().setGameInfo(gameInfo);
                    if (!hasSetInviteState) {
                        boolean isSendByMe;
                        boolean bl = isSendByMe = msg.getFrom() == AccountUtil.getUid();
                        if (isSendByMe) {
                            msg.getGameInviteState().setState(3);
                        } else {
                            msg.getGameInviteState().setState(1);
                        }
                        hasSetInviteState = true;
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"parse error!!!, msgId:%s, content:%s", (Object[])new Object[]{msg.getMsgId(), content});
                    msg.setValid(false);
                }
            } else {
                MLog.error((Object)TAG, (String)"content empty!!!", (Object[])new Object[0]);
                msg.setValid(false);
            }
        } else {
            MLog.error((Object)TAG, (String)"section empty!!!", (Object[])new Object[0]);
            msg.setValid(false);
        }
        if (!hasSetInviteState) {
            msg.getGameInviteState().setState(4);
        }
    }

    public GameInviteMsg transform(String msgId, BaseImMsg msgItem) {
        GameInviteMsg msg = new GameInviteMsg(msgItem);
        this.transformContent(msg);
        return msg;
    }
}

