/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.LeadingMarginSpan;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.widget.FlowLayout;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.msg.RequestPermissionMsg;
import com.yy.hiyo.component.publicscreen.theme.IThemeView;
import com.yy.hiyo.component.publicscreen.theme.ThemePackage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestPermissionHolder
extends AbsMsgTitleBarHolder<RequestPermissionMsg> {
    private static final String TAG = "RequestPermissionHolder";
    private YYTextView requestTv;
    private YYTextView resultTv;
    private YYTextView contentTv;
    private RequestPermissionMsg mMsg;
    private ConstraintLayout contentContainer;
    private static int ALIGN_AVATAR_MARGIN = ResourceUtils.getDimen((int)R.dimen.dp_30);

    public RequestPermissionHolder(@NotNull View v) {
        super(v, false);
        this.requestTv = (YYTextView)this.itemView.findViewById(R.id.tv_c_join);
        this.resultTv = (YYTextView)this.itemView.findViewById(R.id.tv_c_result);
        this.resultTv.setVisibility(8);
        this.contentTv = (YYTextView)this.itemView.findViewById(R.id.tv_c_text);
        this.contentContainer = (ConstraintLayout)this.itemView.findViewById(R.id.layout_content);
        this.requestTv.setOnClickListener(v12 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.CLICK_REQUEST_PERMISSION;
                msg.obj = this.getItemMsg();
                this.mActionHandler.onAction(msg);
            }
            if (null != this.mMsg) {
                RoomTrack.INSTANCE.reportSamecityLocationGuideClick(this.mMsg.getCid(), String.valueOf(this.mMsg.getRole()));
            }
        });
        ((IThemeView)this.contentTv).setThemeInterceptor(new IThemeView.Interceptor(){

            @Override
            public boolean intercept(@Nullable ThemePackage themePackage) {
                if (RequestPermissionHolder.this.mChannelMode == 1) {
                    Drawable drawable2;
                    int contentColor = themePackage.getContentColorResId();
                    if (contentColor != 0) {
                        RequestPermissionHolder.this.contentTv.setTextColor(ResourceUtils.getColor((int)contentColor));
                    }
                    if (RequestPermissionHolder.this.contentContainer != null && (drawable2 = themePackage.getBackgroundDrawable()) != null) {
                        RequestPermissionHolder.this.contentContainer.setBackground(drawable2);
                    }
                    return true;
                }
                return false;
            }
        });
        this.getTitleBar().setOnMeasuredListener((width, height) -> {
            if (this.mChannelMode == 1) {
                return;
            }
            int row = this.getTitleBar().getFlowLayout().getRowsCount();
            MLog.debug((Object)TAG, (String)"setOnMeasuredListener row: %d, width: %d, height: %d", (Object[])new Object[]{row, width, height});
            this.updateSimplifyText();
        });
    }

    @Override
    public void bindView(@NotNull RequestPermissionMsg newData, int position) {
        super.bindView(newData, position);
        this.mMsg = newData;
        this.mBinder.singleBindSourceTo("msg", (KvoSource)newData);
        if (newData.getPermissionType() == 1) {
            this.requestTv.setText(R.string.btn_samecity_publicscreen_location_permission);
            if (this.mChannelMode == 1) {
                if (!FP.empty((CharSequence)this.mMsg.getMyNick())) {
                    ChainSpan.of().append((CharSequence)("@" + this.mMsg.getMyNick()), new Object[]{TextSpan.of().size(13).color(ColorUtils.parseColor((String)"#FED77A")).build()}).space().append((CharSequence)ResourceUtils.getString((int)R.string.tips_msg_request_location_permission)).onFinish(data -> this.contentTv.setText((CharSequence)data)).build();
                } else {
                    SpannableString spannableString = new SpannableString((CharSequence)ResourceUtils.getString((int)R.string.tips_msg_request_location_permission));
                    this.contentTv.setText(R.string.tips_msg_request_location_permission);
                    this.contentTv.setText((CharSequence)spannableString);
                }
            } else {
                this.updateSimplifyText();
            }
        }
        RoomTrack.INSTANCE.reportSamecityLocationGuideShow(this.mMsg.getCid(), String.valueOf(this.mMsg.getRole()));
    }

    @KvoMethodAnnotation(name="clickState", sourceClass=RequestPermissionMsg.class, thread=1)
    public void onPermissionState(KvoEventIntent event) {
        RequestPermissionMsg itemMsg = (RequestPermissionMsg)((Object)this.getItemMsg());
        if (itemMsg != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"clickState : %d", (Object[])new Object[]{itemMsg.getClickState()});
            }
            if (itemMsg.getClickState() == 1) {
                this.resultTv.setVisibility(0);
                this.requestTv.setVisibility(8);
            } else {
                this.resultTv.setVisibility(8);
                this.requestTv.setVisibility(0);
                this.requestTv.setEnabled(true);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mBinder.clearAllKvoConnections();
    }

    private void updateContent(Spannable content, int indent) {
        MLog.debug((Object)TAG, (String)("setTextIndent: " + content + ", indentDistance: " + indent), (Object[])new Object[0]);
        int totalIndent = ALIGN_AVATAR_MARGIN + indent;
        LeadingMarginSpan.Standard what = new LeadingMarginSpan.Standard(totalIndent, 0);
        content.setSpan((Object)what, 0, content.length(), 18);
        this.contentTv.setText((CharSequence)content);
    }

    private void updateSimplifyText() {
        int totalHeight;
        int totalWidth;
        FlowLayout flowLayout = this.getTitleBar().getFlowLayout();
        List rows = flowLayout.getChildNumForRow();
        if (rows.size() > 0) {
            totalWidth = flowLayout.getLastRowWidth();
            totalHeight = flowLayout.getHeightForRow(rows.size() - 1);
        } else {
            totalWidth = flowLayout.getMeasuredWidth();
            totalHeight = flowLayout.getMeasuredHeight();
        }
        Paint.FontMetrics metrics = this.contentTv.getPaint().getFontMetrics();
        int textHeight = (int)(metrics.descent - metrics.ascent);
        int topOffset = textHeight + (totalHeight - textHeight) / 2;
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.contentContainer.getLayoutParams();
        params.topMargin = -topOffset - 9;
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        if (!FP.empty((CharSequence)this.mMsg.getMyNick())) {
            int finalTotalWidth = totalWidth;
            ChainSpan.of().append((CharSequence)("@" + this.mMsg.getMyNick()), new Object[]{TextSpan.of().size(13).color(ColorUtils.parseColor((String)"#FED77A")).build()}).space().append((CharSequence)ResourceUtils.getString((int)R.string.tips_msg_request_location_permission)).onFinish(data -> this.updateContent((Spannable)data, finalTotalWidth)).build();
        } else {
            SpannableString spannableString = new SpannableString((CharSequence)ResourceUtils.getString((int)R.string.tips_msg_request_location_permission));
            this.contentTv.setText(R.string.tips_msg_request_location_permission);
            this.updateContent((Spannable)spannableString, totalWidth);
        }
    }
}

