/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.content.Context;
import android.os.Message;
import android.text.method.MovementMethod;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.utils.CrashCatchLinkMovementMethod;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.MoraGiftMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.tools.MoraGiftTextBuilder;
import org.jetbrains.annotations.NotNull;

public class MoraGiftHolder
extends AbsMsgItemHolder<MoraGiftMsg> {
    private MoraGiftTextBuilder mMoraGiftTextBuilder = new MoraGiftTextBuilder();
    private MoraGiftTextBuilder.Callback mCallback = new MoraGiftTextBuilder.Callback(){

        @Override
        @NotNull
        public Context getContext() {
            return MoraGiftHolder.this.itemView.getContext();
        }

        @Override
        public void onResponse(@NotNull CharSequence charSequence) {
            MoraGiftHolder.this.tvContent.setText(charSequence);
        }

        @Override
        public void onChallengeClick() {
            if (MoraGiftHolder.this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.ON_GAME_CHALLENGE_CLICK;
                msg.obj = MoraGiftHolder.this.getItemMsg();
                MoraGiftHolder.this.mActionHandler.onAction(msg);
            }
        }
    };
    private YYTextView tvContent;
    private CircleImageView ivCircle;

    public MoraGiftHolder(@NonNull View itemView) {
        super(itemView, false);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_public_screen_content);
        this.ivCircle = (CircleImageView)itemView.findViewById(R.id.iv_public_screen_header);
        this.tvContent.setMovementMethod((MovementMethod)CrashCatchLinkMovementMethod.getInstance());
        this.ivCircle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MoraGiftHolder.this.mActionHandler != null) {
                    Message msg = Message.obtain();
                    msg.what = ActionDefine.SHOW_USER_PROFILE;
                    msg.obj = ((MoraGiftMsg)MoraGiftHolder.this.getItemMsg()).getUid();
                    MoraGiftHolder.this.mActionHandler.onAction(msg);
                }
            }
        });
    }

    @Override
    public void bindView(MoraGiftMsg newData, int position) {
        super.bindView(newData, position);
        ImageLoader.loadImage((RecycleImageView)this.ivCircle, (String)(newData.getAvatarUrl() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.profile_default_header);
        this.mMoraGiftTextBuilder.buildText(newData, this.mCallback);
    }
}

