/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.textgroup.protocol.IMsgStatueView;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.callback.IMsgActionHandler;
import com.yy.hiyo.component.publicscreen.holder.EnterRoomMsgHolder;
import com.yy.hiyo.component.publicscreen.theme.IThemeLayoutMutable;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import com.yy.hiyo.component.publicscreen.theme.IThemeSimplify;
import com.yy.hiyo.component.publicscreen.theme.IThemeView;
import com.yy.hiyo.component.publicscreen.theme.ThemePackage;
import com.yy.hiyo.component.publicscreen.theme.themeview.YYThemeTextView;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import com.yy.hiyo.wallet.base.privilege.bean.ChatBubbleConfig;
import java.io.File;
import java.util.Map;

public abstract class AbsMsgItemHolder<ItemMsg extends BaseImMsg>
extends RecyclerView.ViewHolder {
    private static final String TAG = "AbsMsgItemHolder";
    private ItemMsg mData;
    private IMsgStatueView mStatusView;
    @Nullable
    protected IMsgActionHandler mActionHandler;
    protected IThemeRes mThemeRes;
    protected IThemeView mContentContainer;
    protected Map<String, Object> mExtendInfoMap;
    protected boolean self;
    protected int mChannelMode;
    protected LifecycleOwner mLifecycleOwner;
    protected boolean mDestroyed;
    protected int viewType = -1;
    private View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (AbsMsgItemHolder.this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.ON_LONG_CLICK;
                msg.obj = AbsMsgItemHolder.this.mData;
                msg.arg1 = AbsMsgItemHolder.this.getAdapterPosition();
                AbsMsgItemHolder.this.mActionHandler.onAction(msg);
                return true;
            }
            return false;
        }
    };
    private BaseImMsg.IFuncBridge mIFuncBridge = new BaseImMsg.IFuncBridge(){

        public void onNickClick(long uid, BaseImMsg msg) {
            if (AbsMsgItemHolder.this.mActionHandler != null) {
                Message message = Message.obtain();
                message.what = ActionDefine.SHOW_USER_PROFILE;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)AbsMsgItemHolder.TAG, (String)"type:%d robotInfo:%s", (Object[])new Object[]{msg.getmRobotMsgType(), msg.getmChannelRobotInfo()});
                }
                if (msg.getmRobotMsgType() == 2 && msg.getmChannelRobotInfo() != null) {
                    message.arg1 = 1;
                    message.obj = msg.getmChannelRobotInfo();
                } else {
                    message.obj = uid;
                }
                AbsMsgItemHolder.this.mActionHandler.onAction(message);
            }
        }

        public void onSpanClick(Message msg) {
            if (AbsMsgItemHolder.this.mActionHandler != null) {
                AbsMsgItemHolder.this.mActionHandler.onAction(msg);
            }
        }
    };
    private long mFromUid;
    protected final KvoBinder mBinder = new KvoBinder((Object)this);

    public AbsMsgItemHolder(@NonNull View itemView, boolean self) {
        this(itemView, self, -1);
    }

    public AbsMsgItemHolder(@NonNull View itemView, boolean self, int viewType) {
        super(itemView);
        this.self = self;
        this.viewType = viewType;
        View statusView = itemView.findViewById(R.id.channel_msg_item_status_view);
        if (statusView instanceof IMsgStatueView) {
            this.mStatusView = (IMsgStatueView)statusView;
        }
    }

    public IMsgStatueView getMsgStatusView() {
        return this.mStatusView;
    }

    public ItemMsg getItemMsg() {
        return this.mData;
    }

    public void setData(ItemMsg data) {
        this.mData = data;
    }

    public void setMsgActionHandler(IMsgActionHandler mMsgActionHandler) {
        if (this.mActionHandler != null) {
            return;
        }
        this.mActionHandler = mMsgActionHandler;
    }

    public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
        this.mLifecycleOwner = lifecycleOwner;
    }

    public void setupContentBgInterceptor() {
        Object extendInfo;
        if (this.mActionHandler != null && (extendInfo = this.mActionHandler.getExtendInfo("pluginMode", new Object[0])) instanceof Integer) {
            this.mChannelMode = (Integer)extendInfo;
        }
        View content = null;
        if (this.mChannelMode == 1) {
            content = this.itemView.findViewWithTag((Object)"basic_background_tag");
        }
        if (content == null) {
            content = this.itemView.findViewById(R.id.channel_msg_content);
        }
        if (content != null && content instanceof IThemeView) {
            this.mContentContainer = (IThemeView)content;
            this.mContentContainer.setThemeInterceptor(new IThemeView.Interceptor(){

                @Override
                public boolean intercept(final @org.jetbrains.annotations.Nullable ThemePackage themePackage) {
                    final long from = AbsMsgItemHolder.this.mFromUid;
                    if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)AbsMsgItemHolder.TAG, (String)"intercept theme, uid:%d", (Object[])new Object[]{from});
                    }
                    if (from > 0L) {
                        ChatBubbleConfig chatBubbleConfig = PrivilegeHelper.INSTANCE.getChatBubbleConfig(from);
                        if (chatBubbleConfig != null && AbsMsgItemHolder.this.mChannelMode != 1 && !(AbsMsgItemHolder.this instanceof EnterRoomMsgHolder)) {
                            String url = StringUtils.isEmpty((String)chatBubbleConfig.getNewUrl()) ? chatBubbleConfig.getUrl() : chatBubbleConfig.getNewUrl();
                            RequestManager requestManager = Glide.with((View)AbsMsgItemHolder.this.itemView);
                            RequestBuilder requestBuilder = requestManager.downloadOnly();
                            requestBuilder.load(url);
                            requestBuilder.listener((RequestListener)new RequestListener<File>(){

                                public boolean onLoadFailed(@org.jetbrains.annotations.Nullable GlideException e, Object model, Target<File> target, boolean isFirstResource) {
                                    AbsMsgItemHolder.this.updateContentBackGround(themePackage);
                                    MLog.error((Object)AbsMsgItemHolder.TAG, (String)"onLoadFailed uid:%d, mCutUId:%d, error: %s", (Object[])new Object[]{from, AbsMsgItemHolder.this.mFromUid, e.getMessage()});
                                    return true;
                                }

                                public boolean onResourceReady(File resource, Object model, Target<File> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                                    return AbsMsgItemHolder.this.updateRemoteBackground(from, resource);
                                }
                            });
                            requestBuilder.preload();
                        } else {
                            AbsMsgItemHolder.this.updateContentBackGround(themePackage);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void updateContentBackGround(@org.jetbrains.annotations.Nullable ThemePackage themePackage) {
        if (themePackage != null && this.mContentContainer != null) {
            if (this.mContentContainer instanceof YYThemeTextView) {
                int contentColor = themePackage.getContentColorResId();
                if (contentColor != 0) {
                    ((YYThemeTextView)this.mContentContainer).setTextColor(ResourceUtils.getColor((int)contentColor));
                }
                Integer otherContentResId = themePackage.getOtherContentResId();
                if (!this.self && otherContentResId != null && otherContentResId != 0) {
                    ((YYThemeTextView)this.mContentContainer).setTextColor(ResourceUtils.getColor((int)otherContentResId));
                }
            }
            View container = (View)this.mContentContainer;
            if (this.mChannelMode != 1) {
                container.setBackground(themePackage.getBackgroundDrawable());
            } else if (this.self) {
                container.setBackground(this.getSelfBackgroundDrawable(themePackage));
            } else {
                container.setBackground(this.getBackgroundDrawable(themePackage));
            }
        }
    }

    protected Drawable getSelfBackgroundDrawable(ThemePackage themePackage) {
        return themePackage.getSelfBackgroundDrawable();
    }

    protected Drawable getBackgroundDrawable(ThemePackage themePackage) {
        return themePackage.getBackgroundDrawable();
    }

    public void bindView(ItemMsg newData, int position) {
        ItemMsg data = this.getItemMsg();
        boolean hasUnbind = false;
        if (data != null && (newData == null || newData != data)) {
            this.mBinder.clearKvoConnection("msg");
            hasUnbind = true;
        } else if (data == null) {
            hasUnbind = true;
        }
        this.setData(newData);
        if (newData == null) {
            return;
        }
        this.updateStateView();
        if (hasUnbind) {
            this.mBinder.singleBindSourceTo("msg", newData);
        }
        View[] longClickViews = null;
        longClickViews = this.getLongClickView();
        if (longClickViews != null && longClickViews.length > 0) {
            for (int i = 0; i < longClickViews.length; ++i) {
                View v = longClickViews[i];
                if (v == null) continue;
                v.setOnLongClickListener(this.mOnLongClickListener);
            }
        }
        newData.setIFuncBridge(this.mIFuncBridge);
        if (this.mThemeRes != null) {
            this.updateTheme(this.itemView, this.mThemeRes);
            this.updateThemeLayout(this.mThemeRes);
        }
    }

    @KvoMethodAnnotation(name="msgState", sourceClass=BaseImMsg.class, thread=1)
    public void updateState(KvoEventIntent event) {
        this.updateStateView();
    }

    protected View[] getLongClickView() {
        return null;
    }

    public void setThemeRes(IThemeRes themeRes) {
        if (themeRes == null || themeRes == this.mThemeRes && !themeRes.needUpdate()) {
            return;
        }
        this.mThemeRes = themeRes;
        this.updateTheme(this.itemView, themeRes);
        this.updateThemeLayout(this.mThemeRes);
    }

    public void setExtendInfo(Map<String, Object> extendInfo) {
        this.mExtendInfoMap = extendInfo;
    }

    private void updateTheme(View view, IThemeRes themeRes) {
        if (view == null || themeRes == null) {
            MLog.error((Object)TAG, (String)"updateTheme error, v:%s, theme:%s", (Object[])new Object[]{view, themeRes});
            return;
        }
        if (view instanceof IThemeView) {
            ((IThemeView)view).onThemeUpdate(themeRes.getThemePackage(((IThemeView)view).getThemePackageKey()));
        }
        boolean avatarVisible = !(themeRes instanceof IThemeSimplify) || ((IThemeSimplify)themeRes).avatarVisible();
        this.updateThemeAvatar(themeRes, avatarVisible);
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.updateTheme(((ViewGroup)view).getChildAt(i), themeRes);
            }
        }
    }

    private void updateThemeLayout(IThemeRes themeRes) {
        if (themeRes instanceof IThemeLayoutMutable) {
            this.updateThemeLayout(themeRes, themeRes instanceof IThemeSimplify);
        }
    }

    protected void updateThemeAvatar(IThemeRes themeRes, boolean avatarVisible) {
    }

    protected void updateThemeLayout(IThemeRes themeRes, boolean isSimplify) {
    }

    public void setFromUid(long fromUid) {
        this.mFromUid = fromUid;
    }

    public void destroy() {
        this.mActionHandler = null;
        this.mDestroyed = true;
    }

    public void onViewRecycled() {
    }

    public void onViewDetachedFromWindow() {
    }

    public void onViewAttachedToWindow() {
    }

    protected long getFromUid() {
        return this.mFromUid;
    }

    protected void finalize() throws Throwable {
        if (this.mDestroyed) {
            return;
        }
        ExtensionsKt.onUi(() -> {
            if (this.mDestroyed) {
                return null;
            }
            try {
                this.destroy();
            }
            catch (Throwable e) {
                if (SystemUtils.isShowEnvSetting()) {
                    throw e;
                }
                MLog.error((Object)TAG, (Throwable)e);
            }
            return null;
        });
        super.finalize();
    }

    public void bindView(ItemMsg newData, ItemMsg preData, int position) {
        this.bindView(newData, position);
    }

    public void updateStateView() {
        ItemMsg newData = this.getItemMsg();
        IMsgStatueView statusView = this.getMsgStatusView();
        if (statusView == null) {
            return;
        }
        if (newData.getMsgState() == 1) {
            if (statusView instanceof View) {
                ((View)statusView).setVisibility(8);
            }
            statusView.onFinish(newData);
        } else if (newData.getMsgState() == 0) {
            if (statusView instanceof View) {
                ((View)statusView).setVisibility(0);
            }
            statusView.onPrepare(newData);
        } else if (newData.getMsgState() == 2) {
            if (statusView instanceof View) {
                ((View)statusView).setVisibility(0);
            }
            statusView.onFail(newData);
        }
    }

    private boolean updateRemoteBackground(long from, File resource) {
        try {
            if (from == this.mFromUid) {
                YYTaskExecutor.execute(() -> {
                    Drawable drawable2 = PrivilegeHelper.INSTANCE.getDrawable(resource, this.itemView.getResources());
                    if (drawable2 == null) {
                        return;
                    }
                    YYTaskExecutor.postToMainThread(() -> {
                        if (from != this.mFromUid) {
                            return;
                        }
                        ((View)this.mContentContainer).setBackground(drawable2);
                        if (drawable2 instanceof NinePatchDrawable) {
                            ((View)this.mContentContainer).setPadding(0, 0, 0, 0);
                        }
                    });
                });
            } else {
                MLog.error((Object)TAG, (String)"uid not equal!!!,a:%d, b:%d", (Object[])new Object[]{from, this.mFromUid});
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"load ChatBubble fail", (Throwable)e, (Object[])new Object[0]);
            e.printStackTrace();
        }
        return false;
    }
}

