/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.chat;

import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.component.publicscreen.chat.bean.ChatUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChatUserModel {
    private Map<Long, ChatUser> mUserCacheMap = new HashMap<Long, ChatUser>();

    public ChatUserModel() {
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                ChatUser chatUser;
                if (userInfoKSList != null && userInfoKSList.size() > 0 && ChatUserModel.this.mUserCacheMap == null && (chatUser = ChatUser.createChatUserFromUserKs(userInfoKSList.get(0))) != null && AccountUtil.getUid() > 0L) {
                    ChatUserModel.this.mUserCacheMap.put(AccountUtil.getUid(), chatUser);
                }
            }

            public void onFail(int id2, String msg, String response) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomChat", (String)"fetchUserInfo error:%s", (Object[])new Object[]{msg});
                }
            }

            public int id() {
                return 0;
            }
        });
    }

    public void add(long uid, ChatUser user) {
        if (this.mUserCacheMap == null) {
            this.mUserCacheMap = new HashMap<Long, ChatUser>();
        }
        if (user == null) {
            return;
        }
        if (uid > 0L) {
            this.mUserCacheMap.put(uid, user);
        }
    }

    public void getUserInfo(final long uid, final IUserInfoCallback callback) {
        if (this.mUserCacheMap == null) {
            this.getUserInfoFromKvo(uid, callback);
            return;
        }
        if (!this.mUserCacheMap.containsKey(uid)) {
            this.getUserInfoFromKvo(uid, callback);
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    if (ChatUserModel.this.mUserCacheMap == null) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (callback != null) {
                                    callback.onFailed(-1, "userCacheMap null");
                                }
                            }
                        });
                        return;
                    }
                    UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(uid);
                    ChatUser chatUser = null;
                    if (!TextUtils.isEmpty((CharSequence)userInfoKS.getNick())) {
                        chatUser = ChatUser.createChatUserFromUserKs(userInfoKS);
                        if (chatUser != null && uid > 0L) {
                            ChatUserModel.this.mUserCacheMap.put(uid, chatUser);
                        }
                    } else {
                        chatUser = (ChatUser)ChatUserModel.this.mUserCacheMap.get(uid);
                    }
                    FeatureLog.d((String)"FTVoiceRoomChat", (String)"getUserInfo from cache:%s", (Object[])new Object[]{chatUser});
                    callback.onSuccess(uid, chatUser);
                }
            }
        });
    }

    public void getUserInfoList(final ArrayList<Long> uids, final IUserInfoListCallback callback) {
        if (this.mUserCacheMap == null) {
            this.getUserInfoListFromKvo(uids, callback);
            return;
        }
        final ArrayList<ChatUser> chatUserList = new ArrayList<ChatUser>();
        boolean hasUid = true;
        for (long uid : uids) {
            if (!this.mUserCacheMap.containsKey(uid)) {
                hasUid = false;
                break;
            }
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(uid);
            ChatUser chatUser = null;
            if (TextUtils.isEmpty((CharSequence)userInfoKS.getNick())) {
                chatUser = this.mUserCacheMap.get(uid);
            } else {
                chatUser = ChatUser.createChatUserFromUserKs(userInfoKS);
                if (uid > 0L) {
                    this.mUserCacheMap.put(uid, chatUser);
                }
            }
            if (chatUser == null) continue;
            chatUserList.add(chatUser);
        }
        if (!hasUid) {
            this.getUserInfoListFromKvo(uids, callback);
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    FeatureLog.d((String)"FTVoiceRoomChat", (String)"getUserInfoList from cache", (Object[])new Object[0]);
                    callback.onSuccess(uids, chatUserList);
                }
            }
        });
    }

    private void getUserInfoListFromKvo(final ArrayList<Long> uids, final IUserInfoListCallback callback) {
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, new OnProfileCallback(){

            public void onSuccess(int id2, final List<UserInfoKS> userInfoKSList) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (userInfoKSList == null) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoListFromKvo userInfoKSList null", (Object[])new Object[0]);
                            }
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (callback != null) {
                                        callback.onFailed(-1, "userInfoKSList null");
                                    }
                                }
                            });
                            return;
                        }
                        if (userInfoKSList.size() == 0) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoListFromKvo userInfoKSList size 0", (Object[])new Object[0]);
                            }
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (callback != null) {
                                        callback.onFailed(-1, "getUserInfoListFromKvo size 0");
                                    }
                                }
                            });
                            return;
                        }
                        ArrayList<ChatUser> chatUserList = new ArrayList<ChatUser>();
                        for (UserInfoKS userInfoKS : userInfoKSList) {
                            ChatUser chatUser = ChatUser.createChatUserFromUserKs(userInfoKS);
                            if (chatUser == null) continue;
                            chatUserList.add(chatUser);
                            if (ChatUserModel.this.mUserCacheMap == null || userInfoKS.getUid() <= 0L) continue;
                            ChatUserModel.this.mUserCacheMap.put(userInfoKS.getUid(), chatUser);
                        }
                        if (callback != null) {
                            callback.onSuccess(uids, chatUserList);
                        }
                    }
                });
            }

            public void onFail(int id2, final String msg, String response) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoListFromKvo fail, reason:%s", (Object[])new Object[]{response});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailed(-1, msg);
                        }
                    }
                });
            }

            public int id() {
                return 0;
            }
        });
    }

    private void getUserInfoFromKvo(final long uid, final IUserInfoCallback callback) {
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){
            long targetUid;
            {
                this.targetUid = uid;
            }

            public void onSuccess(int id2, final List<UserInfoKS> userInfoKSList) {
                if (this.targetUid != uid) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoFromKvo uid not right, currentUid:%s, targetUid:%s", (Object[])new Object[]{uid, this.targetUid});
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onFailed(-1, "uid not right");
                            }
                        }
                    });
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (userInfoKSList == null) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoFromKvo userInfoKSList null", (Object[])new Object[0]);
                            }
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (callback != null) {
                                        callback.onFailed(-1, "userInfoKSList null");
                                    }
                                }
                            });
                            return;
                        }
                        if (userInfoKSList.size() == 0) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoFromKvo userInfoKSList size 0", (Object[])new Object[0]);
                            }
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (callback != null) {
                                        callback.onFailed(-1, "userInfoKSList size 0");
                                    }
                                }
                            });
                            return;
                        }
                        FeatureLog.d((String)"FTVoiceRoomChat", (String)"getUserInfoFromKvo userInfo:%s", (Object[])new Object[]{userInfoKSList.get(0)});
                        ChatUser chatUser = ChatUser.createChatUserFromUserKs((UserInfoKS)userInfoKSList.get(0));
                        if (chatUser == null) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoFromKvo chatUser null", (Object[])new Object[0]);
                            }
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (callback != null) {
                                        callback.onFailed(-1, "chatUser null");
                                    }
                                }
                            });
                            return;
                        }
                        if (ChatUserModel.this.mUserCacheMap != null && targetUid > 0L) {
                            ChatUserModel.this.mUserCacheMap.put(targetUid, chatUser);
                        }
                        if (callback != null) {
                            callback.onSuccess(targetUid, ChatUser.createChatUserFromUserKs((UserInfoKS)userInfoKSList.get(0)));
                        }
                    }
                });
            }

            public void onFail(int id2, final String msg, String response) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomChat", (String)"getUserInfoFromKvo fail, reason:%s", (Object[])new Object[]{response});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailed(-1, msg);
                        }
                    }
                });
            }

            public int id() {
                return 0;
            }
        });
    }

    public static interface IUserInfoListCallback {
        public void onSuccess(List<Long> var1, List<ChatUser> var2);

        public void onFailed(int var1, String var2);
    }

    public static interface IUserInfoCallback {
        public void onSuccess(long var1, ChatUser var3);

        public void onFailed(int var1, String var2);
    }
}

