/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.widge;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteState;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.callback.IGameInviteStateClick;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.widget.GameDownloadingView;

public class GroupGameInviteView
extends YYRelativeLayout {
    private RecycleImageView ivIcon;
    private YYTextView tvName;
    private YYRelativeLayout rlFunc;
    private YYLinearLayout llCountDown;
    private YYLinearLayout llLoading;
    private YYTextView tvJoinInvalid;
    private YYTextView tvFunc;
    private YYTextView tvCountDown;
    private GameDownloadingView gdv;
    private GameInviteState state;
    private boolean hasBindDownloading = false;
    private IGameInviteStateClick mClickCallback;
    private GameInviteMsg msg;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public GroupGameInviteView(Context context) {
        super(context);
        this.createView();
    }

    public GroupGameInviteView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView();
    }

    public GroupGameInviteView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_game_invite_msg_channel, (ViewGroup)this);
        this.ivIcon = (RecycleImageView)this.findViewById(R.id.iv_plugin);
        this.tvName = (YYTextView)this.findViewById(R.id.tv_name);
        this.rlFunc = (YYRelativeLayout)this.findViewById(R.id.rl_func);
        this.llCountDown = (YYLinearLayout)this.findViewById(R.id.ll_count_down);
        this.llLoading = (YYLinearLayout)this.findViewById(R.id.ll_loading);
        this.tvJoinInvalid = (YYTextView)this.findViewById(R.id.tv_join_invalid);
        this.tvCountDown = (YYTextView)this.findViewById(R.id.tv_count_down);
        this.tvFunc = (YYTextView)this.findViewById(R.id.tv_join);
        this.gdv = (GameDownloadingView)this.findViewById(R.id.gdv);
        this.gdv.setMarkBackground(0);
        this.gdv.setBgSrc(null);
        int width = ResolutionUtils.dip2Px((float)42.0f);
        this.gdv.setType(2);
        this.gdv.setProgressBarWidth(width);
        this.gdv.setDefaultProgressBarWidth(width);
        this.gdv.setDefaultLightWidth(width);
        this.gdv.setProgressShow(false);
        this.setOnClickListener(v -> {
            if (this.state != null && this.mClickCallback != null) {
                this.mClickCallback.onClick(this.state);
            }
        });
    }

    public void bindData(@NonNull GameInviteMsg msg) {
        this.msg = msg;
        if (this.state != null && msg != null && msg.getGameInviteState() != this.state) {
            this.mBinder.clearAllKvoConnections();
            this.hasBindDownloading = false;
        }
        this.state = msg.getGameInviteState();
        this.mBinder.singleBindSourceTo((KvoSource)this.state);
        ImageLoader.loadImage((ImageView)this.ivIcon, (String)(this.state.getGameInfo() != null ? this.state.getGameInfo().getIconUrl() : ""));
        this.tvName.setText((CharSequence)(this.state.getGameInfo() != null ? this.state.getGameInfo().getGname() : ""));
    }

    public void setInviteClickCallback(IGameInviteStateClick clickCallback) {
        this.mClickCallback = clickCallback;
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameInviteState.class, thread=1)
    public void onInviteStateChange(KvoEventIntent event) {
        int state = this.state.getState();
        if (state == 1) {
            this.llCountDown.setVisibility(0);
            this.llLoading.setVisibility(8);
            this.tvJoinInvalid.setVisibility(8);
            this.rlFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_yellow_game_count_down));
            this.tvFunc.setText((CharSequence)ResourceUtils.getString((int)R.string.im_push_join));
            this.unbindDownloading();
        } else if (state == 2) {
            this.llCountDown.setVisibility(8);
            this.llLoading.setVisibility(0);
            this.tvJoinInvalid.setVisibility(8);
            this.rlFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_yellow_game_count_down));
            this.bindDownloading();
        } else if (state == 3) {
            this.llCountDown.setVisibility(0);
            this.llLoading.setVisibility(8);
            this.tvJoinInvalid.setVisibility(8);
            this.tvFunc.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_cancel));
            this.rlFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_yellow_game_count_down));
            this.unbindDownloading();
        } else if (state == 4) {
            this.rlFunc.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_grey_game_invalid));
            this.llCountDown.setVisibility(8);
            this.llLoading.setVisibility(8);
            this.tvJoinInvalid.setVisibility(0);
            this.tvJoinInvalid.setText((CharSequence)ResourceUtils.getString((int)(this.msg.getFrom() == AccountUtil.getUid() ? R.string.btn_cancel : R.string.joingame)));
            this.unbindDownloading();
        }
    }

    @KvoMethodAnnotation(name="countDown", sourceClass=GameInviteState.class, thread=1)
    public void onInviteCountDownChange(KvoEventIntent event) {
        int state = this.state.getState();
        if ((state == 1 || state == 3) && this.state != null) {
            this.tvCountDown.setText((CharSequence)(this.state.getCountDown() + "S"));
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public void onDownLoadSuccess(KvoEventIntent event) {
        if (this.state != null && event.newValue() != null && event.newValue() == GameDownloadInfo.DownloadState.download_finish && this.state.getState() == 2) {
            this.state.setState(this.state.getPendingState());
        }
    }

    private void unbindDownloading() {
        if (this.hasBindDownloading && this.state != null && this.state.getGameInfo() != null && this.state.getGameInfo().downloadInfo != null) {
            this.mBinder.clearKvoConnection("GameDownloadInfo");
            this.hasBindDownloading = false;
        }
    }

    private void bindDownloading() {
        if (!this.hasBindDownloading && this.state != null && this.state.getGameInfo() != null && this.state.getGameInfo().downloadInfo != null) {
            this.hasBindDownloading = true;
            this.mBinder.singleBindSourceTo("GameDownloadInfo", (KvoSource)this.state.getGameInfo().downloadInfo);
            this.gdv.setGameInfo(this.state.getGameInfo());
        }
    }
}

