/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import biz.IMMsgItem;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.cbase.publicscreen.msg.ImageMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.MsgItemFactory;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import java.util.List;
import org.json.JSONObject;

public class ImageMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "ImageMsgTransform";

    public ImageMsg transform(String msgId, IMMsgItem msgItem) {
        ImageMsg imageMsg = new ImageMsg(super.transform(msgId, msgItem));
        this.transformContent(msgId, imageMsg);
        return imageMsg;
    }

    private void transformContent(String msgId, ImageMsg imageMsg) {
        List sectionList = imageMsg.getSections();
        if (sectionList != null && !sectionList.isEmpty()) {
            try {
                for (MsgSection section : sectionList) {
                    if (section.getType() != 2) continue;
                    imageMsg.setImageUrl(section.getContent());
                    String extention = section.getExtention();
                    if (StringUtils.isNotEmpty((String)extention)) {
                        JSONObject jsonObject = JsonParser.obtainJSONObject((String)extention);
                        int width = jsonObject.optInt("width");
                        int height = jsonObject.optInt("high");
                        int from = jsonObject.optInt("from");
                        String nanoUrl = jsonObject.optString("nanoUrl");
                        imageMsg.setWidth(width);
                        imageMsg.setHigh(height);
                        imageMsg.setUrlFrom(from);
                        imageMsg.setNanoUrl(nanoUrl);
                        float scale = MsgItemFactory.getScaleSize(width, height);
                        imageMsg.setScale(scale);
                        imageMsg.setEmojiType(jsonObject.optInt("emoji_type", 0));
                        imageMsg.setDataChange(new Object());
                    } else {
                        imageMsg.setDataChange(new Object());
                    }
                    break;
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("ImageMsgTransform !!!" + e), (Object[])new Object[0]);
                imageMsg.setDataChange(new Object());
            }
        }
    }

    public ImageMsg transform(String msgId, BaseImMsg msgItem) {
        ImageMsg msg = new ImageMsg(msgItem);
        this.transformContent(msgId, msg);
        return msg;
    }
}

