/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.os.Message;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.utils.CrashCatchLinkMovementMethod;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.AvatarContentMsg;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import com.yy.hiyo.component.publicscreen.theme.IThemeSimplify;
import com.yy.hiyo.component.publicscreen.theme.ThemePackage;

public class AvatarContentMsgHolder
extends AbsMsgItemHolder<AvatarContentMsg> {
    private CircleImageView ivhead;
    private YYTextView tvText;

    public AvatarContentMsgHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivhead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvText = (YYTextView)itemView.findViewById(R.id.tv_c_text);
        this.tvText.setMovementMethod((MovementMethod)CrashCatchLinkMovementMethod.getInstance());
        this.ivhead.setOnClickListener(v -> {
            if (this.mActionHandler != null && ((AvatarContentMsg)((Object)((Object)this.getItemMsg()))).getUid() > 0L) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.SHOW_USER_PROFILE;
                msg.obj = ((AvatarContentMsg)((Object)((Object)this.getItemMsg()))).getUid();
                this.mActionHandler.onAction(msg);
            }
        });
    }

    @Override
    public void onViewAttachedToWindow() {
        super.onViewAttachedToWindow();
        if (this.getItemMsg() != null) {
            if (((AvatarContentMsg)((Object)this.getItemMsg())).getFromType() == 1) {
                ChannelTrack.INSTANCE.onFollowBackShow();
            }
            if (((AvatarContentMsg)((Object)this.getItemMsg())).getFromType() == 2) {
                ChannelTrack.INSTANCE.onShareMsgShow();
            }
        }
    }

    @Override
    public void bindView(AvatarContentMsg newData, int position) {
        super.bindView(newData, position);
        ImageLoader.loadImage((ImageView)this.ivhead, (String)newData.getIconUrl(), (int)newData.getDefaultIconRes());
        this.tvText.setText(newData.getCharSequence());
        if (!(this.mThemeRes instanceof IThemeSimplify)) {
            if (newData.getFromType() == 1 || newData.getFromType() == 2) {
                this.tvText.setTextColor(ResourceUtils.getColor((int)R.color.color_black_19));
                this.itemView.setBackgroundResource(R.drawable.bg_b3ffffff_8dp);
            } else if (newData.getDefaultBg() != 0) {
                this.itemView.setBackground(ResourceUtils.getDrawable((int)newData.getDefaultBg()));
                this.updateTextColor();
            } else {
                if (this.mThemeRes != null && this.mThemeRes.getThemePackage("msg_background") != null) {
                    this.itemView.setBackground(this.mThemeRes.getThemePackage("msg_background").getBackgroundDrawable());
                }
                this.updateTextColor();
            }
        }
    }

    private void updateTextColor() {
        ThemePackage themePackage;
        if (this.mThemeRes != null && (themePackage = this.mThemeRes.getThemePackage("msg_text")) != null) {
            if (themePackage.getTextLinkColor() != 0) {
                this.tvText.setLinkTextColor(themePackage.getTextLinkColor());
            }
            if (themePackage.getContentColorResId() != null && themePackage.getContentColorResId() != 0) {
                this.tvText.setTextColor(ResourceUtils.getColor((int)themePackage.getContentColorResId()));
            }
        }
    }

    @Override
    protected void updateThemeAvatar(IThemeRes themeRes, boolean avatarVisible) {
        super.updateThemeAvatar(themeRes, avatarVisible);
        this.ivhead.setVisibility(avatarVisible ? 0 : 8);
    }
}

