/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.chat.viewholder;

import android.graphics.Color;
import android.text.TextUtils;
import com.yy.appbase.common.Callback;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.MarginInfo;
import com.yy.appbase.span.TextSpan;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.cbase.publicscreen.HonorChatBean;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.contribution.ContributionDataManager;
import com.yy.hiyo.component.publicscreen.chat.bean.PublicScreenItem;
import com.yy.hiyo.component.publicscreen.chat.viewholder.TextHolder;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.wallet.base.privilege.bean.NickColorConfig;
import java.util.List;
import net.ihago.money.api.contribrank.RankConf;

public class ChatTextBuilder
implements TextHolder.TextBuilder<PublicScreenItem> {
    private static final String SPACE = " ";
    private static final String ICON_ERROR_TEXT = "[honor]";

    @Override
    public void buildText(TextHolder<PublicScreenItem> holder, PublicScreenItem data, Callback<CharSequence> callback) {
        this.buildLtrText(holder, data, callback);
    }

    private void buildLtrText(TextHolder<PublicScreenItem> holder, PublicScreenItem data, Callback<CharSequence> callback) {
        if (data == null) {
            return;
        }
        ChainSpan chainSpan = ChainSpan.of((String)ICON_ERROR_TEXT);
        RankConf weekRankInfo = ContributionDataManager.Instance.getWeekTopRankInfo(data.getUid());
        if (weekRankInfo != null) {
            chainSpan.image(weekRankInfo.icon, ResolutionUtils.dip2Px((float)(weekRankInfo.width / 2)), ResolutionUtils.dip2Px((float)(weekRankInfo.height / 2)), -1, MarginInfo.of().right(3));
        } else {
            RankConf dayRankInfo = ContributionDataManager.Instance.getDayTopRankInfo(data.getUid());
            if (dayRankInfo != null) {
                chainSpan.image(dayRankInfo.icon, ResolutionUtils.dip2Px((float)(dayRankInfo.width / 2)), ResolutionUtils.dip2Px((float)(dayRankInfo.height / 2)), -1, MarginInfo.of().right(3));
            }
        }
        List<HonorChatBean> honorChatBeanList = data.getHonor();
        if (honorChatBeanList != null) {
            for (HonorChatBean honorChatBean : honorChatBeanList) {
                if (honorChatBean == null) continue;
                chainSpan.image(honorChatBean.getUrl(), ResolutionUtils.dip2Px((float)(honorChatBean.getWidth() / 2)), ResolutionUtils.dip2Px((float)(honorChatBean.getHeight() / 2)), -1, MarginInfo.of().right(3));
            }
        }
        String nameColor = "#80ffffff";
        NickColorConfig nickColorConfig = PrivilegeHelper.INSTANCE.getNickColorConfig(data.getUid());
        if (nickColorConfig != null && StringUtils.isNotEmpty((String)nickColorConfig.getColor())) {
            nameColor = nickColorConfig.getColor();
        }
        chainSpan.beginBlock().append((CharSequence)data.getName(), new Object[]{TextSpan.of().size(13).color(ColorUtils.parseColor((String)nameColor)).build()}).append((CharSequence)SPACE).onBlockClick(() -> {
            if (holder != null) {
                holder.onClickUser(data.getUid());
            }
        }).endBlock();
        int color2 = Color.parseColor((String)"#ffffff");
        if (!TextUtils.isEmpty((CharSequence)data.getBgColor())) {
            color2 = Color.parseColor((String)data.getBgColor());
        }
        if (data.getType() == 10 || data.getType() == 16) {
            if (data.getType() == 16) {
                chainSpan.clear();
            }
            if (!TextUtils.isEmpty((CharSequence)data.getContent()) && data.getContent().contains("@") && !TextUtils.isEmpty((CharSequence)data.getReceiverName())) {
                int nameIndex = data.getContent().indexOf(data.getReceiverName());
                String mentionStr = "@" + data.getReceiverName();
                int mentionStrIndex = data.getContent().indexOf(mentionStr);
                if (mentionStrIndex == -1) {
                    FeatureLog.i((String)"FTVoiceRoomChat", (String)"delete mention", (Object[])new Object[0]);
                    chainSpan.append((CharSequence)EmojiManager.INSTANCE.getExpressionString(data.getContent(), ResolutionUtils.dip2Px((float)15.0f)), new Object[]{TextSpan.of().size(13).color(color2).build()}).onUpdate(arg_0 -> callback.onResponse(arg_0)).build();
                    return;
                }
                chainSpan.beginBlock().append((CharSequence)EmojiManager.INSTANCE.getExpressionString(mentionStr, ResolutionUtils.dip2Px((float)15.0f)), new Object[]{TextSpan.of().size(13).color(Color.parseColor((String)"#fed77a")).build()}).onUpdate(arg_0 -> callback.onResponse(arg_0)).onBlockClick(() -> {
                    if (holder != null) {
                        holder.onClickUser(data.getReceiverUid());
                    }
                }).endBlock().build();
                if (data.getContent().length() >= nameIndex + data.getReceiverName().length()) {
                    String content = data.getContent().substring(nameIndex + data.getReceiverName().length(), data.getContent().length());
                    chainSpan.append((CharSequence)EmojiManager.INSTANCE.getExpressionString(content, ResolutionUtils.dip2Px((float)15.0f)), new Object[]{TextSpan.of().size(13).color(color2).build()}).onUpdate(arg_0 -> callback.onResponse(arg_0)).build();
                }
            }
        } else if (!TextUtils.isEmpty((CharSequence)data.getContent())) {
            chainSpan.append((CharSequence)EmojiManager.INSTANCE.getExpressionString(data.getContent(), ResolutionUtils.dip2Px((float)15.0f)), new Object[]{TextSpan.of().size(13).color(color2).build()}).onUpdate(arg_0 -> callback.onResponse(arg_0)).build();
        }
    }
}

