/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.callback;

import android.view.View;
import androidx.lifecycle.LifecycleOwner;
import com.yy.base.event.kvo.Kvo;
import com.yy.hiyo.channel.component.textgroup.protocol.IMsgStatueView;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.callback.IMsgActionHandler;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import java.util.Map;

public interface IMsgItemViewHolder<T extends BaseImMsg> {
    public IMsgStatueView getMsgStatusView();

    public T getItemMsg();

    default public void bindView(T newData, int position) {
        T data = this.getItemMsg();
        boolean hasUnbind = false;
        if (data != null && (newData == null || newData != data)) {
            Kvo.autoBindingTo(data, (Object)this);
            hasUnbind = true;
        } else if (data == null) {
            hasUnbind = true;
        }
        this.setData(newData);
        if (newData == null) {
            return;
        }
        this.updateStateView();
        if (hasUnbind) {
            Kvo.autoUnbindingFrom(newData, (Object)this);
        }
    }

    default public void bindView(T newData, T preData, int position) {
        this.bindView(newData, position);
    }

    public void setData(T var1);

    default public void updateStateView() {
        T newData = this.getItemMsg();
        IMsgStatueView statusView = this.getMsgStatusView();
        if (statusView == null) {
            return;
        }
        if (newData.getMsgState() == 1) {
            if (statusView instanceof View) {
                ((View)statusView).setVisibility(8);
            }
            statusView.onFinish(newData);
        } else if (newData.getMsgState() == 0) {
            if (statusView instanceof View) {
                ((View)statusView).setVisibility(0);
            }
            statusView.onPrepare(newData);
        } else if (newData.getMsgState() == 2) {
            if (statusView instanceof View) {
                ((View)statusView).setVisibility(0);
            }
            statusView.onFail(newData);
        }
    }

    public void setMsgActionHandler(IMsgActionHandler var1);

    public void setLifecycleOwner(LifecycleOwner var1);

    public void setThemeRes(IThemeRes var1);

    default public void setExtendInfo(Map<String, Object> extendInfo) {
    }
}

