/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.biz;

import android.content.Context;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.MsgItemFactory;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.biz.FollowGuideController;
import com.yy.hiyo.component.publicscreen.biz.IMsgBizCallback;
import com.yy.hiyo.component.publicscreen.helper.FollowGuideReportHelper;
import com.yy.hiyo.component.publicscreen.msg.FollowGuideMsg;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.relation.base.IBooleanCallback;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.LoadState;
import com.yy.hiyo.relation.base.data.RelationInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.act.api.lowactive.LowActiveNotify;
import net.ihago.act.api.lowactive.LowactiveUri;
import net.ihago.act.api.lowactive.NotifyFollowGuideMsg;
import net.ihago.act.api.lowactive.ReportAtInfoReq;
import net.ihago.act.api.lowactive.ReportAtInfoRsp;
import net.ihago.room.srv.follow.EPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\n\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/yy/hiyo/component/publicscreen/biz/FollowGuideController;", "Lcom/yy/appbase/core/DefaultController;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "callback", "Lcom/yy/hiyo/component/publicscreen/biz/IMsgBizCallback;", "curMode", "", "notifyListener", "com/yy/hiyo/component/publicscreen/biz/FollowGuideController$notifyListener$1", "Lcom/yy/hiyo/component/publicscreen/biz/FollowGuideController$notifyListener$1;", "destroy", "", "findAtMsgToServer", "baseImMsg", "Lcom/yy/hiyo/channel/publicscreen/BaseImMsg;", "handleNotify", "uri", "notify", "Lnet/ihago/act/api/lowactive/LowActiveNotify;", "onFollowClick", "item", "Lcom/yy/hiyo/component/publicscreen/msg/FollowGuideMsg;", "onNotifyFollowGuide", "msg", "Lnet/ihago/act/api/lowactive/NotifyFollowGuideMsg;", "onReportFollowRes", "mRelation", "Lcom/yy/hiyo/relation/base/data/RelationInfo;", "sendAtToServer", "toId", "", "channelId", "", "setUp", "mode", "publicscreen_debug"})
public final class FollowGuideController
extends DefaultController {
    private IMsgBizCallback callback;
    private int curMode;
    private notifyListener.1 notifyListener = new IProtoNotify<LowActiveNotify>(this){
        final /* synthetic */ FollowGuideController this$0;

        @NotNull
        public String serviceName() {
            return "net.ihago.act.api.lowactive";
        }

        public void onNotify(@NotNull LowActiveNotify notify) {
            Intrinsics.checkParameterIsNotNull((Object)notify, (String)"notify");
            MLog.info((Object)"FollowGuideController", (String)"onNotify", (Object[])new Object[0]);
            List uris = notify.uris;
            if (uris != null && uris.size() > 0) {
                for (Integer uri : uris) {
                    if (uri == null) continue;
                    FollowGuideController.access$handleNotify(this.this$0, uri, notify);
                }
            }
        }
        {
            this.this$0 = $outer;
        }
    };

    private final void handleNotify(int uri, LowActiveNotify notify) {
        if (uri == LowactiveUri.UriFollowGuide.getValue()) {
            MLog.info((Object)"FollowGuideController", (String)"UriFollowGuide", (Object[])new Object[0]);
            this.onNotifyFollowGuide(notify.follow_guide_msg);
        }
    }

    private final void onNotifyFollowGuide(NotifyFollowGuideMsg msg) {
        if (msg == null) {
            MLog.debug((Object)"FollowGuideController", (String)"onNotifyFollowGuide notify null -> return", (Object[])new Object[0]);
            return;
        }
        if (this.curMode == 14 || this.curMode == 15) {
            MLog.debug((Object)"FollowGuideController", (String)"RADIO or MULTI_VIDEO -> return", (Object[])new Object[0]);
            return;
        }
        IMsgBizCallback iMsgBizCallback = this.callback;
        if (iMsgBizCallback != null) {
            String string2 = msg.cid;
            Long l = msg.content_type;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"msg.content_type");
            long l2 = l;
            Long l3 = msg.follow_uid;
            Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"msg.follow_uid");
            FollowGuideMsg followGuideMsg = MsgItemFactory.generateFollowGuideMsg(string2, l2, l3, msg.follow_name, msg.follow_avatar, (int)msg.follow_sex.longValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)followGuideMsg), (String)"MsgItemFactory.generateF\u2026  msg.follow_sex.toInt())");
            iMsgBizCallback.appendMsg(followGuideMsg);
        }
        FollowGuideReportHelper.INSTANCE.reportShowFollowGuide(msg);
    }

    public final void setUp(@NotNull IMsgBizCallback callback, int mode) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callback = callback;
        this.curMode = mode;
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.notifyListener);
    }

    public final void onFollowClick(@NotNull FollowGuideMsg item, @NotNull IMsgBizCallback callback) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)item), (String)"item");
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            FollowGuideReportHelper.INSTANCE.reportClickFollowGuide(item, "ola_interactive_follow_click");
            if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
                ToastUtils.showToast((Context)this.mContext, (int)R.string.check_network_and_retry);
                MLog.debug((Object)"FollowGuideController", (String)"onFollow not network", (Object[])new Object[0]);
                FollowGuideReportHelper.INSTANCE.reportClickFollowGuide(item, "ola_interactive_follow_fail_show");
                return;
            }
            item.setEnableClick(false);
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IRelationService)iServiceManager.getService(IRelationService.class)) == null) break block4;
            Long l = item.getFollowUid();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            if ((iServiceManager = iServiceManager.getRelationLocal(l.longValue())) != null) {
                IServiceManager iServiceManager2 = iServiceManager;
                boolean bl = false;
                boolean bl2 = false;
                IServiceManager relation = iServiceManager2;
                boolean bl3 = false;
                IServiceManager iServiceManager3 = ServiceManagerProxy.getServiceManager();
                if (iServiceManager3 != null && (iServiceManager3 = (IRelationService)iServiceManager3.getService(IRelationService.class)) != null) {
                    iServiceManager3.requestFollow((RelationInfo)relation, EPath.PATH_VOICE.getValue(), (ICommonCallback)new IBooleanCallback((RelationInfo)relation, this, item){
                        final /* synthetic */ RelationInfo $relation;
                        final /* synthetic */ FollowGuideController this$0;
                        final /* synthetic */ FollowGuideMsg $item$inlined;
                        {
                            this.$relation = $captured_local_variable$1;
                            this.this$0 = followGuideController;
                            this.$item$inlined = followGuideMsg;
                        }

                        public void onResult(boolean success) {
                            FollowGuideController.access$onReportFollowRes(this.this$0, this.$item$inlined, this.$relation);
                        }
                    });
                }
            }
        }
    }

    public final void findAtMsgToServer(@NotNull BaseImMsg baseImMsg) {
        Intrinsics.checkParameterIsNotNull((Object)baseImMsg, (String)"baseImMsg");
        MLog.info((Object)"FollowGuideController", (String)"findAtMsgToServer :%s", (Object[])new Object[]{baseImMsg});
        List list = baseImMsg.getSections();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"baseImMsg.getSections()");
        List msgSections = list;
        if (msgSections == null || msgSections.isEmpty()) {
            return;
        }
        MsgSection section = (MsgSection)msgSections.get(0);
        int msgType = section.getType();
        if (msgType != 2005) {
            MLog.info((Object)"FollowGuideController", (String)"findAtMsgToServer :%s", (Object[])new Object[]{"MsgType is not MsgType.ESTAt"});
            return;
        }
        long senderUid = baseImMsg.getFrom();
        JSONObject jsonObject = JsonParser.obtainJSONObject((String)section.getContent());
        long toUid = jsonObject.optLong("uid");
        if (senderUid != AccountUtil.getUid()) {
            return;
        }
        String string2 = baseImMsg.getCid();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"baseImMsg.cid");
        this.sendAtToServer(toUid, string2);
    }

    private final void sendAtToServer(long toId, String channelId) {
        ReportAtInfoReq req = new ReportAtInfoReq(Long.valueOf(toId), channelId);
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<ReportAtInfoRsp>(){

            public void onResponse(@NotNull ReportAtInfoRsp res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.debug((Object)"FollowGuideController", (String)("sendAtToServer onSuccess: " + code + ", res: " + res), (Object[])new Object[0]);
                } else {
                    MLog.debug((Object)"FollowGuideController", (String)("sendAtToServer onError: " + code + ", reason: " + msgTip), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.debug((Object)"FollowGuideController", (String)("sendAtToServer onError: " + code + ", reason: " + reason), (Object[])new Object[0]);
            }
        });
    }

    private final void onReportFollowRes(FollowGuideMsg item, RelationInfo mRelation) {
        if (mRelation.getLoadState() == LoadState.SUCCESS) {
            FollowGuideReportHelper.INSTANCE.reportClickFollowGuide(item, "ola_interactive_follow_succ_show");
        } else if (mRelation.getLoadState() == LoadState.FAIL) {
            FollowGuideReportHelper.INSTANCE.reportClickFollowGuide(item, "ola_interactive_follow_fail_show");
        }
    }

    public void destroy() {
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.notifyListener);
        this.callback = null;
    }

    public FollowGuideController(@Nullable Environment env) {
        super(env);
    }

    public static final /* synthetic */ void access$onReportFollowRes(FollowGuideController $this, FollowGuideMsg item, RelationInfo mRelation) {
        $this.onReportFollowRes(item, mRelation);
    }

    public static final /* synthetic */ void access$handleNotify(FollowGuideController $this, int uri, LowActiveNotify notify) {
        $this.handleNotify(uri, notify);
    }
}

