/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.adapter;

import android.os.Message;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRecyclerViewKt;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IImMsgMatcher;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.MsgItemFactory;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.callback.IMsgActionHandler;
import com.yy.hiyo.component.publicscreen.callback.IPublicChatViewCallback;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.holder.RandomEmojiHolder;
import com.yy.hiyo.component.publicscreen.msg.EnterRoomMsg;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class AbsMsgItemAdapter
extends RecyclerView.Adapter<AbsMsgItemHolder> {
    private static final String TAG = "AbsMsgItemAdapter";
    private List<BaseImMsg> mDatas = null;
    private IMsgActionHandler mMsgActionHandler;
    private IThemeRes mIThemeRes = null;
    private Map<String, Object> mExtendInfoMap;
    private Set<AbsMsgItemHolder> mInWindowHolders = new HashSet<AbsMsgItemHolder>();
    private Set<WeakReference<RandomEmojiHolder>> mUsingRandomViewHolders = new HashSet<WeakReference<RandomEmojiHolder>>();
    private Set<WeakReference<AbsMsgItemHolder>> mHoldersSet = new HashSet<WeakReference<AbsMsgItemHolder>>();
    private Set<String> dateTag = new HashSet<String>();
    private Calendar mCalendar = Calendar.getInstance();
    private WeakReference<RecyclerView> mRefRv = new WeakReference<Object>(null);
    private IPublicChatViewCallback mCallback;

    public AbsMsgItemAdapter(List<BaseImMsg> mDatas, IPublicChatViewCallback callback) {
        this.mDatas = mDatas;
        this.mMsgActionHandler = callback.getActionHandler();
        this.mCallback = callback;
        MsgItemFactory.mode = callback.getCurMode();
        if (mDatas == null) {
            throw new NullPointerException("AbsMsgItemAdapter cannot input null datas!!!");
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRefRv = new WeakReference<RecyclerView>(recyclerView);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mRefRv.clear();
    }

    @NonNull
    public AbsMsgItemHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        AbsMsgItemHolder holder = MsgItemFactory.getHolder(viewGroup, i, this.mCallback.getCurMode(), this.mCallback.isFamilyPluginMode());
        holder.setMsgActionHandler(this.mMsgActionHandler);
        holder.setupContentBgInterceptor();
        if (null != this.mCallback) {
            holder.setLifecycleOwner(this.mCallback.getLifecycleOwner());
        }
        if (holder instanceof RandomEmojiHolder) {
            this.mUsingRandomViewHolders.add(new WeakReference<RandomEmojiHolder>((RandomEmojiHolder)holder));
        } else {
            this.mHoldersSet.add(new WeakReference<AbsMsgItemHolder>(holder));
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBindViewHolder(@NonNull AbsMsgItemHolder holder, int position) {
        BaseImMsg msg = null;
        BaseImMsg preMsg = null;
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            msg = this.mDatas.get(position);
            if (position - 1 >= 0) {
                preMsg = this.mDatas.get(position - 1);
            }
        }
        holder.setFromUid(msg.getFrom());
        holder.setThemeRes(this.mIThemeRes);
        holder.setExtendInfo(this.mExtendInfoMap);
        holder.setMsgActionHandler(this.mMsgActionHandler);
        holder.bindView(msg, preMsg, position);
        this.mMsgActionHandler.onItemShow(msg, position);
    }

    public void onViewAttachedToWindow(@NonNull AbsMsgItemHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.onViewAttachedToWindow();
        this.mInWindowHolders.add(holder);
    }

    public void onViewDetachedFromWindow(@NonNull AbsMsgItemHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onViewDetachedFromWindow();
        this.mInWindowHolders.remove((Object)holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendData(BaseImMsg data, boolean animate) {
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            int changeCount = 0;
            if (!this.mDatas.isEmpty()) {
                long lastTs = this.mDatas.get(this.mDatas.size() - 1).getTs();
                BaseImMsg tsMsg = this.insertTimeMsg(data.getTs(), lastTs);
                if (tsMsg != null) {
                    ++changeCount;
                    this.mDatas.add(tsMsg);
                }
            }
            if (changeCount == 0 && data instanceof EnterRoomMsg && this.mDatas.size() > 0 && this.mDatas.get(this.mDatas.size() - 1) instanceof EnterRoomMsg && ((EnterRoomMsg)this.mDatas.get(this.mDatas.size() - 1)).isCanMerge()) {
                this.mDatas.remove(this.mDatas.size() - 1);
                this.mDatas.add(data);
                YYRecyclerViewKt.notifyItemChangedSafe((RecyclerView.Adapter)this, (RecyclerView)((RecyclerView)this.mRefRv.get()), (int)(this.mDatas.size() - 1));
            } else {
                ++changeCount;
                this.mDatas.add(data);
                if (animate) {
                    YYRecyclerViewKt.notifyItemRangeChangedSafe((RecyclerView.Adapter)this, (RecyclerView)((RecyclerView)this.mRefRv.get()), (int)(this.mDatas.size() - changeCount), (int)changeCount);
                } else {
                    YYRecyclerViewKt.notifyDataSetChangedSafe((RecyclerView.Adapter)this, (RecyclerView)((RecyclerView)this.mRefRv.get()));
                }
            }
            if (data.getFrom() > 0L && !(data instanceof EnterRoomMsg)) {
                ArrayList<Long> uid = new ArrayList<Long>();
                uid.add(data.getFrom());
                this.loadUserProfiles(uid);
            }
        }
    }

    private BaseImMsg insertTimeMsg(long ts, long lastTs) {
        return this.insertTimeMsg(ts, lastTs, false);
    }

    private BaseImMsg insertTimeMsg(long ts, long lastTs, boolean head) {
        if (this.mCallback.getCurMode() == 1) {
            return this.getBaseTimeMsg(ts, lastTs, head);
        }
        return this.getTimeMsg(ts, lastTs);
    }

    private BaseImMsg getTimeMsg(long ts, long lastTs) {
        boolean isSameDay;
        SysTextMsg msg = null;
        if (String.valueOf(ts).length() == 10) {
            ts *= 1000L;
        }
        if (String.valueOf(lastTs).length() == 10) {
            lastTs *= 1000L;
        }
        if (!(isSameDay = TimeUtils.isSameDay((long)ts, (long)lastTs)) && ts > 0L) {
            boolean isSameYear = TimeUtils.isSameYear((long)ts, (long)lastTs);
            this.mCalendar.setTimeInMillis(ts);
            String dateStr = isSameYear || lastTs == 0L ? ResourceUtils.getString((int)R.string.tips_mm_dd_1, (Object[])new Object[]{this.mCalendar.get(2) + 1, this.mCalendar.get(5)}) : ResourceUtils.getString((int)R.string.tips_mm_dd_yyyy, (Object[])new Object[]{this.mCalendar.get(2) + 1, this.mCalendar.get(5), this.mCalendar.get(1)});
            if (!this.dateTag.contains(dateStr)) {
                this.dateTag.add(dateStr);
                msg = MsgItemFactory.generateLocalTsSysMsg(dateStr);
            }
        }
        return msg;
    }

    @Nullable
    private BaseImMsg getBaseTimeMsg(long ts, long lastTs, boolean head) {
        long timeInterval;
        if (ts <= 0L || lastTs <= 0L) {
            return null;
        }
        if (String.valueOf(ts).length() == 10) {
            ts *= 1000L;
        }
        if (String.valueOf(lastTs).length() == 10) {
            lastTs *= 1000L;
        }
        if ((timeInterval = head ? lastTs - ts : ts - lastTs) < 300000L) {
            return null;
        }
        SysTextMsg msg = null;
        boolean isSameDay = TimeUtils.isSameDay((long)ts, (long)lastTs);
        boolean isSameYear = TimeUtils.isSameYear((long)ts, (long)lastTs);
        long timeMillis = System.currentTimeMillis();
        boolean isToday = TimeUtils.isSameDay((long)ts, (long)timeMillis);
        boolean isThisYear = TimeUtils.isSameYear((long)ts, (long)timeMillis);
        this.mCalendar.setTimeInMillis(ts);
        String dateStr = isSameDay && isToday ? TimeUtils.getFormatTimeString((long)this.mCalendar.getTimeInMillis(), (String)"hour:min") : (isSameYear && isThisYear ? TimeUtils.getFormatTimeString((long)this.mCalendar.getTimeInMillis(), (String)"mon/day hour:min") : TimeUtils.getFormatTimeString((long)this.mCalendar.getTimeInMillis(), (String)"mon/day/year hour:min"));
        if (!this.dateTag.contains(dateStr)) {
            this.dateTag.add(dateStr);
            msg = MsgItemFactory.generateLocalTsSysMsg(dateStr);
        }
        return msg;
    }

    private static void removeRepeatFromLastFiveShowingMsg(List<BaseImMsg> datas, List<BaseImMsg> showingDatas) {
        int endIndex;
        if (showingDatas == null || showingDatas.size() <= 0 || datas == null || datas.size() <= 0) {
            return;
        }
        ArrayList<BaseImMsg> localDatas = new ArrayList<BaseImMsg>(5);
        int n = endIndex = showingDatas.size() > 5 ? 5 : showingDatas.size();
        if (endIndex <= 0) {
            return;
        }
        localDatas.addAll(showingDatas.subList(0, endIndex));
        ArrayList<BaseImMsg> needDeleteMsgs = new ArrayList<BaseImMsg>(1);
        block0: for (BaseImMsg baseImMsg : datas) {
            for (BaseImMsg localItem : localDatas) {
                if (localItem == null || !StringUtils.equal((String)localItem.getMsgId(), (String)baseImMsg.getMsgId())) continue;
                needDeleteMsgs.add(baseImMsg);
                continue block0;
            }
        }
        if (needDeleteMsgs.size() > 0) {
            datas.removeAll(needDeleteMsgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendDatasToHead(List<BaseImMsg> datas, boolean hasMore) {
        if (datas == null || datas.isEmpty()) {
            return;
        }
        HashSet<Long> uids = new HashSet<Long>();
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            AbsMsgItemAdapter.removeRepeatFromLastFiveShowingMsg(datas, this.mDatas);
            long lastTs = 0L;
            for (int i = 0; i < datas.size(); ++i) {
                BaseImMsg base;
                BaseImMsg msg = datas.get(i);
                if (msg.getFrom() > 0L) {
                    uids.add(msg.getFrom());
                }
                if (i == 0) {
                    if (hasMore) {
                        lastTs = msg.getTs();
                        continue;
                    }
                    lastTs = System.currentTimeMillis();
                    base = this.insertTimeMsg(msg.getTs(), lastTs, true);
                    lastTs = msg.getTs();
                    if (base == null) continue;
                    datas.add(i, base);
                    ++i;
                    continue;
                }
                base = this.insertTimeMsg(msg.getTs(), lastTs);
                lastTs = msg.getTs();
                if (base == null) continue;
                datas.add(i, base);
                ++i;
            }
            if (!this.mDatas.isEmpty() && !datas.isEmpty()) {
                BaseImMsg msg = this.mDatas.get(0);
                BaseImMsg msg1 = datas.get(datas.size() - 1);
                BaseImMsg tsMsg = this.insertTimeMsg(msg.getTs(), msg1.getTs());
                if (tsMsg != null) {
                    datas.add(tsMsg);
                }
            }
            this.mDatas.addAll(0, datas);
            YYRecyclerViewKt.notifyItemRangeInsertedSafe((RecyclerView.Adapter)this, (RecyclerView)((RecyclerView)this.mRefRv.get()), (int)0, (int)datas.size());
            MLog.info((Object)TAG, (String)"appendDatasToHead size:%d", (Object[])new Object[]{datas.size()});
            if (!uids.isEmpty()) {
                this.loadUserProfiles(new ArrayList<Long>(uids));
            }
        }
    }

    private void loadUserProfiles(List<Long> uids) {
        if (this.mMsgActionHandler == null) {
            return;
        }
        if (uids != null) {
            uids.remove(10L);
            uids.remove(14L);
        }
        if (uids != null && !uids.isEmpty()) {
            Message message = Message.obtain();
            message.what = ActionDefine.LOAD_UID_PROFILES;
            message.obj = uids;
            this.mMsgActionHandler.onAction(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            return this.mDatas.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemViewType(int position) {
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            return MsgItemFactory.getViewType(this.mDatas.get(position), this.mCallback.getCurMode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTargetMsg(IImMsgMatcher matcher) {
        if (matcher == null) {
            return;
        }
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            Iterator<BaseImMsg> iterator = this.mDatas.iterator();
            int i = 0;
            boolean matched = false;
            BaseImMsg matchedMsg = null;
            while (iterator.hasNext()) {
                BaseImMsg next = iterator.next();
                if (matcher.match(next, i)) {
                    matched = true;
                    matchedMsg = next;
                    break;
                }
                ++i;
            }
            matcher.end(matchedMsg, matched ? i : -1, matched ? 1 : 0);
        }
    }

    public List<BaseImMsg> getDatas() {
        return this.mDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMsgs(List<BaseImMsg> datas) {
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            if (datas != null && !datas.isEmpty()) {
                if (!this.mDatas.isEmpty() && this.mDatas.get(this.mDatas.size() - 1) instanceof EnterRoomMsg && ((EnterRoomMsg)this.mDatas.get(this.mDatas.size() - 1)).isCanMerge() && datas.get(0) instanceof EnterRoomMsg) {
                    this.mDatas.remove(this.mDatas.size() - 1);
                    this.mDatas.add(datas.get(0));
                    YYRecyclerViewKt.notifyItemChangedSafe((RecyclerView.Adapter)this, (RecyclerView)((RecyclerView)this.mRefRv.get()), (int)(this.mDatas.size() - 1));
                    datas.remove(0);
                }
                long lastTs = 0L;
                HashSet<Long> uids = new HashSet<Long>();
                for (int i = 0; i < datas.size(); ++i) {
                    BaseImMsg base;
                    BaseImMsg msg = datas.get(i);
                    if (msg.getFrom() > 0L) {
                        uids.add(msg.getFrom());
                    }
                    if (i == 0) {
                        if (!this.mDatas.isEmpty()) {
                            lastTs = this.mDatas.get(this.mDatas.size() - 1).getTs();
                        }
                        base = this.insertTimeMsg(msg.getTs(), lastTs);
                        lastTs = msg.getTs();
                        if (base == null) continue;
                        datas.add(i, base);
                        ++i;
                        continue;
                    }
                    base = this.insertTimeMsg(msg.getTs(), lastTs);
                    lastTs = msg.getTs();
                    if (base == null) continue;
                    datas.add(i, base);
                    ++i;
                }
                int startPosition = this.mDatas.size();
                this.mDatas.addAll(datas);
                YYRecyclerViewKt.notifyItemRangeInsertedSafe((RecyclerView.Adapter)this, (RecyclerView)((RecyclerView)this.mRefRv.get()), (int)startPosition, (int)datas.size());
                this.loadUserProfiles(new ArrayList<Long>(uids));
            }
        }
    }

    public void setThemeRes(IThemeRes themeRes) {
        if (themeRes == null || themeRes == this.mIThemeRes && !themeRes.needUpdate()) {
            return;
        }
        this.mIThemeRes = themeRes;
        for (AbsMsgItemHolder holder : this.mInWindowHolders) {
            holder.setThemeRes(themeRes);
        }
        if (this.mIThemeRes != null) {
            this.mIThemeRes.setNeedUpdate(false);
        }
    }

    public void setExtendInfo(Map<String, Object> extendInfoMap) {
        this.mExtendInfoMap = extendInfoMap;
    }

    public void destroy() {
        this.reset();
        this.mMsgActionHandler = null;
        this.releaseHolder();
    }

    private void releaseHolder() {
        AbsMsgItemHolder item;
        if (!FP.empty(this.mHoldersSet)) {
            item = null;
            for (WeakReference<AbsMsgItemHolder> weakReference : this.mHoldersSet) {
                if (weakReference == null || (item = (AbsMsgItemHolder)((Object)weakReference.get())) == null) continue;
                item.destroy();
            }
            this.mHoldersSet.clear();
        }
        if (this.mUsingRandomViewHolders != null && this.mUsingRandomViewHolders.size() > 0) {
            item = null;
            for (WeakReference<AbsMsgItemHolder> weakReference : this.mUsingRandomViewHolders) {
                if (weakReference == null || (item = (AbsMsgItemHolder)((Object)weakReference.get())) == null) continue;
                item.destroy();
            }
            this.mUsingRandomViewHolders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<BaseImMsg> list = this.mDatas;
        synchronized (list) {
            if (this.mDatas != null) {
                for (BaseImMsg msg : this.mDatas) {
                    msg.setIFuncBridge(null);
                }
            }
        }
        if (!FP.empty(this.mInWindowHolders)) {
            for (AbsMsgItemHolder holder : this.mInWindowHolders) {
                if (holder == null) continue;
                holder.destroy();
            }
        }
        this.mInWindowHolders.clear();
        this.mDatas.clear();
        YYRecyclerViewKt.notifyDataSetChangedSafe((RecyclerView.Adapter)this, (RecyclerView)((RecyclerView)this.mRefRv.get()));
    }

    public void onViewRecycled(@NonNull AbsMsgItemHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onViewRecycled();
    }

    public void onBigfaceBeanBack() {
        if (this.mUsingRandomViewHolders != null && this.mUsingRandomViewHolders.size() > 0) {
            for (WeakReference<RandomEmojiHolder> holder : this.mUsingRandomViewHolders) {
                RandomEmojiHolder item;
                if (holder == null || (item = (RandomEmojiHolder)((Object)holder.get())) == null) continue;
                item.onBigfaceBeanBack();
            }
        }
    }
}

