/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.data.FaceDbBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.callback.bigface.IGetFaceResCallBack;
import com.yy.hiyo.channel.cbase.publicscreen.msg.BigFaceMsg;
import com.yy.hiyo.channel.component.bigface.FaceGamePresenter;
import com.yy.hiyo.channel.component.bigface.FaceResManager;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.model.INewUserTagService;
import com.yy.hiyo.component.publicscreen.model.NewUserLabel;
import com.yy.hiyo.component.publicscreen.model.NewUserTagData;
import com.yy.hiyo.component.publicscreen.widge.EmojiTagText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RandomEmojiHolder
extends AbsMsgTitleBarHolder<BigFaceMsg> {
    private static final String TAG = "RandomEmojiHolder";
    private SVGAImageView svBigFace;
    private RecycleImageView ivStatic;
    private YYTextView tvTag;
    private boolean destroyed;
    private boolean isDetachFromWindow = false;
    private boolean isAnimatingStop;
    private boolean isFaceBeanNullError = false;
    private View[] mViews = new View[1];
    @Nullable
    private EmojiTagText emojiTagText;
    private static final BitmapHolder bitmapHolder = new BitmapHolder();

    public RandomEmojiHolder(@NotNull View v, boolean self) {
        super(v, self);
        this.svBigFace = (SVGAImageView)this.itemView.findViewById(R.id.sv_c_msg);
        this.ivStatic = (RecycleImageView)this.itemView.findViewById(R.id.iv_c_img);
        this.emojiTagText = (EmojiTagText)v.findViewById(R.id.emojiTagText);
        this.tvTag = (YYTextView)this.itemView.findViewById(R.id.tvTag);
        this.mViews[0] = this.itemView;
        v.setOnClickListener(view -> {
            Message msg = Message.obtain();
            msg.obj = this.getItemMsg();
            this.mActionHandler.onAction(msg);
        });
    }

    public static void appendExtInfo(String cseq, Bitmap resultBm, String resultPath) {
        bitmapHolder.appendExtInfo(cseq, resultBm, resultPath);
    }

    @Override
    public void bindView(@NotNull BigFaceMsg newData, int position) {
        super.bindView(newData, position);
        this.destroyed = false;
        this.isAnimatingStop = false;
        this.updateItem(newData);
    }

    private void updateItem(BigFaceMsg finalData) {
        bitmapHolder.bindNotify();
        if (finalData.getFaceDbBean() == null && this.mActionHandler != null) {
            Object extendInfo = this.mActionHandler.getExtendInfo("FaceDbBean", finalData.getFaceId());
            if (extendInfo instanceof FaceDbBean) {
                finalData.setFaceDbBean((FaceDbBean)extendInfo);
            } else {
                MLog.error((Object)TAG, (String)"getFaceDbBean null", (Object[])new Object[0]);
                this.isFaceBeanNullError = true;
                return;
            }
        }
        this.isFaceBeanNullError = false;
        if (this.emojiTagText != null) {
            this.emojiTagText.setTabType(finalData.getFaceDbBean().getTabType());
        }
        InnerData data = RandomEmojiHolder.bitmapHolder.getExtInfo(finalData.getCseq());
        if (!finalData.showAnimate && (data.staticResultBitMap != null || StringUtils.isNotEmpty((String)data.staticResultPath))) {
            MLog.info((Object)TAG, (String)"show static result id:%s, bitMap:%b, path:%s", (Object[])new Object[]{finalData.getFaceId(), data.staticResultBitMap != null, data.staticResultPath});
            this.svBigFace.stopAnimation();
            this.svBigFace.setVisibility(4);
            this.ivStatic.setVisibility(0);
            if (StringUtils.isNotEmpty((String)data.staticResultPath)) {
                ImageLoader.loadImage((ImageView)this.ivStatic, (String)data.staticResultPath, (int)R.drawable.icon_default_big_face);
            } else {
                ImageLoader.loadImage((ImageView)this.ivStatic, (String)"", (Drawable)new BitmapDrawable(this.ivStatic.getResources(), data.staticResultBitMap));
            }
        } else {
            MLog.info((Object)TAG, (String)"start load bitmap id:%s", (Object[])new Object[]{finalData.getFaceId()});
            this.svBigFace.stopAnimation();
            this.svBigFace.setVisibility(0);
            this.ivStatic.setVisibility(4);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(finalData.getFaceId() + ".svga");
            List random = null;
            boolean emojiNeedRandomResult = false;
            boolean emojiResultExist = false;
            HashMap<String, String> keyPngs = new HashMap<String, String>();
            if (finalData.getFaceDbBean() != null && !FP.empty((Collection)(random = finalData.getFaceDbBean().getRandoms()))) {
                emojiNeedRandomResult = true;
                ArrayList result = finalData.getResult();
                if (!FP.empty((Collection)result)) {
                    emojiResultExist = true;
                    for (FaceDbBean.RandomVal val : result) {
                        String relativePath = "result_" + val.randomVal + ".png";
                        arrayList.add(relativePath);
                        keyPngs.put(val.key, relativePath);
                    }
                }
            }
            SVGADrawable svgaDrawable = ((BitmapHolder)RandomEmojiHolder.bitmapHolder).getExtInfo((String)finalData.getCseq()).animationDrawable;
            if (!emojiNeedRandomResult && svgaDrawable != null) {
                MLog.info((Object)TAG, (String)"do not need result, show drawable id:%s", (Object[])new Object[]{finalData.getFaceId()});
                this.svBigFace.stopAnimation();
                this.svBigFace.setImageDrawable((Drawable)svgaDrawable);
                this.svBigFace.setLoops(-1);
                this.svBigFace.startAnimation();
                return;
            }
            boolean finalEmojiNeedRandomResult = emojiNeedRandomResult;
            boolean finalEmojiResultExist = emojiResultExist;
            this.parseResultAndShow(finalData, arrayList, keyPngs, finalEmojiNeedRandomResult, finalEmojiResultExist);
        }
        this.updateTag();
    }

    private void updateTag() {
        Object extendInfo;
        if (this.tvTag == null) {
            return;
        }
        boolean isNewUser = false;
        if (this.mActionHandler != null && (extendInfo = this.mActionHandler.getExtendInfo("isNewComer", new Object())) instanceof Boolean) {
            isNewUser = (Boolean)extendInfo;
        }
        NewUserTagData tagData = ((INewUserTagService)ServiceManagerProxy.getService(INewUserTagService.class)).getData();
        if (((BigFaceMsg)this.getItemMsg()).isNewComer() && ((BigFaceMsg)this.getItemMsg()).getUpgradeLabelId() > 0L && tagData.isMeInWhiteList()) {
            this.tvTag.setVisibility(0);
            NewUserLabel label = tagData.findLabel(((BigFaceMsg)this.getItemMsg()).getUpgradeLabelId());
            if (label != null) {
                this.updateUserUpgradeTag(label);
                this.tvTag.setOnClickListener(v -> ToastUtils.showToast((Context)this.tvTag.getContext(), (CharSequence)label.getToastText()));
            }
        } else if (((BigFaceMsg)this.getItemMsg()).isFirstCharge()) {
            this.tvTag.setVisibility(0);
            this.tvTag.setBackgroundResource(R.drawable.ic_lable_first_charge);
            this.tvTag.setText((CharSequence)"");
        } else if (((BigFaceMsg)this.getItemMsg()).isNewComer() && !isNewUser) {
            this.tvTag.setVisibility(0);
            this.tvTag.setBackgroundResource(R.drawable.shape_bg_new_user_tag);
            this.tvTag.setText(R.string.tip_public_screen_new_user_tag);
            this.tvTag.setTextColor(-1);
            this.tvTag.setOnClickListener(v -> ToastUtils.showToast((Context)this.tvTag.getContext(), (int)R.string.tip_new_user_tag_click));
        } else {
            this.tvTag.setVisibility(8);
        }
    }

    private void parseResultAndShow(final BigFaceMsg finalData, final ArrayList<String> arrayList, final Map<String, String> keyPngs, final boolean finalEmojiNeedRandomResult, final boolean finalEmojiResultExist) {
        MLog.info((Object)TAG, (String)"parseResultAndShow id:%s arrayList:%d, keyPngs:%s, finalEmojiNeedRandomResult:%b, finalEmojiResultExist:%b", (Object[])new Object[]{finalData.getFaceId(), arrayList.size(), keyPngs, finalEmojiNeedRandomResult, finalEmojiResultExist});
        FaceResManager.getInstance().getResPath(finalData.getFaceDbBean(), arrayList, new IGetFaceResCallBack(){

            public void onSuccess(final HashMap<String, String> resValue) {
                if (RandomEmojiHolder.this.destroyed) {
                    MLog.error((Object)RandomEmojiHolder.TAG, (String)"parseResultAndShow destroyed id:%s", (Object[])new Object[]{finalData.getFaceId()});
                    return;
                }
                BigFaceMsg itemMsg = (BigFaceMsg)RandomEmojiHolder.this.getItemMsg();
                if (itemMsg != finalData) {
                    MLog.error((Object)RandomEmojiHolder.TAG, (String)"msg change!!! id:%s", (Object[])new Object[]{finalData.getFaceId()});
                    return;
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        final HashMap<String, Bitmap> svgaMap = new HashMap<String, Bitmap>();
                        File file = null;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            String imageName = (String)arrayList.get(i);
                            String localUrl = (String)resValue.get(imageName);
                            if (!imageName.endsWith(".svga")) {
                                Bitmap bitmap = YYImageUtils.decodeFile((String)localUrl);
                                svgaMap.put(imageName, bitmap);
                                continue;
                            }
                            if (!StringUtils.isNotEmpty((String)localUrl)) continue;
                            file = new File(localUrl);
                        }
                        final File fFile = file;
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                RandomEmojiHolder.this.showSvga(RandomEmojiHolder.this.svBigFace, svgaMap, fFile, finalData, keyPngs, !finalEmojiNeedRandomResult || !finalEmojiResultExist, new FaceGamePresenter.FaceSvgaAnimCallBack(){

                                    public void onSvgaAnimFinish(Bitmap bitmap) {
                                        MLog.info((Object)RandomEmojiHolder.TAG, (String)"onSvgaAnimFinish id:%s, bm:%b", (Object[])new Object[]{finalData.getFaceId(), bitmap != null});
                                        ((BitmapHolder)bitmapHolder).getExtInfo((String)finalData.getCseq()).staticResultBitMap = bitmap;
                                    }

                                    public void onSvgaComplete() {
                                    }

                                    public void onNoLocation() {
                                    }
                                });
                            }
                        });
                    }
                });
            }

            public void onError(int errorType, String errorInfo) {
                MLog.error((Object)RandomEmojiHolder.TAG, (String)"getResPath error!!! type:%d, info:%s", (Object[])new Object[]{errorType, errorInfo});
            }
        });
    }

    private void showSvga(final SVGAImageView svgaImageView, final Map<String, Bitmap> map, final File file, final BigFaceMsg currentMsg, final Map<String, String> keyPngs, final boolean animationNotStop, final FaceGamePresenter.FaceSvgaAnimCallBack faceSvgaAnimCallBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                RandomEmojiHolder.this.showSvgaInner(svgaImageView, map, file, currentMsg, keyPngs, animationNotStop, faceSvgaAnimCallBack);
            }
        });
    }

    private void showSvgaInner(final SVGAImageView svgaImageView, final Map<String, Bitmap> map, File file, final BigFaceMsg currentMsg, final Map<String, String> keyPngs, final boolean animationNotStop, final FaceGamePresenter.FaceSvgaAnimCallBack faceSvgaAnimCallBack) {
        MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 \u8fdb\u5165\u52a0\u8f7d svag \u7684\u65b9\u6cd5, map:%d, animationNotStop:%b", (Object[])new Object[]{map.size(), animationNotStop});
        SVGAParser svgaParser = new SVGAParser(this.itemView.getContext());
        FileInputStream inputStream = null;
        if (file != null && file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 svga \u89e3\u6790 inputStream \u51fa\u9519", (Object[])new Object[0]);
                e.printStackTrace();
            }
        } else {
            MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 svga \u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        if (null == inputStream) {
            MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 svga  \u7684 inputstream is null", (Object[])new Object[0]);
            return;
        }
        svgaParser.decodeFromInputStream((InputStream)inputStream, file.getName(), new SVGAParser.ParseCompletion(){

            public void onError2(@org.jetbrains.annotations.Nullable Throwable throwable, @NotNull String s) {
            }

            public void onComplete(@NotNull SVGAVideoEntity svgaVideoEntity) {
                if (currentMsg != RandomEmojiHolder.this.getItemMsg()) {
                    MLog.error((Object)RandomEmojiHolder.TAG, (String)"onComplete when msg not equal!!!", (Object[])new Object[0]);
                    return;
                }
                if (svgaImageView.isAnimating()) {
                    svgaImageView.stopAnimation();
                }
                svgaImageView.setVisibility(0);
                svgaImageView.setDrawingCacheEnabled(true);
                svgaImageView.setCallback(new SVGACallback(){

                    public void onPause() {
                    }

                    public void onFinished() {
                        MLog.info((Object)RandomEmojiHolder.TAG, (String)"\u5927\u8868\u60c5 svga   onFinish", (Object[])new Object[0]);
                        faceSvgaAnimCallBack.onSvgaComplete();
                    }

                    public void onRepeat() {
                    }

                    public void onStep(int i, double v) {
                        if (v == 1.0) {
                            if (animationNotStop) {
                                MLog.info((Object)RandomEmojiHolder.TAG, (String)"animationNotStop", (Object[])new Object[0]);
                                return;
                            }
                            MLog.info((Object)RandomEmojiHolder.TAG, (String)"\u5927\u8868\u60c5 svga onStep", (Object[])new Object[0]);
                            Bitmap bitmap = null;
                            if (map != null && map.size() > 0) {
                                try {
                                    MLog.info((Object)RandomEmojiHolder.TAG, (String)"\u5927\u8868\u60c5 svga get bitmap", (Object[])new Object[0]);
                                    bitmap = Bitmap.createBitmap((Bitmap)svgaImageView.getDrawingCache());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (faceSvgaAnimCallBack != null) {
                                MLog.info((Object)RandomEmojiHolder.TAG, (String)"\u5927\u8868\u60c5 bitmap  \u56de\u8c03, bitmap=%s", (Object[])new Object[]{bitmap != null});
                                faceSvgaAnimCallBack.onSvgaAnimFinish(bitmap);
                                ImageLoader.loadImage((ImageView)RandomEmojiHolder.this.ivStatic, (String)"", (Drawable)new BitmapDrawable(RandomEmojiHolder.this.ivStatic.getResources(), bitmap));
                                RandomEmojiHolder.this.ivStatic.setVisibility(0);
                            } else {
                                MLog.info((Object)RandomEmojiHolder.TAG, (String)"\u5927\u8868\u60c5 faceSvgaAnimCallBack  is null", (Object[])new Object[0]);
                            }
                            svgaImageView.setVisibility(8);
                        }
                    }
                });
                SVGADynamicEntity dynamicItem = null;
                if (keyPngs != null && keyPngs.size() > 0) {
                    dynamicItem = new SVGADynamicEntity();
                    for (Map.Entry entry : keyPngs.entrySet()) {
                        String svgaKey = (String)entry.getKey();
                        String svgaRes = (String)entry.getValue();
                        Bitmap bitmap = (Bitmap)map.get(svgaRes);
                        if (bitmap != null) {
                            dynamicItem.setDynamicImage(bitmap, svgaKey);
                        }
                        MLog.info((Object)RandomEmojiHolder.TAG, (String)"set setDynamicImage svgaKey:%s, key:%s, value:%s", (Object[])new Object[]{svgaKey, svgaRes, bitmap != null});
                    }
                }
                SVGADrawable mySVGADdrawable = null;
                mySVGADdrawable = dynamicItem != null ? new SVGADrawable(svgaVideoEntity, dynamicItem) : new SVGADrawable(svgaVideoEntity);
                svgaImageView.setImageDrawable((Drawable)mySVGADdrawable);
                svgaImageView.setLoops(animationNotStop ? -1 : 1);
                svgaImageView.startAnimation();
                ((BitmapHolder)bitmapHolder).getExtInfo((String)currentMsg.getCseq()).animationDrawable = mySVGADdrawable;
            }

            public void onError() {
                MLog.error((Object)RandomEmojiHolder.TAG, (String)"\u5927\u8868\u60c5 svga parser fail", (Object[])new Object[0]);
            }
        }, true, null, file.getName());
    }

    @KvoMethodAnnotation(name="resultBack", sourceClass=BigFaceMsg.class, thread=1)
    public void onResultBack(KvoEventIntent event) {
        if ("finish".equals(((BigFaceMsg)this.getItemMsg()).getResultBack())) {
            MLog.info((Object)TAG, (String)"onResultBack !!!\uff0cid:%s, result length:%d", (Object[])new Object[]{((BigFaceMsg)this.getItemMsg()).getFaceId(), ((BigFaceMsg)this.getItemMsg()).getResult().size()});
            this.updateItem((BigFaceMsg)this.getItemMsg());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destroyed = true;
        this.stopAnimationAndStop();
        RandomEmojiHolder.bitmapHolder.clearExtInfo();
        bitmapHolder.unbindNotify();
    }

    private void stopAnimation() {
        if (this.svBigFace != null) {
            MLog.info((Object)TAG, (String)"stopAnimation", (Object[])new Object[0]);
            this.isAnimatingStop = this.svBigFace.isAnimating();
            this.svBigFace.stopAnimation();
        }
    }

    private void stopAnimationAndStop() {
        this.stopAnimation();
    }

    @Override
    public void onViewRecycled() {
        super.onViewRecycled();
        this.stopAnimationAndStop();
    }

    @Override
    public void onViewDetachedFromWindow() {
        super.onViewDetachedFromWindow();
        this.isDetachFromWindow = true;
        this.stopAnimationAndStop();
    }

    @Override
    public void onViewAttachedToWindow() {
        super.onViewAttachedToWindow();
        if (this.isDetachFromWindow) {
            this.restoreAnim();
        }
    }

    private void restoreAnim() {
        if (this.isAnimatingStop && this.svBigFace != null && this.svBigFace.getVisibility() == 0) {
            this.svBigFace.startAnimation();
        }
    }

    public void onBigfaceBeanBack() {
        MLog.info((Object)TAG, (String)"onBigfaceBeanBack isFaceBeanNullError:%b", (Object[])new Object[]{this.isFaceBeanNullError});
        if (this.isFaceBeanNullError) {
            this.updateItem((BigFaceMsg)this.getItemMsg());
        }
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }

    @KvoMethodAnnotation(name="labels", sourceClass=NewUserTagData.class, thread=1)
    private void onNewUseLabelsChange(@NotNull KvoEventIntent event) {
        Object msg = this.getItemMsg();
        if (msg != null && !FP.empty(((NewUserTagData)event.source()).getLabels()) && msg.isNewComer() && msg.getUpgradeLabelId() > 0L) {
            this.updateTag();
        }
    }

    private void updateUserUpgradeTag(final NewUserLabel label) {
        this.tvTag.setText((CharSequence)label.getText());
        this.tvTag.setTextColor(label.getTextColor());
        ImageLoader.loadBitmap((Context)this.itemView.getContext(), (String)label.getIcon(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onResourceReady(Bitmap bitmap) {
                int width = (int)(RandomEmojiHolder.this.tvTag.getPaint().measureText(label.getText()) + (float)ResolutionUtils.dip2Px((float)8.0f));
                width = Math.max(ResolutionUtils.dip2Px((float)32.0f), width);
                BitmapDrawable drawable2 = new BitmapDrawable(RandomEmojiHolder.this.itemView.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)ResolutionUtils.dip2Px((float)10.0f), (boolean)false));
                RandomEmojiHolder.this.tvTag.setBackground((Drawable)drawable2);
            }

            public void onLoadFailed(Exception e) {
            }
        }, (int)200, (int)200);
    }

    private static class BitmapHolder {
        private final Map<String, InnerData> sExtData = new LinkedHashMap<String, InnerData>();
        private final Object sLock = new Object();
        private boolean hasBindNotify = false;
        private final INotify mNotify = new INotify(){

            public void notify(Notification notification) {
                if (notification.id == NotificationDef.N_ON_TRIM_MEMORY) {
                    MLog.error((Object)RandomEmojiHolder.TAG, (String)"N_ON_TRIM_MEMORY ", (Object[])new Object[0]);
                    this.checkBitmap(10);
                }
            }
        };

        private BitmapHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InnerData getExtInfo(String cseq) {
            InnerData ext = null;
            Object object = this.sLock;
            synchronized (object) {
                ext = this.sExtData.get(cseq);
                if (ext == null) {
                    ext = new InnerData();
                    ext.cseq = cseq;
                    this.sExtData.put(cseq, ext);
                    this.checkBitmap();
                }
            }
            return ext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendExtInfo(String cseq, Bitmap bm, String path) {
            Object object = this.sLock;
            synchronized (object) {
                if (StringUtils.isNotEmpty((String)cseq)) {
                    InnerData ext = this.getExtInfo(cseq);
                    ext.staticResultBitMap = bm;
                    ext.staticResultPath = path;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearExtInfo() {
            Object object = this.sLock;
            synchronized (object) {
                this.sExtData.clear();
            }
        }

        private void checkBitmap(int limit) {
            int totalLimitSize = limit;
            if (this.sExtData.size() <= totalLimitSize) {
                return;
            }
            Iterator<InnerData> iterator = this.sExtData.values().iterator();
            ArrayList<String> delete = new ArrayList<String>();
            while (iterator.hasNext()) {
                InnerData next = iterator.next();
                if (next.staticResultBitMap == null && next.animationDrawable == null) continue;
                delete.add(next.cseq);
            }
            if (delete.size() > totalLimitSize) {
                int deleSize = delete.size() - totalLimitSize;
                int buffer = 5;
                int realDelete = deleSize + 5 > delete.size() ? deleSize : deleSize + 5;
                for (int i = 0; i < realDelete; ++i) {
                    this.sExtData.remove(delete.get(i));
                }
            }
        }

        private void checkBitmap() {
            this.checkBitmap(50);
        }

        public void bindNotify() {
            if (!this.hasBindNotify) {
                MLog.info((Object)RandomEmojiHolder.TAG, (String)"bindNotify ", (Object[])new Object[0]);
                this.hasBindNotify = true;
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, this.mNotify);
            }
        }

        public void unbindNotify() {
            if (this.hasBindNotify) {
                MLog.info((Object)RandomEmojiHolder.TAG, (String)"unbindNotify ", (Object[])new Object[0]);
                this.hasBindNotify = false;
                NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_ON_TRIM_MEMORY, this.mNotify);
            }
        }
    }

    private static class InnerData {
        String cseq;
        Bitmap staticResultBitMap;
        String staticResultPath;
        SVGADrawable animationDrawable;

        private InnerData() {
        }
    }
}

