/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.os.Message;
import android.view.View;
import android.widget.ImageView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.OutsideGameInviteMsg;
import com.yy.hiyo.component.publicscreen.MsgItemFactory;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.widget.GameDownloadingView;
import com.yy.hiyo.game.service.IGameService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import org.jetbrains.annotations.NotNull;

public class GroupOutsideGameInviteHolder
extends AbsMsgTitleBarHolder<OutsideGameInviteMsg> {
    private static final String TAG = "GroupOutsideGameInviteH";
    private RoundImageView ivHeader;
    private YYTextView tvGameName;
    private YYTextView tvDesc;
    private YYTextView tvJoin;
    private GameDownloadingView gdv;
    private View[] mViews = new View[1];
    private Runnable mRunnable = () -> ((OutsideGameInviteMsg)this.getItemMsg()).setUseful(false);

    public GroupOutsideGameInviteHolder(@NotNull View v, boolean self) {
        super(v, self);
        this.ivHeader = (RoundImageView)v.findViewById(R.id.iv_game_icon);
        this.tvGameName = (YYTextView)v.findViewById(R.id.tv_game_name);
        this.tvDesc = (YYTextView)v.findViewById(R.id.tv_desc);
        this.tvJoin = (YYTextView)v.findViewById(R.id.btn_join);
        this.tvJoin.setOnClickListener(v1 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.CLICK_OUTSIDE_GAME_INVITE;
                msg.obj = this.getItemMsg();
                this.mActionHandler.onAction(msg);
            }
        });
        this.gdv = (GameDownloadingView)v.findViewById(R.id.downloadingView);
        this.gdv.setMarkBackground(-16126);
        this.gdv.setBgSrc(null);
        int width = ResolutionUtils.dip2Px((float)42.0f);
        this.gdv.setType(2);
        this.gdv.setProgressBarWidth(width);
        this.gdv.setDefaultProgressBarWidth(width);
        this.gdv.setDefaultLightWidth(width);
        this.gdv.setProgressShow(false);
        this.mViews[0] = this.itemView;
    }

    @Override
    public void bindView(@NotNull OutsideGameInviteMsg newData, int position) {
        super.bindView(newData, position);
        ImageLoader.loadImage((ImageView)this.ivHeader, (String)newData.getGameInfo().getIconUrl());
        this.tvDesc.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_invite_channel_desc_text));
        this.tvGameName.setText((CharSequence)newData.getGameInfo().getGname());
        this.mBinder.clearAllKvoConnections();
        this.setUsefulView(newData);
        this.mBinder.singleBindSourceTo("msg", (KvoSource)newData);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRunnable);
        long delayTime = newData.calculateDelay(MsgItemFactory.getServerTsOrLocalTs());
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRunnable);
        if (delayTime > 0L && newData.isUseful()) {
            YYTaskExecutor.postToMainThread((Runnable)this.mRunnable, (long)(delayTime * 1000L));
        }
        this.reportEvent();
    }

    @Override
    public void onViewRecycled() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRunnable);
    }

    private void setUsefulView(OutsideGameInviteMsg newData) {
        if (!newData.isUseful()) {
            this.tvJoin.setVisibility(0);
            this.tvJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_invalid));
            this.tvJoin.setBackgroundResource(R.drawable.bg_d3d3d3_24_corner);
            this.gdv.setVisibility(8);
        } else {
            this.gdv.setGameInfo(newData.getGameInfo());
            this.tvJoin.setBackgroundResource(R.drawable.shape_ffc102_24);
            this.tvJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.title_join));
            boolean gameValid = ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).isGameValid(newData.getGameInfo());
            if (gameValid) {
                this.tvJoin.setVisibility(0);
                this.gdv.setVisibility(8);
            } else {
                GameDownloadInfo.DownloadState state = newData.getGameInfo().downloadInfo.getState();
                if (state == GameDownloadInfo.DownloadState.download_not || state == GameDownloadInfo.DownloadState.download_finish) {
                    this.tvJoin.setVisibility(0);
                    this.gdv.setVisibility(8);
                } else {
                    this.tvJoin.setVisibility(8);
                    this.gdv.setVisibility(0);
                }
            }
            this.mBinder.singleBindSourceTo("GameDownloadInfo", (KvoSource)newData.getGameInfo().downloadInfo);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public void onState(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (info.getState() == GameDownloadInfo.DownloadState.download_start) {
            MLog.debug((Object)TAG, (String)"onState start!!! gid: %s", (Object[])new Object[]{((OutsideGameInviteMsg)this.getItemMsg()).getGid()});
            this.tvJoin.setVisibility(8);
            this.gdv.setVisibility(0);
        } else if (info.getState() == GameDownloadInfo.DownloadState.download_finish) {
            MLog.debug((Object)TAG, (String)"onState download_finish gid: %s", (Object[])new Object[]{((OutsideGameInviteMsg)this.getItemMsg()).getGid()});
            this.tvJoin.setVisibility(0);
            this.gdv.setVisibility(8);
        } else if (info.getState() == GameDownloadInfo.DownloadState.download_fail) {
            MLog.debug((Object)TAG, (String)"onState failed gid: %s", (Object[])new Object[]{((OutsideGameInviteMsg)this.getItemMsg()).getGid()});
            this.tvJoin.setVisibility(0);
            this.gdv.setVisibility(8);
        }
    }

    @KvoMethodAnnotation(name="useful", sourceClass=OutsideGameInviteMsg.class, thread=1)
    public void onStateChange(KvoEventIntent event) {
        OutsideGameInviteMsg msg = (OutsideGameInviteMsg)event.source();
        this.setUsefulView(msg);
    }

    @Override
    public void destroy() {
        super.destroy();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRunnable);
        this.mBinder.clearAllKvoConnections();
    }

    private void reportEvent() {
        String roomId = RuntimeContext.getVoiceRoomId();
        int role = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(roomId).getRoleService().getRoleCache(AccountUtil.getUid());
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "game_invite_card_show").put("room_id", roomId).put("gid", "base").put("user_role", String.valueOf(role)).put("game_id", ((OutsideGameInviteMsg)this.getItemMsg()).getGid()));
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }
}

