/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.widge;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.text.Layout;
import android.text.SpannedString;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.ui.widget.FlowLayout;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.user.UserBBSMedalInfo;
import com.yy.appbase.user.UserMedalBubbleUtil;
import com.yy.appbase.util.DistanceParser;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.framework.core.ui.svga.YYSvgaImageView;
import com.yy.hiyo.channel.anchorfansclub.IFansClubService;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.bean.SimpleCardInfo;
import com.yy.hiyo.channel.base.bean.UserTagLocation;
import com.yy.hiyo.channel.base.bean.fansgroup.FansBadgeBean;
import com.yy.hiyo.channel.base.bean.fansgroup.FansBadgeConfig;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IFamilyLuckyBagService;
import com.yy.hiyo.channel.base.widget.FansBadgeView;
import com.yy.hiyo.channel.base.widget.UserTagsLayout;
import com.yy.hiyo.channel.cbase.publicscreen.HonorChatBean;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupConfig;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupData;
import com.yy.hiyo.channel.component.textgroup.protocol.IMsgTitleView;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.bean.MedalConfig;
import com.yy.hiyo.component.publicscreen.bean.MsgExtInfo;
import com.yy.hiyo.component.publicscreen.callback.IMsgActionHandler;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import com.yy.hiyo.component.publicscreen.theme.IThemeView;
import com.yy.hiyo.component.publicscreen.theme.ThemePackage;
import com.yy.hiyo.component.publicscreen.theme.themeview.YYThemeTextView;
import com.yy.hiyo.component.publicscreen.widge.BaseBasicUserTitleView;
import com.yy.hiyo.component.publicscreen.widge.BaseSelfUserTitleView;
import com.yy.hiyo.component.publicscreen.widge.FansGroupView;
import com.yy.hiyo.wallet.base.privilege.bean.NickColorConfig;
import com.yy.location.LocationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.ihago.medal.srv.mgr.MedalInfo;
import okhttp3.Call;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseUserTitleView
extends YYLinearLayout
implements IMsgTitleView {
    private static final String TAG = "BaseUserTitleView";
    private final int mIconSize = this.getIconSize();
    private BaseImMsg baseImMsg;
    private HeadFrameImageView ivAvatar;
    private YYThemeTextView tvNick;
    private YYTextView tvDistance;
    private MsgExtInfo mMsgExtInfo;
    private FansGroupData mFansGroupData;
    private FansBadgeBean mFansBadgeBean;
    private MutableLiveData<List<Long>> familyHighConsList;
    private boolean isAnchor;
    private long channelOwnerUid = 0L;
    private IMsgActionHandler mActionHandler;
    private UserInfoKS mTempUserInfo;
    private float maxWidth = 0.0f;
    private long mFromUid;
    private IThemeRes mThemeRes;
    private MedalConfig mMedalConfig = null;
    private Map<String, Object> mExtendInfoMap;
    private RecycleImageView mBBSLogo;
    private UserBBSMedalInfo mMedalInfo;
    private FlowLayout mFlowLayout;
    private boolean isSingleLine = false;
    private IOnMeasuredListener onMeasuredListener = null;
    private Space space;
    private LifecycleOwner mLifecycleOwner;
    private HeadFrameType mHeadFrameType;
    private boolean happenDettach;
    private Observer<List<Long>> familyHighConsObserver = longs -> this.updateNickColor(this.mFromUid);
    private Observer<List<SimpleCardInfo>> simpleCardObserver = list -> this.onNickChange();
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    Observer<FansGroupConfig> mFansGroupConfigObserver = fansGroupConfig -> this.onNickChange();

    public BaseUserTitleView(Context context) {
        super(context);
        this.createView(null);
    }

    public BaseUserTitleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public BaseUserTitleView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(attrs);
    }

    private void createView(AttributeSet attrs) {
        LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this);
        if (((Object)((Object)this)).getClass() == BaseUserTitleView.class) {
            this.setGravity(16);
        }
        this.space = (Space)this.findViewById(R.id.sp);
        this.mFlowLayout = (FlowLayout)this.findViewById(R.id.flowLayout);
        if (LanguageUtils.isRtl()) {
            if (((Object)((Object)this)).getClass() == BaseSelfUserTitleView.class) {
                this.mFlowLayout.setRtl(false);
            } else {
                this.mFlowLayout.setRtl(true);
            }
        }
        this.ivAvatar = (HeadFrameImageView)this.findViewById(R.id.iv_c_head);
        LinearLayout.LayoutParams param = (LinearLayout.LayoutParams)this.ivAvatar.getLayoutParams();
        param.gravity = 48;
        this.ivAvatar.setLayoutParams((ViewGroup.LayoutParams)param);
        this.tvNick = (YYThemeTextView)this.findViewById(R.id.tv_c_nick);
        this.tvNick.setOnTouchListener(new View.OnTouchListener(){
            long startTime = 0L;

            public boolean onTouch(View v, MotionEvent event) {
                TextView tv;
                CharSequence text;
                int action = event.getAction();
                if (action == 0) {
                    this.startTime = System.currentTimeMillis();
                }
                if ((text = (tv = (TextView)v).getText()) instanceof SpannedString && action == 1) {
                    int line;
                    if (System.currentTimeMillis() - this.startTime > 300L) {
                        return false;
                    }
                    int x = (int)event.getX();
                    int y = (int)event.getY();
                    x -= tv.getTotalPaddingLeft();
                    y -= tv.getTotalPaddingTop();
                    Layout layout2 = tv.getLayout();
                    int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += tv.getScrollY()), (float)(x += tv.getScrollX()));
                    ChainSpan.ClickSpan[] link = (ChainSpan.ClickSpan[])((SpannedString)text).getSpans(off, off, ChainSpan.ClickSpan.class);
                    if (link.length != 0) {
                        link[0].onClick((View)tv);
                        return true;
                    }
                }
                return false;
            }
        });
        View.OnClickListener listener2 = v -> {
            MLog.info((Object)TAG, (String)"mActionHandler:%s item:%s", (Object[])new Object[]{this.mActionHandler, this.baseImMsg});
            if (this.baseImMsg != null) {
                if (this.baseImMsg.getRobotMsgType() == 3) {
                    return;
                }
                if (this.mActionHandler != null) {
                    Message msg = Message.obtain();
                    msg.what = ActionDefine.SHOW_USER_PROFILE;
                    MLog.info((Object)TAG, (String)"type:%d robotInfo:%s", (Object[])new Object[]{this.baseImMsg.getRobotMsgType(), this.baseImMsg.getChannelRobotInfo()});
                    if (this.baseImMsg.getRobotMsgType() == 1 && this.baseImMsg.getChannelRobotInfo() != null) {
                        msg.arg1 = 1;
                        msg.obj = this.baseImMsg.getChannelRobotInfo();
                    } else {
                        msg.arg1 = 0;
                        msg.obj = this.baseImMsg.getFrom();
                    }
                    this.mActionHandler.onAction(msg);
                }
            }
        };
        this.tvNick.setOnClickListener(listener2);
        this.tvDistance = (YYTextView)this.findViewById(R.id.tv_c_distance);
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.VGWidth);
            this.maxWidth = typedArray.getDimension(R.styleable.VGWidth_maxWidth, 0.0f);
            typedArray.recycle();
        }
        if (this.ivAvatar != null) {
            this.ivAvatar.setOnClickListener(listener2);
            this.ivAvatar.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    MLog.info((Object)BaseUserTitleView.TAG, (String)"mActionHandler:%s item:%s", (Object[])new Object[]{BaseUserTitleView.this.mActionHandler, BaseUserTitleView.this.baseImMsg});
                    if (BaseUserTitleView.this.baseImMsg != null) {
                        if (BaseUserTitleView.this.baseImMsg.getRobotMsgType() == 3) {
                            return false;
                        }
                        if (BaseUserTitleView.this.mActionHandler != null) {
                            Message msg = Message.obtain();
                            msg.what = ActionDefine.SHOW_AT_LONG_CLICK;
                            msg.arg1 = 0;
                            msg.obj = BaseUserTitleView.this.baseImMsg.getFrom();
                            BaseUserTitleView.this.mActionHandler.onAction(msg);
                        }
                    }
                    return false;
                }
            });
        }
        if (this.tvNick != null) {
            this.tvNick.setThemeInterceptor(new IThemeView.Interceptor(){

                @Override
                public boolean intercept(@Nullable ThemePackage themePackage) {
                    long from = BaseUserTitleView.this.mFromUid;
                    return from > 0L && BaseUserTitleView.this.updateNickColor(from);
                }
            });
        }
        this.mBBSLogo = (RecycleImageView)this.findViewById(R.id.lctsv_bbs_logo);
        this.mBBSLogo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserMedalBubbleUtil.showBubble((View)BaseUserTitleView.this.mBBSLogo);
            }
        });
    }

    private boolean updateNickColor(long from) {
        if (this.highConUid(from)) {
            this.tvNick.setTextColor(ResourceUtils.getColor((int)R.color.color_ff4a6d));
            return true;
        }
        NickColorConfig nickColorConfig = PrivilegeHelper.INSTANCE.getNickColorConfig(from);
        if (nickColorConfig != null && StringUtils.isNotEmpty((String)nickColorConfig.getColor())) {
            try {
                this.tvNick.setTextColor(ColorUtils.parseColor((String)nickColorConfig.getColor()));
                return true;
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"nickColorConfig parse error:%s!!!!", (Object[])new Object[]{nickColorConfig.getColor()});
            }
        }
        return false;
    }

    private boolean highConUid(long from) {
        if (ServiceManagerProxy.getService(IFamilyLuckyBagService.class) != null && this.baseImMsg != null) {
            return ((IFamilyLuckyBagService)ServiceManagerProxy.getService(IFamilyLuckyBagService.class)).highContributorUid(from, this.baseImMsg.getCid());
        }
        return false;
    }

    @LayoutRes
    protected int getLayoutId() {
        return R.layout.layout_channel_title_view;
    }

    public void setMsgExtInfo(MsgExtInfo info) {
        if (this.mMsgExtInfo != null) {
            this.mBinder.clearKvoConnection(MsgExtInfo.class.getName());
        }
        this.mMsgExtInfo = info;
        if (info != null) {
            this.mBinder.singleBindSourceTo((KvoSource)this.mMsgExtInfo);
        }
    }

    public void setFansBadgeBean(FansBadgeBean bean) {
        this.mFansBadgeBean = bean;
        this.onNickChange();
    }

    public void setChannelOwnerUid(long uid) {
        this.channelOwnerUid = uid;
    }

    public void setAnchor(boolean value) {
        this.isAnchor = value;
    }

    private void updateFansGroupView() {
        if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() != 1 && this.mFansGroupData != null) {
            if (this.mFansGroupData.getFansGroupConfig().getValue() == null || ((FansGroupConfig)this.mFansGroupData.getFansGroupConfig().getValue()).getTypeConfigInfo().isOnlyShow() && this.mThemeRes.getCurrentMode() != 14) {
                return;
            }
            FansGroupView recycleImageView = new FansGroupView(this.getContext());
            recycleImageView.setDate(this.mFansGroupData);
            int offset = 2;
            int insertIndex = this.mFlowLayout.getChildCount() - offset;
            this.mFlowLayout.addView((View)recycleImageView, insertIndex);
            recycleImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BaseUserTitleView.this.mActionHandler != null) {
                        Message msg = Message.obtain();
                        msg.what = ActionDefine.CLICK_FANS_GROUP;
                        msg.obj = BaseUserTitleView.this.mFansGroupData;
                        BaseUserTitleView.this.mActionHandler.onAction(msg);
                    }
                }
            });
        }
    }

    private void updateFansBadgeView() {
        FansBadgeConfig config;
        if (this.mFansBadgeBean == null) {
            return;
        }
        IFansClubService fansClubService = (IFansClubService)ServiceManagerProxy.getService(IFansClubService.class);
        if (fansClubService != null && (config = (FansBadgeConfig)fansClubService.getAllFansBadgeConfig().get((Object)this.mFansBadgeBean.getLevel())) != null) {
            FansBadgeView fansBadgeView = new FansBadgeView(this.getContext());
            fansBadgeView.updateData(this.mFansBadgeBean, config);
            int offset = 2;
            int insertIndex = this.mFlowLayout.getChildCount() - offset;
            this.mFlowLayout.addView((View)fansBadgeView, insertIndex);
        }
    }

    public void setAvatarUrl(String url) {
        if (this.ivAvatar != null) {
            ImageLoader.loadImage((ImageView)this.ivAvatar.getCircleImageView(), (String)url, (int)R.drawable.icon_public_msg_avatar);
            if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() != 1) {
                this.setHeadFrame();
            } else {
                this.ivAvatar.setHeadFrame("");
            }
        }
    }

    private void setHeadFrame() {
        final long uid = this.baseImMsg.getFrom();
        if (uid >= 0L) {
            ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getSingleHeadFrame(uid, new OnGetHeadFrameCallback(){

                public void onGetHeadFrameSuccess(List<Integer> list) {
                    if (!FP.empty(list)) {
                        String url = ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(list.get(0).intValue());
                        if (BaseUserTitleView.this.ivAvatar != null) {
                            BaseUserTitleView.this.ivAvatar.setHeadFrame(url);
                        }
                    }
                }

                public void onError(Call call, Exception e, int id2) {
                    MLog.error((Object)BaseUserTitleView.TAG, (String)"fetchOtherHeadFrame error, uid=%d", (Object[])new Object[]{uid});
                    if (BaseUserTitleView.this.ivAvatar != null) {
                        BaseUserTitleView.this.ivAvatar.setHeadFrame("");
                    }
                }

                public void onResponseError(int id2, String message, String response) {
                    MLog.error((Object)BaseUserTitleView.TAG, (String)"fetchOtherHeadFrame error, uid=%d, msg=%s", (Object[])new Object[]{uid, message});
                    if (BaseUserTitleView.this.ivAvatar != null) {
                        BaseUserTitleView.this.ivAvatar.setHeadFrame("");
                    }
                }
            });
        } else if (this.ivAvatar != null) {
            this.ivAvatar.setHeadFrame("");
        }
    }

    public void setNick(String nick) {
        if (this.tvNick != null) {
            this.tvNick.setText(nick);
        }
    }

    public void setSendTs(long ts) {
    }

    public <T extends BaseImMsg> void bindMsg(T msg) {
        if (this.familyHighConsList != null) {
            this.familyHighConsList.removeObserver(this.familyHighConsObserver);
        }
        msg.getUserTagInfos().removeObserver(this.simpleCardObserver);
        if (msg.getRobotMsgType() == 1 && msg.getChannelRobotInfo() != null) {
            if (this.mTempUserInfo != null) {
                Kvo.autoUnbindingFrom((KvoSource)this.mTempUserInfo, (Object)((Object)this));
                this.mTempUserInfo = null;
            }
            if (this.baseImMsg != null && this.baseImMsg != msg) {
                this.mBinder.clearKvoConnection("msg");
            }
            this.baseImMsg = msg;
            if (this.mMedalInfo != null) {
                Kvo.autoUnbindingFrom((KvoSource)this.mMedalInfo, (Object)((Object)this));
                this.mMedalInfo = null;
            }
            String robotAvatar = msg.getChannelRobotInfo().avatar;
            String robotName = msg.getChannelRobotInfo().robotName;
            if (this.ivAvatar != null) {
                ImageLoader.loadImage((ImageView)this.ivAvatar.getCircleImageView(), (String)robotAvatar, (int)R.drawable.yylite_launcher);
            }
            this.setNick(robotName.trim());
            this.mFlowLayout.removeAllViews();
            YYThemeTextView mRoleIcon = new YYThemeTextView(this.getContext());
            mRoleIcon.setBackground(ResourceUtils.getDrawable((int)R.drawable.shape_robot_tag));
            mRoleIcon.setText("  Robot  ");
            mRoleIcon.setTextSize(10.0f);
            mRoleIcon.setTextColor(-1);
            ViewGroup.LayoutParams roleIconParams = new ViewGroup.LayoutParams(-2, this.mIconSize);
            this.mFlowLayout.addView((View)mRoleIcon, 0, roleIconParams);
            this.mFlowLayout.addView((View)this.tvNick);
            this.mBinder.singleBindSourceTo("msg", msg);
            this.setSingleLine(this.isSingleLine);
        } else {
            long uid = msg.getFrom();
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(uid);
            if (this.mTempUserInfo != null && userInfoKS != this.mTempUserInfo) {
                Kvo.autoUnbindingFrom((KvoSource)this.mTempUserInfo, (Object)((Object)this));
            }
            if (this.baseImMsg != null && this.baseImMsg != msg) {
                this.mBinder.clearKvoConnection("msg");
            }
            this.mTempUserInfo = userInfoKS;
            this.baseImMsg = msg;
            if (uid <= 0L || uid == 10L || msg instanceof PureTextMsg && ((PureTextMsg)msg).isNotSupportMsg()) {
                this.mTempUserInfo.nick = ResourceUtils.getString((int)R.string.hago_app_name) + " ";
                this.setRobot(this.mTempUserInfo.nick, R.drawable.yylite_launcher);
            } else if (msg.getRobotMsgType() == 3) {
                this.setRobot(ResourceUtils.getString((int)R.string.among_us_robot_nick) + " ", R.drawable.icon_among_us_robot);
            } else {
                Kvo.addKvoBinding((KvoSource)userInfoKS, (Object)((Object)this), (String)"onAvatarChange");
                Kvo.addKvoBinding((KvoSource)userInfoKS, (Object)((Object)this), (String)"onNickChange");
                if (uid == AccountUtil.getUid()) {
                    this.mHeadFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
                    Kvo.addKvoBinding((KvoSource)this.mHeadFrameType, (Object)((Object)this), (String)"onMyHeadFrameTypeUpdate");
                }
            }
            this.mBinder.singleBindSourceTo("msg", msg);
            if (ServiceManagerProxy.getService(IFamilyLuckyBagService.class) != null && StringUtils.isNotEmpty((String)msg.getCid())) {
                this.familyHighConsList = ((IFamilyLuckyBagService)ServiceManagerProxy.getService(IFamilyLuckyBagService.class)).getHighUidList(msg.getCid());
                if (null != this.mLifecycleOwner && null != this.familyHighConsList) {
                    this.familyHighConsList.observe(this.mLifecycleOwner, this.familyHighConsObserver);
                }
            }
            this.baseImMsg.getUserTagInfos().observeForever(this.simpleCardObserver);
            if (uid <= 0L || uid == 10L || uid == AccountUtil.getUid()) {
                this.tvDistance.setText((CharSequence)"");
                this.tvDistance.setVisibility(8);
            } else if (null != this.mExtendInfoMap && this.mExtendInfoMap.containsKey("isSameCity")) {
                boolean isSameCity = (Boolean)this.mExtendInfoMap.get("isSameCity");
                if (isSameCity) {
                    String distance = this.getDistance(userInfoKS, msg.getSections());
                    this.tvDistance.setText((CharSequence)(FP.empty((CharSequence)distance) ? "" : "| " + distance));
                    this.tvDistance.setVisibility(0);
                } else {
                    this.tvDistance.setText((CharSequence)"");
                    this.tvDistance.setVisibility(8);
                }
            } else {
                this.tvDistance.setText((CharSequence)"");
                this.tvDistance.setVisibility(8);
            }
            this.mMedalInfo = UserBBSMedalInfo.info((long)this.mTempUserInfo.uid);
            Kvo.addKvoBinding((KvoSource)this.mMedalInfo, (Object)((Object)this), (String)"onUserBBSMedal");
        }
    }

    private void setRobot(String nickName, int iconRes) {
        this.ivAvatar.setVisibility(0);
        this.space.setVisibility(0);
        if (this.ivAvatar != null) {
            ImageLoader.loadImage((ImageView)this.ivAvatar.getCircleImageView(), (int)iconRes);
        }
        this.setNick(nickName);
    }

    private void findGoneParent(View view) {
        if (view != null && view.getVisibility() == 0) {
            MLog.info((Object)"lzw", (String)("view visible " + view), (Object[])new Object[0]);
            this.findGoneParent((View)view.getParent());
        } else {
            MLog.error((Object)"lzw", (String)("view gone " + view), (Object[])new Object[0]);
        }
    }

    @KvoMethodAnnotation(name="avatar", sourceClass=UserInfoKS.class, thread=1)
    public void onAvatarChange(KvoEventIntent event) {
        String avatar = (String)event.newValue();
        if (avatar != null && this.ivAvatar != null) {
            ImageLoader.loadImage((ImageView)this.ivAvatar.getCircleImageView(), (String)(avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.icon_avatar_default_male);
            if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() != 1) {
                this.setHeadFrame();
            } else {
                this.ivAvatar.setHeadFrame("");
            }
        }
    }

    @KvoMethodAnnotation(name="nick", sourceClass=UserInfoKS.class, thread=1)
    public void onNickChange(KvoEventIntent event) {
        this.onNickChange();
    }

    @KvoMethodAnnotation(name="medalInfoList", sourceClass=UserBBSMedalInfo.class, thread=1)
    public void onUserBBSMedal(KvoEventIntent kvoEvent) {
        List medalInfoList = (List)kvoEvent.newValue();
        MLog.info((Object)TAG, (String)("mBBSLogo: " + (this.mBBSLogo == null ? "null" : "not null") + ", medalInfo: " + (FP.empty((Collection)medalInfoList) ? "empty" : "not empty")), (Object[])new Object[0]);
        if (this.mBBSLogo != null) {
            this.mBBSLogo.setImageResource(R.drawable.icon_active);
            if (medalInfoList == null || medalInfoList.isEmpty() || this.mThemeRes == null || this.mThemeRes.getCurrentMode() != 1) {
                this.mBBSLogo.setVisibility(8);
            } else {
                this.mBBSLogo.setVisibility(0);
                MLog.info((Object)TAG, (String)("url: " + ((MedalInfo)medalInfoList.get((int)0)).url), (Object[])new Object[0]);
                ImageLoader.loadImage((ImageView)this.mBBSLogo, (String)((MedalInfo)medalInfoList.get((int)0)).url);
            }
        }
    }

    @KvoMethodAnnotation(name="role", sourceClass=BaseImMsg.class, thread=1)
    protected void onRoleChange(KvoEventIntent event) {
        this.onNickChange();
    }

    @KvoMethodAnnotation(name="rankImgUrl", sourceClass=MsgExtInfo.class, thread=1)
    protected void onRankChange(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        this.onNickChange();
    }

    @KvoMethodAnnotation(name="honerIds", sourceClass=BaseImMsg.class, thread=1)
    protected void onHonorsChange(KvoEventIntent event) {
        if (null != this.mActionHandler) {
            MsgExtInfo msgExtInfo = (MsgExtInfo)((Object)this.mActionHandler.getExtendInfo("Rank", this.baseImMsg));
            if (msgExtInfo != null && msgExtInfo.getHoners() != this.mMsgExtInfo.getHoners()) {
                this.setMsgExtInfo(msgExtInfo);
            }
            this.onNickChange();
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.baseImMsg.getFrom() != AccountUtil.getUid()) {
            return;
        }
        if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() != 1) {
            int frameId = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frameId));
        } else {
            this.ivAvatar.setHeadFrame("");
        }
    }

    public void setActionHandler(IMsgActionHandler mActionHandler) {
        this.mActionHandler = mActionHandler;
    }

    public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
        this.mLifecycleOwner = lifecycleOwner;
    }

    private void resetLayout() {
        if (this.mFlowLayout != null) {
            this.mFlowLayout.removeAllViews();
            this.setSingleLine(this.isSingleLine);
            if (this.mBBSLogo != null && this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1) {
                this.mFlowLayout.addView((View)this.mBBSLogo);
            }
            if (this.tvNick != null) {
                this.mFlowLayout.addView((View)this.tvNick);
            }
            if (this.tvDistance != null) {
                this.mFlowLayout.addView((View)this.tvDistance);
            }
        }
    }

    private void onNickChange() {
        if (this.tvNick == null || this.mTempUserInfo == null || this.baseImMsg.getRobotMsgType() == 3) {
            return;
        }
        this.resetLayout();
        int roles = this.baseImMsg.getRole();
        boolean hasRole = roles == 15 || roles == 10 || roles == 5;
        int iconHeight = this.mIconSize;
        String appendNick = this.mTempUserInfo.nick;
        if (this.baseImMsg.isShowChannelNick() && !FP.empty((CharSequence)this.baseImMsg.getChannelNick())) {
            appendNick = this.baseImMsg.getChannelNick();
        }
        if ((((Object)((Object)this)).getClass() == BaseSelfUserTitleView.class || ((Object)((Object)this)).getClass() == BaseBasicUserTitleView.class) && appendNick.length() > 15) {
            appendNick = appendNick.substring(0, 15);
            appendNick = appendNick + "...";
        }
        this.setNick(appendNick);
        if (hasRole) {
            int userIconSize = this.mIconSize;
            RecycleImageView mRoleIcon = new RecycleImageView(this.getContext());
            ViewGroup.LayoutParams roleIconParams = new ViewGroup.LayoutParams(userIconSize, userIconSize);
            this.mFlowLayout.addView((View)mRoleIcon, this.mFlowLayout.indexOfChild((View)this.ivAvatar) + 1, roleIconParams);
            if (roles == 15) {
                mRoleIcon.setImageResource(R.drawable.icon_group_host);
            } else if (roles == 10) {
                mRoleIcon.setImageResource(R.drawable.icon_group_administrator);
            } else if (this.isAnchor) {
                mRoleIcon.setImageResource(R.drawable.icon_room_host);
            } else {
                mRoleIcon.setImageResource(R.drawable.icon_group_member);
            }
        }
        this.updateChannelTitle();
        if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() != 1 && this.mMsgExtInfo != null && StringUtils.isNotEmpty((String)this.mMsgExtInfo.getRankImgUrl())) {
            RecycleImageView mContributionRankIcon = new RecycleImageView(this.getContext());
            float ratio = 1.0f;
            if (this.mMsgExtInfo.getRankImgHeight() > 0) {
                ratio = 1.0f * (float)this.mMsgExtInfo.getRankImgWidth() / (float)this.mMsgExtInfo.getRankImgHeight();
            }
            int width = (int)((float)iconHeight * ratio);
            ViewGroup.LayoutParams rankIconParams = new ViewGroup.LayoutParams(width, iconHeight);
            this.addIcon((ImageView)mContributionRankIcon, rankIconParams);
            ImageLoader.loadImage((ImageView)mContributionRankIcon, (String)this.mMsgExtInfo.getRankImgUrl());
        }
        this.addUserCard();
        this.updateFansGroupView();
        this.updateFansBadgeView();
        if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() != 1 && this.mMsgExtInfo != null && !FP.empty(this.mMsgExtInfo.getHoners())) {
            ArrayList<HonorChatBean> honorChatBeans = new ArrayList<HonorChatBean>(this.mMsgExtInfo.getHoners());
            for (final HonorChatBean honorChatBean : honorChatBeans) {
                if (honorChatBean == null) continue;
                if (honorChatBean.getLocation() == 1 && this.mMedalConfig != null && !this.mMedalConfig.getShowGrade()) {
                    MLog.info((Object)TAG, (String)"ignore LocationLevel bean:%s", (Object[])new Object[]{honorChatBean});
                    continue;
                }
                if (this.mMedalConfig != null && !this.mMedalConfig.getShowActivity()) {
                    MLog.info((Object)TAG, (String)"ignore LocationActivity bean:%s", (Object[])new Object[]{honorChatBean});
                    continue;
                }
                float ratio = 1.0f;
                if (honorChatBean.getHeight() > 0) {
                    ratio = 1.0f * (float)honorChatBean.getWidth() / (float)honorChatBean.getHeight();
                }
                int width = (int)((float)iconHeight * ratio);
                final YYSvgaImageView medalImageView = new YYSvgaImageView(this.getContext());
                medalImageView.setFillMode(SVGAImageView.FillMode.Forward);
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(width, iconHeight);
                medalImageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MLog.info((Object)BaseUserTitleView.TAG, (String)"click honor medal honorChatBean: %s", (Object[])new Object[]{honorChatBean});
                        if (BaseUserTitleView.this.mActionHandler != null) {
                            Message msg = Message.obtain();
                            msg.what = ActionDefine.CLICK_MEDAL;
                            msg.arg1 = honorChatBean.getId();
                            msg.arg2 = 1;
                            msg.obj = BaseUserTitleView.this.baseImMsg.getFrom();
                            BaseUserTitleView.this.mActionHandler.onAction(msg);
                        }
                    }
                });
                this.addIcon((ImageView)medalImageView, layoutParams);
                SvgaLoader.load((SVGAImageView)medalImageView, (String)honorChatBean.getUrl(), (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (svgaVideoEntity != null) {
                            SVGADrawable svgaDrawable = new SVGADrawable(svgaVideoEntity);
                            medalImageView.setImageDrawable((Drawable)svgaDrawable);
                            medalImageView.setSVGADrawable(svgaDrawable);
                            medalImageView.startAnimation();
                        }
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)BaseUserTitleView.TAG, (String)"loadSvga failed,url:%s,exception:%s", (Object[])new Object[]{honorChatBean.getUrl(), e.toString()});
                        medalImageView.stopAnimation();
                    }
                });
            }
        }
    }

    private void updateChannelTitle() {
        if (this.baseImMsg.isShowChannelTitle() && !FP.empty((CharSequence)this.baseImMsg.getChannelTitleName())) {
            YYTextView titleTextView = new YYTextView(this.getContext());
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, ResolutionUtils.dip2Px((float)12.0f));
            titleTextView.setMaxWidth(ResolutionUtils.dip2Px((float)80.0f));
            titleTextView.setPadding(ResolutionUtils.dip2Px((float)5.0f), 0, ResolutionUtils.dip2Px((float)5.0f), 0);
            titleTextView.setTextColor(ColorUtils.parseColor((String)"#ffffff"));
            titleTextView.setMaxLines(1);
            titleTextView.setTextSize(8.0f);
            titleTextView.setSingleLine(true);
            titleTextView.setGravity(16);
            titleTextView.setText((CharSequence)this.baseImMsg.getChannelTitleName());
            int dpValue = ResolutionUtils.dip2Px((float)2.0f);
            if (!FP.empty((CharSequence)this.baseImMsg.getChannelTitleBg())) {
                titleTextView.setBackground((Drawable)DrawableUtil.getRoundDrawable((int)dpValue, (int)ColorUtils.parseColor((String)this.baseImMsg.getChannelTitleBg())));
            }
            this.addTextView(titleTextView, params);
        }
    }

    private void addUserCard() {
        List mUserTagInfoList = null;
        if (this.baseImMsg != null) {
            mUserTagInfoList = ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).getUserTagsFromConfig((List)this.baseImMsg.getUserTagInfos().getValue());
        }
        if (mUserTagInfoList == null || mUserTagInfoList.size() <= 0) {
            return;
        }
        if (this.mThemeRes != null) {
            UserTagsLayout tagsLayout = new UserTagsLayout(this.getContext(), ResourceUtils.getDimen((int)R.dimen.channel_user_tag_size));
            int offset = 2;
            int insertIndex = this.mFlowLayout.getChildCount() - offset;
            tagsLayout.setGravity(16);
            List viewList = tagsLayout.createItemViewList(mUserTagInfoList, UserTagLocation.LOCATION_MSG_APP.getLocation(), this.mFromUid, this.mIconSize);
            for (View view : viewList) {
                if (view == null) continue;
                if (view.getLayoutParams() instanceof LinearLayout.LayoutParams) {
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                    layoutParams.rightMargin = 0;
                    view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
                this.mFlowLayout.addView(view, insertIndex++);
            }
        }
    }

    private void addIcon(ImageView imageView, ViewGroup.LayoutParams layoutParams) {
        int offset = 2;
        int insertIndex = this.mFlowLayout.getChildCount() - offset;
        this.mFlowLayout.addView((View)imageView, insertIndex, layoutParams);
    }

    private void addTextView(YYTextView textView, ViewGroup.LayoutParams layoutParams) {
        int offset = 2;
        int insertIndex = this.mFlowLayout.getChildCount() - offset;
        this.mFlowLayout.addView((View)textView, insertIndex, layoutParams);
    }

    public void addSingleIcon(View view, ViewGroup.LayoutParams layoutParams) {
        if (this.mFlowLayout.getChildCount() <= 0) {
            this.mFlowLayout.addView(view, layoutParams);
        }
    }

    public void setFromUid(long from) {
        this.mFromUid = from;
    }

    public void destroy() {
        if (this.mMsgExtInfo != null) {
            this.mBinder.clearKvoConnection(MsgExtInfo.class.getName());
        }
        if (this.baseImMsg != null) {
            this.mBinder.clearKvoConnection("msg");
            if (this.baseImMsg.getFrom() == AccountUtil.getUid()) {
                HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
                Kvo.removeKvoBinding((KvoSource)headFrameType, (Object)((Object)this), (String)"onMyHeadFrameTypeUpdate");
            }
            this.baseImMsg.getUserTagInfos().removeObserver(this.simpleCardObserver);
        }
        if (this.mMedalConfig != null) {
            this.mBinder.clearKvoConnection(MedalConfig.class.getName());
        }
        if (this.mFansGroupData != null) {
            this.mFansGroupData.getFansGroupConfig().removeObserver(this.mFansGroupConfigObserver);
        }
        if (this.familyHighConsList != null) {
            this.familyHighConsList.removeObserver(this.familyHighConsObserver);
        }
        if (this.mTempUserInfo != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mTempUserInfo, (Object)((Object)this));
        }
        if (this.mMedalInfo != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mMedalInfo, (Object)((Object)this));
        }
        if (this.mHeadFrameType != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mHeadFrameType, (Object)((Object)this));
        }
        this.familyHighConsList = null;
        this.mActionHandler = null;
    }

    public void setTheme(@Nullable IThemeRes mThemeRes) {
        this.mThemeRes = mThemeRes;
    }

    public void setExtendInfo(Map<String, Object> extendInfo) {
        this.mExtendInfoMap = extendInfo;
    }

    public void setShowConfig(MedalConfig showConfig) {
        if (this.mMedalConfig != null) {
            this.mBinder.clearKvoConnection(MedalConfig.class.getName());
            this.mMedalConfig = null;
        }
        if (showConfig != null) {
            this.mMedalConfig = showConfig;
            this.mBinder.singleBindSourceTo((KvoSource)showConfig);
        }
    }

    private String getDistance(UserInfoKS fromInfo, List<MsgSection> sectionList) {
        String fromLat;
        String fromLng;
        if (!PermissionHelper.hasLocationPermission((Activity)((FragmentActivity)this.getContext())) || fromInfo.hideLocation == 1L || FP.empty(sectionList)) {
            return "";
        }
        MsgSection msgSection = null;
        for (MsgSection section : sectionList) {
            if (section.getType() != 2011) continue;
            msgSection = section;
            break;
        }
        if (null == msgSection) {
            return "";
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)msgSection.getContent());
            fromLng = jsonObject.optString("lng");
            fromLat = jsonObject.optString("lat");
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"\u89e3\u6790content\u9519\u8bef, %s", (Object[])new Object[]{msgSection.getContent()});
            return "";
        }
        UserInfoKS myInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        String tude1 = myInfo.locationTude;
        MLog.info((Object)TAG, (String)"getDistance myTude:%s, fromLat:%s, fromLng:%s, fromuid:%s, ", (Object[])new Object[]{tude1, fromLat, fromLng, fromInfo.uid});
        if (FP.empty((CharSequence)fromLat) || FP.empty((CharSequence)fromLng)) {
            return "";
        }
        String[] locationArr1 = null;
        if (!FP.empty((CharSequence)tude1)) {
            locationArr1 = tude1.split("_");
        }
        if (locationArr1 != null && locationArr1.length == 2) {
            try {
                double lgd1 = Double.valueOf(locationArr1[0]);
                double lat1 = Double.valueOf(locationArr1[1]);
                double lgd2 = Double.valueOf(fromLng);
                double lat2 = Double.valueOf(fromLat);
                double distance = LocationUtils.getDistance((double)lat1, (double)lgd1, (double)lat2, (double)lgd2);
                return DistanceParser.parseString((long)((long)(distance * 1000.0)));
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    @KvoMethodAnnotation(name="showActivity", sourceClass=MedalConfig.class, thread=1)
    protected void onShowActivityConfig(KvoEventIntent event) {
        this.onNickChange();
    }

    @KvoMethodAnnotation(name="showGrade", sourceClass=MedalConfig.class, thread=1)
    protected void onShowGradeConfig(KvoEventIntent event) {
        this.onNickChange();
    }

    public View getAvatar() {
        return this.ivAvatar;
    }

    public FlowLayout getFlowLayout() {
        return this.mFlowLayout;
    }

    public void setSingleLine(boolean isSingleLine) {
        this.isSingleLine = isSingleLine;
        if (isSingleLine) {
            this.space.setVisibility(8);
            if (this.mFlowLayout.indexOfChild((View)this.ivAvatar) != 0) {
                this.removeFromParent((View)this.ivAvatar);
                this.mFlowLayout.addView((View)this.ivAvatar, 0);
            }
        } else {
            this.space.setVisibility(0);
            if (this.indexOfChild((View)this.ivAvatar) < 0) {
                this.removeFromParent((View)this.ivAvatar);
                this.addView((View)this.ivAvatar, 0);
            }
        }
    }

    private void removeFromParent(View view) {
        if (view.getParent() instanceof ViewGroup) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.onMeasuredListener != null) {
            this.onMeasuredListener.afterMeasured(w, h);
        }
    }

    public void setOnMeasuredListener(IOnMeasuredListener onMeasuredListener) {
        this.onMeasuredListener = onMeasuredListener;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.happenDettach && this.baseImMsg != null && this.baseImMsg.getUserTagInfos() != null) {
            this.baseImMsg.getUserTagInfos().observeForever(this.simpleCardObserver);
        }
        this.happenDettach = false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.happenDettach = true;
        if (this.baseImMsg != null && this.baseImMsg.getUserTagInfos() != null) {
            this.baseImMsg.getUserTagInfos().removeObserver(this.simpleCardObserver);
        }
    }

    protected int getIconSize() {
        return DpToPxDef.RESOLUTION_18_DP;
    }

    public static interface IOnMeasuredListener {
        public void afterMeasured(int var1, int var2);
    }
}

