/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import biz.IMMsgItem;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.span.ChainSpan;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.ChannelRobotInfo;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.PublicScreenThemeUtil;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import java.util.List;
import org.json.JSONObject;

public class PureMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "PureMsgTransform";

    public PureTextMsg transform(String msgId, IMMsgItem msgItem) {
        PureTextMsg baseImMsg = new PureTextMsg(super.transform(msgId, msgItem));
        PureMsgTransform.transformText(baseImMsg);
        return baseImMsg;
    }

    public static void transformText(final PureTextMsg baseImMsg) {
        List sectionList = baseImMsg.getSections();
        if (sectionList != null && !sectionList.isEmpty()) {
            ChainSpan chainSpan = ChainSpan.of();
            String content = "";
            try {
                for (MsgSection section : sectionList) {
                    JSONObject jsonObject;
                    content = section.getContent();
                    if (section.getType() == 1) {
                        chainSpan.append((CharSequence)EmojiManager.INSTANCE.getExpressionString(content));
                        baseImMsg.setExtend(section.getExtention());
                        continue;
                    }
                    if (section.getType() == 2005) {
                        jsonObject = JsonParser.obtainJSONObject((String)content);
                        String nick = jsonObject.optString("nick");
                        final long uid = jsonObject.optLong("uid");
                        String tempContent = "@" + nick + " ";
                        if (uid == AccountUtil.getUid()) {
                            baseImMsg.setAtMeMsg(true);
                        }
                        if (!TextUtils.isEmpty((CharSequence)jsonObject.optString("robotId", ""))) {
                            baseImMsg.setRobotMsgType(2);
                            ChannelRobotInfo channelRobotInfo = new ChannelRobotInfo();
                            channelRobotInfo.instanceId = jsonObject.optString("robotId", "");
                            baseImMsg.setChannelRobotInfo(channelRobotInfo);
                        }
                        chainSpan.beginBlock().append((CharSequence)tempContent, new Object[]{new ForegroundColorSpan(PublicScreenThemeUtil.INSTANCE.getAtTextLightColor())}).onBlockClick(new Runnable(){

                            @Override
                            public void run() {
                                if (baseImMsg.getIFuncBridge() != null) {
                                    baseImMsg.getIFuncBridge().onNickClick(uid, (BaseImMsg)baseImMsg);
                                }
                            }
                        }).endBlock();
                        continue;
                    }
                    if (section.getType() != 1004) continue;
                    jsonObject = JsonParser.obtainJSONObject((String)content);
                    String notice = jsonObject.optString("bulletin");
                    Spanned htmlText = StringUtils.getHtmlText((int)R.string.tips_notice, (Object[])new Object[]{notice});
                    chainSpan.append((CharSequence)htmlText);
                    baseImMsg.setSessionTips((CharSequence)ResourceUtils.getString((int)R.string.title_session_group_notice, (Object[])new Object[]{notice}));
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"on parse error!!!content:%s", (Object[])new Object[]{content});
            }
            chainSpan.onFinish((Callback)new Callback<Spannable>(){

                public void onResponse(Spannable data) {
                    baseImMsg.setMsgText((CharSequence)data);
                }
            });
            chainSpan.build();
        }
    }

    private void transformContent(String msgId, PureTextMsg msg) {
        PureMsgTransform.transformText(msg);
    }

    public PureTextMsg transform(String msgId, BaseImMsg msgItem) {
        PureTextMsg msg = new PureTextMsg(msgItem);
        this.transformContent(msgId, msg);
        return msg;
    }
}

