/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import biz.IMMsgItem;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteCancelMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class GameInviteCancelMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "GameInviteCancelMsgTran";

    public GameInviteCancelMsg transform(String msgId, IMMsgItem msgItem) {
        GameInviteCancelMsg msg = new GameInviteCancelMsg(super.transform(msgId, msgItem));
        this.transformContent(msg);
        return msg;
    }

    private void transformContent(GameInviteCancelMsg msgItem) {
        MsgSection section;
        List sections = msgItem.getSections();
        if (sections != null && !sections.isEmpty() && (section = (MsgSection)sections.get(0)) != null) {
            String content = section.getContent();
            MLog.info((Object)TAG, (String)"invite cancel msg content:%s", (Object[])new Object[]{content});
            if (StringUtils.isNotEmpty((String)content)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                    String pkId = jsonObject.optString("invite_id");
                    int cancelType = jsonObject.optInt("type", 0);
                    msgItem.setCancelType(cancelType);
                    msgItem.setPkId(pkId);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    MLog.error((Object)TAG, (String)"invite cancel msg parse error!!!content:%s", (Object[])new Object[]{content});
                }
            }
        }
    }

    public GameInviteCancelMsg transform(String msgId, BaseImMsg msgItem) {
        GameInviteCancelMsg msg = new GameInviteCancelMsg(msgItem);
        this.transformContent(msg);
        return msg;
    }
}

