/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.graphics.drawable.Drawable;
import android.os.Message;
import android.view.View;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.msg.JoinChannelInviteMsg;
import com.yy.hiyo.component.publicscreen.theme.IThemeView;
import com.yy.hiyo.component.publicscreen.theme.ThemePackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InviteJoinChannelHolder
extends AbsMsgTitleBarHolder<JoinChannelInviteMsg> {
    private static final String TAG = "InviteJoinChannelHolder";
    private YYTextView tvRefuse;
    private YYTextView tvJoin;
    private YYTextView tvResult;
    private YYTextView tvText;

    public InviteJoinChannelHolder(@NotNull View v) {
        super(v, false);
        this.tvRefuse = (YYTextView)this.itemView.findViewById(R.id.tv_c_refuse);
        this.tvJoin = (YYTextView)this.itemView.findViewById(R.id.tv_c_join);
        this.tvResult = (YYTextView)this.itemView.findViewById(R.id.tv_c_result);
        final View contentView = this.itemView.findViewById(R.id.content_view);
        this.tvResult.setVisibility(8);
        this.tvText = (YYTextView)this.itemView.findViewById(R.id.tv_c_text);
        this.tvRefuse.setOnClickListener(v1 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.CLICK_REFUSE_JOIN_CHANNEL;
                msg.obj = this.getItemMsg();
                this.mActionHandler.onAction(msg);
            }
        });
        this.tvJoin.setOnClickListener(v12 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.CLICK_AGREE_JOIN_CHANNEL;
                msg.obj = this.getItemMsg();
                this.mActionHandler.onAction(msg);
            }
        });
        ((IThemeView)this.tvText).setThemeInterceptor(new IThemeView.Interceptor(){

            @Override
            public boolean intercept(@Nullable ThemePackage themePackage) {
                if (InviteJoinChannelHolder.this.mChannelMode == 1) {
                    Drawable drawable2;
                    int contentColor = themePackage.getContentColorResId();
                    if (contentColor != 0) {
                        InviteJoinChannelHolder.this.tvText.setTextColor(ResourceUtils.getColor((int)contentColor));
                    }
                    if (contentView != null && (drawable2 = themePackage.getBackgroundDrawable()) != null) {
                        contentView.setBackground(drawable2);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void bindView(@NotNull JoinChannelInviteMsg newData, int position) {
        super.bindView(newData, position);
        this.mBinder.singleBindSourceTo("msg", (KvoSource)newData);
        if (StringUtils.isNotEmpty((String)newData.getSetId())) {
            this.tvText.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_join_channel));
        } else {
            this.tvText.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_apply_join));
        }
    }

    @KvoMethodAnnotation(name="clickState", sourceClass=JoinChannelInviteMsg.class, thread=1)
    public void onJoinState(KvoEventIntent event) {
        JoinChannelInviteMsg itemMsg = (JoinChannelInviteMsg)((Object)this.getItemMsg());
        if (itemMsg != null) {
            MLog.info((Object)TAG, (String)"onJoinState : %d", (Object[])new Object[]{itemMsg.getClickState()});
            if (itemMsg.getClickState() == 0) {
                this.tvResult.setVisibility(8);
                this.tvRefuse.setVisibility(0);
                this.tvJoin.setVisibility(0);
                this.tvRefuse.setEnabled(true);
                this.tvJoin.setEnabled(true);
                if (StringUtils.isNotEmpty((String)itemMsg.getSetId())) {
                    this.tvJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.im_push_join));
                } else {
                    this.tvJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_notice_status_agree));
                }
            } else if (itemMsg.getClickState() == 1) {
                this.tvResult.setVisibility(8);
                this.tvRefuse.setVisibility(0);
                this.tvJoin.setVisibility(0);
                this.tvRefuse.setEnabled(false);
                this.tvJoin.setEnabled(false);
            } else {
                this.tvResult.setVisibility(0);
                this.tvRefuse.setVisibility(8);
                this.tvJoin.setVisibility(8);
                this.tvRefuse.setEnabled(false);
                this.tvJoin.setEnabled(false);
                this.tvResult.setText((CharSequence)ResourceUtils.getString((int)(itemMsg.getClickState() == 2 ? R.string.btn_refused : (itemMsg.getClickState() == 3 ? R.string.btn_agreed : R.string.btn_invalid))));
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mBinder.clearAllKvoConnections();
    }
}

