/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yy.appbase.data.ViewDimension;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.ImageMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import org.jetbrains.annotations.NotNull;

public final class ImageHolder
extends AbsMsgTitleBarHolder<ImageMsg> {
    private RecycleImageView ivImage;
    private RecycleImageView ivLogo;
    private View[] mViews = new View[2];

    public ImageHolder(@NotNull View v, boolean self) {
        super(v, self);
        this.ivImage = (RecycleImageView)this.itemView.findViewById(R.id.iv_c_img);
        this.ivLogo = (RecycleImageView)this.itemView.findViewById(R.id.iv_logo);
        this.mViews[0] = this.itemView;
        this.mViews[1] = this.ivImage;
        this.ivImage.setOnClickListener(v1 -> {
            ImageMsg imageMsg = (ImageMsg)this.getItemMsg();
            if (imageMsg == null) {
                return;
            }
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.CLICK_IMAGE;
                Bundle bundle = new Bundle();
                bundle.putParcelable("view_dimension", (Parcelable)new ViewDimension(v1));
                bundle.putString("localPath", imageMsg.getLocalPath());
                bundle.putString("imageUrl", imageMsg.getImageUrl());
                bundle.putString("msgId", imageMsg.getMsgId());
                msg.obj = bundle;
                this.mActionHandler.onAction(msg);
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "hago_share_link_click").put("share_content_type", "1"));
        });
    }

    @KvoMethodAnnotation(name="dataChange", sourceClass=ImageMsg.class, thread=1)
    public final void onDataChange(@NotNull KvoEventIntent event) {
        ImageMsg msg = (ImageMsg)this.getItemMsg();
        if (msg != null && this.ivImage != null) {
            this.updateSize(msg);
            if (StringUtils.isNotEmpty((String)msg.getLocalPath())) {
                ImageLoader.loadImage((ImageView)this.ivImage, (String)msg.getLocalPath(), (int)R.drawable.icon_img1_default);
                return;
            }
            String url = null;
            url = StringUtils.isNotEmpty((String)msg.getNanoUrl()) ? msg.getNanoUrl() : msg.getImageUrl();
            if (StringUtils.isNotEmpty((String)url) && !ImageUtil.isGif((String)url)) {
                url = url + YYImageUtils.getThumbnailPostfix((int)75);
            }
            ImageLoader.loadImage((ImageView)this.ivImage, (String)url, (int)R.drawable.icon_img1_default);
        }
    }

    @Override
    public void bindView(@NotNull ImageMsg newData, int position) {
        super.bindView(newData, position);
        this.ivLogo.setVisibility(newData.getUrlFrom() == 1 ? 0 : 8);
        if (newData.isShareImage()) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "hago_share_link_show").put("share_content_type", "1"));
        }
    }

    private final void updateSize(ImageMsg msg) {
        ViewGroup.LayoutParams lp;
        ViewGroup.LayoutParams layoutParams = lp = this.ivImage != null ? this.ivImage.getLayoutParams() : null;
        if (lp != null) {
            int high;
            int width = msg.getWidth();
            float aspectRatio = (float)width / (float)(high = msg.getHigh());
            if (aspectRatio >= 1.77f) {
                float scale = (float)ChannelDefine.MAX_PIC_SIZE / (float)width;
                high = (int)((float)high * scale);
                width = ChannelDefine.MAX_PIC_SIZE;
            } else if (aspectRatio <= 0.56f) {
                float scale = (float)ChannelDefine.MAX_PIC_SIZE / (float)high;
                width = (int)((float)width * scale);
                high = ChannelDefine.MAX_PIC_SIZE;
            } else if (aspectRatio <= 1.33f && aspectRatio >= 0.75f) {
                high = ChannelDefine.DEFAULT_PIC_SIZE;
                width = ChannelDefine.DEFAULT_PIC_SIZE;
            } else if (aspectRatio > 0.56f && aspectRatio < 1.77f) {
                width = (int)((float)ResolutionUtils.dip2Px((float)width) * msg.getScale());
                high = (int)((float)ResolutionUtils.dip2Px((float)high) * msg.getScale());
            } else {
                high = ChannelDefine.DEFAULT_PIC_SIZE;
                width = ChannelDefine.DEFAULT_PIC_SIZE;
            }
            lp.width = width;
            lp.height = high;
        }
    }

    @KvoMethodAnnotation(name="localPath", sourceClass=ImageMsg.class, thread=1)
    public final void onLocalPath(@NotNull KvoEventIntent event) {
        ImageMsg msg = (ImageMsg)this.getItemMsg();
        if (this.ivImage != null && msg != null && StringUtils.isNotEmpty((String)msg.getLocalPath())) {
            this.updateSize(msg);
            ImageLoader.loadImage((ImageView)this.ivImage, (String)msg.getLocalPath());
        }
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mBinder.clearAllKvoConnections();
    }
}

