/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.os.Message;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.MovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.utils.CrashCatchLinkMovementMethod;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameAcceptMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.theme.themeview.YYThemeTextView;

public class GameAcceptViewHolder
extends AbsMsgItemHolder<GameAcceptMsg> {
    private RecycleImageView ivAvatar;
    private RecycleImageView ivGame;
    private RecycleImageView ivGift;
    private YYImageView rubyImg;
    private YYThemeTextView tvCount;
    private YYThemeTextView tvTips;
    private YYTextView tvAccept;
    private View div;
    private final int confTypeProp = 0;

    public GameAcceptViewHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivAvatar = (RecycleImageView)itemView.findViewById(R.id.startChallengeAvatar);
        this.ivGame = (RecycleImageView)itemView.findViewById(R.id.gameIcon);
        this.ivGift = (RecycleImageView)itemView.findViewById(R.id.giftIcon);
        this.rubyImg = (YYImageView)itemView.findViewById(R.id.rubyIcon);
        this.ivAvatar = (RecycleImageView)itemView.findViewById(R.id.startChallengeAvatar);
        this.tvCount = (YYThemeTextView)itemView.findViewById(R.id.giftCount);
        this.tvTips = (YYThemeTextView)itemView.findViewById(R.id.startChallengeTip);
        this.tvTips.setMovementMethod((MovementMethod)CrashCatchLinkMovementMethod.getInstance());
        this.tvAccept = (YYTextView)itemView.findViewById(R.id.accept);
        this.div = itemView.findViewById(R.id.sp);
        this.ivAvatar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GameAcceptViewHolder.this.onAvatarClick();
            }
        });
        this.tvAccept.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GameAcceptViewHolder.this.mActionHandler != null) {
                    Message message = Message.obtain();
                    message.what = ActionDefine.ON_GAME_ACCEPT_CLICK;
                    message.obj = GameAcceptViewHolder.this.getItemMsg();
                    GameAcceptViewHolder.this.mActionHandler.onAction(message);
                }
            }
        });
    }

    @Override
    public void bindView(GameAcceptMsg newData, int position) {
        super.bindView(newData, position);
        ImageLoader.loadImage((ImageView)this.ivAvatar, (String)(newData.getAvatarUrl() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.profile_default_header);
        ImageLoader.loadImage((ImageView)this.ivGame, (String)(newData.getGameIcon() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.profile_default_header);
        if (newData.getConfigType() == 0) {
            ImageLoader.loadImage((ImageView)this.ivGift, (String)(newData.getGiftIcon() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.profile_default_header);
            this.ivGift.setVisibility(0);
            this.rubyImg.setVisibility(8);
        } else {
            this.ivGift.setVisibility(8);
            this.rubyImg.setVisibility(0);
        }
        this.tvCount.setText("x " + newData.getGiftCount());
        this.tvTips.setText(this.getText(newData));
        this.mBinder.singleBindSourceTo("msg", (KvoSource)newData);
        if (this.div != null && this.mThemeRes != null) {
            this.div.setVisibility(this.mThemeRes.getCurrentMode() == 1 ? 0 : 4);
        }
    }

    private CharSequence getText(GameAcceptMsg data) {
        String content = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.short_tips_mora_public_screen), (Object[])new Object[]{data.getNick(), data.getGameName().toUpperCase()});
        SpannableString spannableString = new SpannableString((CharSequence)content);
        int launcherNameIndex = content.indexOf(data.getNick());
        if (launcherNameIndex != -1) {
            spannableString.setSpan((Object)TextSpan.of().color(ResourceUtils.getColor((int)this.mThemeRes.getThemePackage("msg_nick").getContentColorResId())).build(), launcherNameIndex, launcherNameIndex + data.getNick().length(), 34);
            spannableString.setSpan((Object)new ClickableSpan(){

                public void onClick(@NonNull View widget) {
                    GameAcceptViewHolder.this.onAvatarClick();
                }

                public void updateDrawState(@NonNull TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setUnderlineText(false);
                }
            }, launcherNameIndex, launcherNameIndex + data.getNick().length(), 17);
        }
        return spannableString;
    }

    @KvoMethodAnnotation(name="accepted", sourceClass=GameAcceptMsg.class, thread=1)
    public void onTextEvent(KvoEventIntent event) {
        if (((GameAcceptMsg)this.getItemMsg()).getAccepted()) {
            this.tvAccept.setEnabled(false);
            this.tvAccept.setBackgroundResource(R.drawable.shape_chat_mora_pk_gray);
        } else {
            this.tvAccept.setEnabled(true);
            this.tvAccept.setBackgroundResource(R.drawable.shape_chat_mora_pk);
        }
    }

    private void onAvatarClick() {
        if (this.mActionHandler != null) {
            Message msg = Message.obtain();
            msg.what = ActionDefine.SHOW_USER_PROFILE;
            msg.obj = ((GameAcceptMsg)this.getItemMsg()).getStarterUid();
            this.mActionHandler.onAction(msg);
        }
    }
}

