/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.helper;

import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.msg.JoinChannelState;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import com.yy.hiyo.component.publicscreen.theme.themeview.YYThemeTextView;

public class JoinChannelStateHelper {
    private static final String TAG = "JoinChannelStateHelper";
    private JoinChannelState mLastState;
    private IThemeRes mThemeRes;
    private YYThemeTextView tvJoin;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public JoinChannelStateHelper(YYThemeTextView tvJoin) {
        this.tvJoin = tvJoin;
    }

    public void bindState(IThemeRes themeRes, JoinChannelState state) {
        this.mThemeRes = themeRes;
        if (this.mLastState != null && this.mLastState != state) {
            this.mBinder.clearAllKvoConnections();
            this.mLastState = null;
        }
        if (state != null) {
            this.mLastState = state;
            this.mBinder.singleBindSourceTo((KvoSource)state);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=JoinChannelState.class, thread=1)
    public void onJoinState(KvoEventIntent event) {
        JoinChannelState itemMsg = this.mLastState;
        if (itemMsg != null && this.tvJoin != null && this.mThemeRes != null) {
            int state = itemMsg.getState();
            MLog.info((Object)TAG, (String)"onJoinState : %d", (Object[])new Object[]{state});
            if (state == 0) {
                this.tvJoin.setEnabled(true);
                this.tvJoin.setText(ResourceUtils.getString((int)R.string.im_push_join));
                this.tvJoin.onThemeUpdate(this.mThemeRes.getThemePackage("msg_btn_join_channel"));
            } else if (state == 1) {
                this.tvJoin.setEnabled(false);
                this.tvJoin.setText(ResourceUtils.getString((int)R.string.im_push_join));
                this.tvJoin.onThemeUpdate(this.mThemeRes.getThemePackage("msg_btn_join_channel"));
            } else if (state == 2) {
                this.tvJoin.setEnabled(false);
                this.tvJoin.setText(ResourceUtils.getString((int)R.string.btn_refused));
                this.tvJoin.onThemeUpdate(this.mThemeRes.getThemePackage("msg_btn_join_refuse"));
            } else if (state == 3) {
                this.tvJoin.setEnabled(false);
                this.tvJoin.setText(ResourceUtils.getString((int)R.string.title_channel_has_joined));
                this.tvJoin.onThemeUpdate(this.mThemeRes.getThemePackage("msg_btn_join_refuse"));
            } else if (state == 6) {
                this.tvJoin.setEnabled(false);
                this.tvJoin.setText(ResourceUtils.getString((int)R.string.btn_sended));
                this.tvJoin.onThemeUpdate(this.mThemeRes.getThemePackage("msg_btn_join_refuse"));
            }
        }
    }
}

