/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto.thirdnotify;

import com.squareup.wire.AndroidMessage;
import com.squareup.wire.ProtoAdapter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.notify.NotifyData;
import com.yy.hiyo.proto.thirdnotify.IThirdNotify;
import com.yy.hiyo.proto.thirdnotify.ThirdNotifyListener;
import com.yy.hiyo.proto.thirdnotify.ThirdNotifyUri;
import ikxd.cproxy.InnerV2;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.ihago.ymicro.srv.ypush.CommonNotice;
import net.ihago.ymicro.srv.ypush.PayloadType;

public class ThirdNotifyDispatch {
    private static final String TAG = "ThirdNotifyDispatch";
    private final ConcurrentHashMap<ThirdNotifyUri.Uri, List<ThirdNotifyListener>> mNotify = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerThirdNotify(Class<T> type, IThirdNotify<T> notify) {
        if (type == null || notify == null) {
            return;
        }
        ConcurrentHashMap<ThirdNotifyUri.Uri, List<ThirdNotifyListener>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            ThirdNotifyUri.Uri uri = notify.uri();
            if (uri == null) {
                MLog.error((Object)TAG, (String)"registerThirdNotify uri is null", (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    throw new IllegalArgumentException("registerThirdNotify uri can not be null");
                }
                return;
            }
            ThirdNotifyListener<T> listener = new ThirdNotifyListener<T>(type, notify);
            List<ThirdNotifyListener> watchers = this.mNotify.get(uri);
            if (watchers == null) {
                watchers = new ArrayList<ThirdNotifyListener>();
                this.mNotify.put(uri, watchers);
            }
            if (watchers.contains(listener)) {
                return;
            }
            watchers.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterThirdNotify(IThirdNotify<T> notify) {
        if (notify == null || notify.uri() == null) {
            return;
        }
        ConcurrentHashMap<ThirdNotifyUri.Uri, List<ThirdNotifyListener>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            ThirdNotifyUri.Uri uri = notify.uri();
            ThirdNotifyListener<T> listener = new ThirdNotifyListener<T>(notify);
            List<ThirdNotifyListener> watchers = this.mNotify.get(uri);
            if (watchers == null || watchers.size() == 0) {
                return;
            }
            watchers.remove(listener);
        }
    }

    public void notify(InnerV2 inner, byte[] payload) {
        CommonNotice notice = this.getCommonNotice(inner, payload);
        if (notice != null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"notify (%s), bytes: %s", (Object[])new Object[]{ProtoUtils.innerString(inner), StringUtils.byteToStringUtf8((byte[])payload)});
            }
            this.handleNotice(inner, notice);
        }
    }

    public CommonNotice getCommonNotice(InnerV2 inner, byte[] payload) {
        if (payload == null) {
            return null;
        }
        CommonNotice notice = ProtoUtils.parseBytes(CommonNotice.ADAPTER, payload);
        if (notice == null) {
            MLog.error((Object)TAG, (String)"third notice is illegal, inner", (Object[])new Object[]{ProtoUtils.innerString(inner)});
            return null;
        }
        return notice;
    }

    public void notify(List<NotifyData> notifys) {
        if (notifys == null || notifys.size() <= 0) {
            return;
        }
        final ArrayList<CommonNoticeEx> notices = new ArrayList<CommonNoticeEx>(notifys.size());
        for (NotifyData data : notifys) {
            if (data == null) continue;
            notices.add(this.parseData(data));
        }
        if (notices.size() <= 0) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                for (CommonNoticeEx notice : notices) {
                    if (notice == null || notice.listeners == null || notice.listeners.size() <= 0) continue;
                    if (!MLog.isLogLevelAboveDebug() && SystemUtils.isShowEnvSetting()) {
                        MLog.debug((Object)ThirdNotifyDispatch.TAG, (String)"notifyList item (%s), bytes: %s", (Object[])new Object[]{ProtoUtils.innerString(notice.notifyOriginData.innerV2()), StringUtils.byteToStringUtf8((byte[])notice.notifyOriginData.payload())});
                    }
                    for (ThirdNotifyListener listener : notice.listeners) {
                        if (listener == null || listener.notify == null) continue;
                        if (byte[].class.isInstance(listener.type)) {
                            ThirdNotifyDispatch.this.notifySafe(listener.notify, notice.noticePayload);
                            continue;
                        }
                        if (notice.parsedObject == null) continue;
                        ThirdNotifyDispatch.this.notifySafe(listener.notify, notice.parsedObject);
                    }
                }
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonNoticeEx parseData(NotifyData data) {
        CommonNotice notice = this.getCommonNotice(data.innerV2(), data.payload());
        if (notice == null) {
            return null;
        }
        ThirdNotifyUri.Uri uri = new ThirdNotifyUri.Uri(notice.sname, notice.uri);
        CommonNoticeEx itemData = new CommonNoticeEx();
        itemData.notice = notice;
        itemData.notifyOriginData = data;
        itemData.noticePayload = notice.payload.toByteArray();
        ArrayList<ThirdNotifyListener> copys = null;
        ConcurrentHashMap<ThirdNotifyUri.Uri, List<ThirdNotifyListener>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            List<ThirdNotifyListener> list = this.mNotify.get(uri);
            if (FP.empty(list)) {
                return null;
            }
            copys = new ArrayList<ThirdNotifyListener>(list.size());
            copys.addAll(list);
            itemData.listeners = copys;
        }
        for (ThirdNotifyListener listener : copys) {
            if (listener == null || listener.type == null || byte[].class.isInstance(listener.type)) continue;
            if (notice.payloadtype == PayloadType.PAYLOAD_TYPE_PB) {
                ProtoAdapter proto;
                if (AndroidMessage.class.isInstance(listener.type) && (proto = ProtoUtils.getProtoAdapter(listener.type)) != null) {
                    itemData.parsedObject = ProtoUtils.parseBytes(proto, itemData.noticePayload);
                    break;
                }
                MLog.error((Object)TAG, (String)"handleNoticePb notify proto failed inner: %s", (Object[])new Object[]{ProtoUtils.innerString(data.innerV2())});
                continue;
            }
            if (notice.payloadtype == PayloadType.PAYLOAD_TYPE_JSON) {
                String str = StringUtils.byteToStringUtf8((byte[])itemData.noticePayload);
                try {
                    itemData.parsedObject = JsonParser.parseJsonObject((String)str, listener.type);
                    break;
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                    if (SystemUtils.isShowEnvSetting()) {
                        throw e;
                    }
                    MLog.error((Object)TAG, (String)"handleNoticeJson notify proto failed inner: %s", (Object[])new Object[]{ProtoUtils.innerString(data.innerV2())});
                    continue;
                }
            }
            String error = StringUtils.formatWitUSLocal((String)"handleNoticeOther can not parse other type: %s, inner: %s", (Object[])new Object[]{notice.payloadtype, ProtoUtils.innerString(data.innerV2())});
            MLog.error((Object)TAG, (String)error, (Object[])new Object[0]);
        }
        return itemData;
    }

    private void handleNotice(InnerV2 inner, CommonNotice notice) {
        ThirdNotifyUri.Uri uri = new ThirdNotifyUri.Uri(notice.sname, notice.uri);
        List<ThirdNotifyListener> list = this.mNotify.get(uri);
        if (FP.empty(list)) {
            return;
        }
        MLog.info((Object)TAG, (String)"handleNotice payloadType: %s", (Object[])new Object[]{notice.payloadtype});
        if (notice.payloadtype == PayloadType.PAYLOAD_TYPE_PB) {
            this.handleNoticePb(inner, list, notice);
        } else if (notice.payloadtype == PayloadType.PAYLOAD_TYPE_JSON) {
            this.handleNoticeJson(inner, list, notice);
        } else {
            this.handleNoticeOther(inner, list, notice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNoticePb(InnerV2 inner, List<ThirdNotifyListener> list, CommonNotice notice) {
        ArrayList<ThirdNotifyListener> copys = new ArrayList<ThirdNotifyListener>();
        ConcurrentHashMap<ThirdNotifyUri.Uri, List<ThirdNotifyListener>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            copys.addAll(list);
        }
        Object msg = null;
        byte[] bytes = notice.payload.toByteArray();
        for (ThirdNotifyListener listener : copys) {
            ProtoAdapter proto;
            if (listener == null || listener.type == null) continue;
            if (byte[].class.isInstance(listener.type)) {
                this.notifyOnUi(listener.notify, bytes);
                continue;
            }
            if (msg == null && AndroidMessage.class.isInstance(listener.type) && (proto = ProtoUtils.getProtoAdapter(listener.type)) != null) {
                msg = ProtoUtils.parseBytes(proto, bytes);
            }
            if (msg != null) {
                this.notifyOnUi(listener.notify, msg);
                continue;
            }
            MLog.error((Object)TAG, (String)"handleNoticePb notify proto failed inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNoticeJson(InnerV2 inner, List<ThirdNotifyListener> list, CommonNotice notice) {
        ArrayList<ThirdNotifyListener> copys = new ArrayList<ThirdNotifyListener>();
        ConcurrentHashMap<ThirdNotifyUri.Uri, List<ThirdNotifyListener>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            copys.addAll(list);
        }
        Object msg = null;
        byte[] bytes = notice.payload.toByteArray();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"handleNoticeJson (%s), bytes: %s", (Object[])new Object[]{ProtoUtils.innerString(inner), new String(bytes)});
        }
        for (ThirdNotifyListener listener : copys) {
            block10: {
                if (listener == null || listener.type == null) continue;
                if (byte[].class.isInstance(listener.type)) {
                    this.notifyOnUi(listener.notify, bytes);
                    continue;
                }
                if (msg == null) {
                    String data = StringUtils.byteToStringUtf8((byte[])bytes);
                    try {
                        msg = JsonParser.parseJsonObject((String)data, listener.type);
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, (Throwable)e);
                        if (!RuntimeContext.sIsDebuggable) break block10;
                        throw e;
                    }
                }
            }
            if (msg != null) {
                this.notifyOnUi(listener.notify, msg);
                continue;
            }
            MLog.error((Object)TAG, (String)"handleNoticeJson notify proto failed inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNoticeOther(InnerV2 inner, List<ThirdNotifyListener> list, CommonNotice notice) {
        ArrayList<ThirdNotifyListener> copys = new ArrayList<ThirdNotifyListener>();
        ConcurrentHashMap<ThirdNotifyUri.Uri, List<ThirdNotifyListener>> concurrentHashMap = this.mNotify;
        synchronized (concurrentHashMap) {
            copys.addAll(list);
        }
        Object msg = null;
        byte[] bytes = notice.payload.toByteArray();
        for (ThirdNotifyListener listener : copys) {
            if (listener == null || listener.type == null) continue;
            if (byte[].class.isInstance(listener.type)) {
                this.notifyOnUi(listener.notify, bytes);
                continue;
            }
            String error = StringUtils.formatWitUSLocal((String)"handleNoticeOther can not parse other type: %s, inner: %s", (Object[])new Object[]{notice.payloadtype, ProtoUtils.innerString(inner)});
            MLog.error((Object)TAG, (String)error, (Object[])new Object[0]);
        }
    }

    private void notifyOnUi(final IThirdNotify notify, final Object msg) {
        if (notify == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.notifySafe(notify, msg);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThirdNotifyDispatch.this.notifySafe(notify, msg);
                }
            });
        }
    }

    private void notifySafe(IThirdNotify notify, Object msg) {
        if (RuntimeContext.sIsDebuggable) {
            notify.onNotify(msg);
        } else {
            try {
                notify.onNotify(msg);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    private static class CommonNoticeEx {
        NotifyData notifyOriginData;
        CommonNotice notice;
        byte[] noticePayload;
        Object parsedObject;
        List<ThirdNotifyListener> listeners;

        private CommonNoticeEx() {
        }
    }
}

