/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto.preventduplicater;

import android.content.Context;
import android.os.SystemClock;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.ISocketStateChangeListener;
import com.yy.hiyo.proto.preventduplicater.BaseProtoPreventDuplicater;
import com.yy.hiyo.proto.preventduplicater.ProtoHttpRequestPreventDuplicater;
import com.yy.hiyo.proto.preventduplicater.ProtoRpcRequestPreventDuplicater;
import java.util.HashMap;
import java.util.Set;

public class ProtoPreventDuplicateSender {
    private static final String TAG = "ProtoPreventDuplicateSender";
    private static INotify registerNotify;
    private static HashMap<Class, BaseProtoPreventDuplicater> sDuplicaterHashMap;
    private static ISocketStateChangeListener sSocketStateChangeListener;
    private static BaseProtoPreventDuplicater.IProtoPreventDuplicaterCallback sCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseProtoPreventDuplicater getRpcSender(Class theClass) {
        ProtoRpcRequestPreventDuplicater preventDuplicater = null;
        HashMap<Class, BaseProtoPreventDuplicater> hashMap = sDuplicaterHashMap;
        synchronized (hashMap) {
            preventDuplicater = sDuplicaterHashMap.get(theClass);
        }
        if (preventDuplicater == null) {
            preventDuplicater = new ProtoRpcRequestPreventDuplicater(sCallback);
            hashMap = sDuplicaterHashMap;
            synchronized (hashMap) {
                sDuplicaterHashMap.put(theClass, preventDuplicater);
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)TAG, (String)"add %s", (Object[])new Object[]{theClass});
                }
            }
        }
        return preventDuplicater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseProtoPreventDuplicater getHttpSender(Class theClass) {
        ProtoHttpRequestPreventDuplicater preventDuplicater = null;
        HashMap<Class, BaseProtoPreventDuplicater> hashMap = sDuplicaterHashMap;
        synchronized (hashMap) {
            preventDuplicater = sDuplicaterHashMap.get(theClass);
        }
        if (preventDuplicater == null) {
            preventDuplicater = new ProtoHttpRequestPreventDuplicater(sCallback);
            hashMap = sDuplicaterHashMap;
            synchronized (hashMap) {
                sDuplicaterHashMap.put(theClass, preventDuplicater);
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)TAG, (String)"add %s", (Object[])new Object[]{theClass});
                }
            }
        }
        return preventDuplicater;
    }

    public static void setCallback(BaseProtoPreventDuplicater.IProtoPreventDuplicaterCallback callback) {
        sCallback = callback;
    }

    public static void registerNotifys() {
        if (registerNotify == null) {
            registerNotify = new INotify(){

                public void notify(Notification notification) {
                    if (notification == null) {
                        return;
                    }
                    if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
                        if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                            ProtoPreventDuplicateSender.onNetConnected();
                        }
                    } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
                        ProtoPreventDuplicateSender.onLoginOut();
                    } else if (notification.id == NotificationDef.N_ON_TRIM_MEMORY) {
                        ProtoPreventDuplicateSender.onTrimMemory();
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, registerNotify);
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, registerNotify);
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, registerNotify);
                }
            });
            sSocketStateChangeListener = new ISocketStateChangeListener(){

                @Override
                public void onSocketStateChanged(int code, String wsUrl, String errorInfo) {
                    if (code == 102) {
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                HashMap hashMap = sDuplicaterHashMap;
                                synchronized (hashMap) {
                                    if (sDuplicaterHashMap.size() <= 0) {
                                        return;
                                    }
                                    Set keys = sDuplicaterHashMap.keySet();
                                    for (Class key : keys) {
                                        BaseProtoPreventDuplicater item = (BaseProtoPreventDuplicater)sDuplicaterHashMap.get(key);
                                        if (item == null) continue;
                                        item.onWsConnected();
                                    }
                                }
                            }
                        });
                    }
                }
            };
            ProtoManager.getInstance().addSocketStateChangeListener(sSocketStateChangeListener);
        }
    }

    protected static void onNetConnected() {
        MLog.info((Object)TAG, (String)"onNetConnected!", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = sDuplicaterHashMap;
                synchronized (hashMap) {
                    if (sDuplicaterHashMap.size() <= 0) {
                        return;
                    }
                    Set keys = sDuplicaterHashMap.keySet();
                    for (Class key : keys) {
                        BaseProtoPreventDuplicater item = (BaseProtoPreventDuplicater)sDuplicaterHashMap.get(key);
                        if (item == null) continue;
                        item.onNetConnected();
                    }
                }
            }
        });
    }

    protected static void onLoginOut() {
        MLog.info((Object)TAG, (String)"onLoginOut!", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = sDuplicaterHashMap;
                synchronized (hashMap) {
                    if (sDuplicaterHashMap.size() <= 0) {
                        return;
                    }
                    Set keys = sDuplicaterHashMap.keySet();
                    for (Class key : keys) {
                        BaseProtoPreventDuplicater item = (BaseProtoPreventDuplicater)sDuplicaterHashMap.get(key);
                        if (item == null) continue;
                        item.onLoginOut();
                    }
                }
            }
        });
    }

    protected static void onTrimMemory() {
        MLog.info((Object)TAG, (String)"onTrimMemory!", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = sDuplicaterHashMap;
                synchronized (hashMap) {
                    if (sDuplicaterHashMap.size() <= 0) {
                        return;
                    }
                    long curTime = SystemClock.uptimeMillis();
                    Set keys = sDuplicaterHashMap.keySet();
                    for (Class key : keys) {
                        BaseProtoPreventDuplicater item = (BaseProtoPreventDuplicater)sDuplicaterHashMap.get(key);
                        if (item == null) continue;
                        item.onTrimMemory(curTime);
                    }
                }
            }
        });
    }

    static {
        sDuplicaterHashMap = new HashMap(50);
    }
}

