/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto.metric;

public class MetricData {
    private static final int MAX_POOL_SIZE = 10;
    private static final Object sPoolSync = new Object();
    volatile boolean isRecycle = false;
    private MetricData next;
    private static MetricData sPool;
    private static int sPoolSize;
    public int contentLength;
    public int retryTimes;
    public int sendSize;
    public int wsQueueLength;
    public long startTime;
    public long networkRt;
    public long parseTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricData obtain() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null && sPoolSize > 0) {
                MetricData m = sPool;
                MetricData.clear(m);
                sPool = m.next;
                m.next = null;
                m.isRecycle = false;
                --sPoolSize;
                return m;
            }
        }
        return new MetricData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        MetricData.clear(this);
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 10) {
                this.next = sPool;
                sPool = this;
                ++sPoolSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clear(MetricData request) {
        Object object = sPoolSync;
        synchronized (object) {
            if (request == null) {
                return;
            }
            request.isRecycle = true;
            request.contentLength = -1;
            request.networkRt = -1L;
            request.parseTime = -1L;
            request.retryTimes = -1;
            request.sendSize = -1;
            request.wsQueueLength = -1;
            request.startTime = -1L;
        }
    }

    public static MetricData buildMetricData(long startTime, int contentLength, int sendSize, long networkRt, long parseTime, int wsQueueLength, int retryTimes) {
        MetricData metricData = MetricData.obtain();
        metricData.startTime = startTime;
        metricData.contentLength = contentLength;
        metricData.sendSize = sendSize;
        metricData.networkRt = networkRt;
        metricData.parseTime = parseTime;
        metricData.wsQueueLength = wsQueueLength;
        metricData.retryTimes = retryTimes;
        return metricData;
    }

    static {
        sPoolSize = 0;
    }
}

