/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import com.squareup.wire.AndroidMessage;
import com.squareup.wire.ProtoAdapter;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.Base64Utils;
import com.yy.base.utils.FP;
import com.yy.hiyo.proto.ProtoUtils;
import net.ihago.ktv.api.biz.GetRoomKaraokeInfoReq;
import net.ihago.room.srv.micup.GetBoardReq;
import net.ihago.room.srv.micup.GetResultsReq;
import net.ihago.room.srv.micup.GetRoundInfoReq;
import net.ihago.room.srv.micup.GetSongListReq;

public class WireEnumCheckHelper {
    public static <REQ extends AndroidMessage<REQ, ?>> void check(REQ req) {
        int size = WireEnumCheckHelper.getKeysSize(req);
        if (size > 0) {
            WireEnumCheckHelper.assertEnum(req, size);
        }
    }

    private static <REQ extends AndroidMessage<REQ, ?>> void assertEnum(final REQ req, final int size) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ProtoAdapter adapter = req.adapter();
                AndroidMessage back = null;
                byte[] payload = req.encode();
                if (adapter != null) {
                    back = (AndroidMessage)ProtoUtils.parseBytes(adapter, payload);
                }
                int backSize = WireEnumCheckHelper.getKeysSize(back);
                MLog.info((Object)"WireEnumCheckHelper", (String)"req: %s, payload.size: %d, size: %d, backSize: %d", (Object[])new Object[]{req.getClass().getName(), payload.length, size, backSize});
                if (size != backSize) {
                    MLog.error((Object)"WireEnumCheckHelper", (String)"bytes base64: %s", (Object[])new Object[]{Base64Utils.encodeToString((byte[])payload, (int)0)});
                    throw new IllegalStateException("wire enum encode error size: " + size + ", backSize: " + backSize);
                }
            }
        });
    }

    private static <REQ extends AndroidMessage<REQ, ?>> int getKeysSize(REQ req) {
        if (req instanceof GetRoomKaraokeInfoReq) {
            return FP.size(((GetRoomKaraokeInfoReq)req).keys);
        }
        if (req instanceof GetSongListReq) {
            return FP.size(((GetSongListReq)req).keys);
        }
        if (req instanceof GetRoundInfoReq) {
            return FP.size(((GetRoundInfoReq)req).keys);
        }
        if (req instanceof GetResultsReq) {
            return FP.size(((GetResultsReq)req).keys);
        }
        if (req instanceof GetBoardReq) {
            return FP.size(((GetBoardReq)req).keys);
        }
        return 0;
    }
}

