/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import com.squareup.wire.AndroidMessage;
import com.yy.base.okhttp.websocket.WsStatus;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.rpc.RpcMethod;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RpcRequestStrategy {
    public static final int MAX_TASK_COUNT = 3;
    private static volatile boolean sRpcHttpTokenInvalid = false;
    private static OnWsHttpDispatcherConfig sOnWsHttpDispatcherConfig;
    public static volatile AtomicInteger sCurWsTaskCount;

    public static void setRpcHttpTokenStatus(boolean isInvalid) {
        sRpcHttpTokenInvalid = isInvalid;
    }

    public static void setOnWsHttpPickConfig(OnWsHttpDispatcherConfig onWsHttpDispatcherConfig) {
        sOnWsHttpDispatcherConfig = onWsHttpDispatcherConfig;
    }

    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> RpcRequestStrategyType rpcRequestType(RpcMethod<REQ, RES> rpcMethod, boolean isWsRequest) {
        boolean enableWsHttpDispatcher = RpcRequestStrategy.enableWsHttpDispatcher();
        if (enableWsHttpDispatcher) {
            int maxTaskCount;
            RpcRequestStrategyType rpcRequestStrategyType;
            WsStatus wsStatus = ProtoManager.getInstance().getWsStatus();
            if (wsStatus != WsStatus.CONNECT_SUCCESS) {
                return RpcRequestStrategyType.HTTP;
            }
            if (sRpcHttpTokenInvalid) {
                return RpcRequestStrategyType.WEBSOCKET;
            }
            if (sOnWsHttpDispatcherConfig != null && (rpcRequestStrategyType = sOnWsHttpDispatcherConfig.getWsHttpConfigList().get(rpcMethod.methodName)) != null) {
                return rpcRequestStrategyType;
            }
            int n = maxTaskCount = sOnWsHttpDispatcherConfig != null ? sOnWsHttpDispatcherConfig.getWsMaxTaskCount() : 3;
            if (sCurWsTaskCount.get() <= maxTaskCount) {
                return RpcRequestStrategyType.WEBSOCKET;
            }
            return RpcRequestStrategyType.HTTP;
        }
        return isWsRequest || sRpcHttpTokenInvalid ? RpcRequestStrategyType.WEBSOCKET : RpcRequestStrategyType.HTTP;
    }

    public static boolean enableWsHttpDispatcher() {
        return sOnWsHttpDispatcherConfig != null && sOnWsHttpDispatcherConfig.enableWsHttpDispatcher();
    }

    public static String getCurABTestValue() {
        return sOnWsHttpDispatcherConfig != null ? sOnWsHttpDispatcherConfig.getABValue() : "";
    }

    static {
        sCurWsTaskCount = new AtomicInteger(0);
    }

    public static interface OnWsHttpDispatcherConfig {
        public Map<String, RpcRequestStrategyType> getWsHttpConfigList();

        public int getWsMaxTaskCount();

        public boolean enableWsHttpDispatcher();

        public String getABValue();
    }

    public static enum RpcRequestStrategyType {
        WEBSOCKET,
        HTTP;

    }
}

