/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.content.SharedPreferences;
import android.util.Base64;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.Base64Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okio.ByteString;

class RouteTransmission {
    private static final String TAG = "RouteTransmission";
    private static final String sRouteKey = "X-Routing-Key";
    private static final SharedPreferences mRouteSP = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, "routetransmission_sp", 0);

    RouteTransmission() {
    }

    static HashMap<String, String> routeTransMap(HashMap<String, String> map, String name) {
        String debugValue;
        String routeValue;
        if (map == null) {
            map = new HashMap();
        }
        String string = routeValue = StringUtils.isEmpty((String)(debugValue = RouteTransmission.debugRoutingKeyForVersionSwitch(name))) ? mRouteSP.getString(name, "") : debugValue;
        if (RouteTransmission.isDebugOrEnv()) {
            MLog.debug((Object)TAG, (String)("routeTransMap sName = " + name + "  routeValue = " + routeValue), (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)routeValue)) {
            try {
                routeValue = Base64.encodeToString((byte[])routeValue.getBytes(), (int)2);
                if (RouteTransmission.isDebugOrEnv()) {
                    MLog.debug((Object)TAG, (String)("routeTransMap sName = " + name + "  routeValue encode = " + routeValue), (Object[])new Object[0]);
                }
                map.put(sRouteKey, routeValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    static void proRequestHeader(String sName, Map<String, List<String>> responseHeader) {
        List<String> list;
        if (StringUtils.isNotEmpty((String)sName) && responseHeader != null && responseHeader.containsKey(sRouteKey) && (list = responseHeader.get(sRouteKey)).size() > 0) {
            String value = list.get(0);
            if (StringUtils.isNotEmpty((String)value)) {
                try {
                    if (RouteTransmission.isDebugOrEnv()) {
                        MLog.debug((Object)TAG, (String)("proRequestHeader sName = " + sName + "  routingKey value = " + value), (Object[])new Object[0]);
                    }
                    value = new String(Base64Utils.decode((String)value, (int)2));
                    if (RouteTransmission.isDebugOrEnv()) {
                        MLog.debug((Object)TAG, (String)("proRequestHeader sName = " + sName + "  routingKey decode value = " + value), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            mRouteSP.edit().putString(sName, value == null ? "" : value).apply();
        }
    }

    static ByteString getCproxyRoutingKey(String sName) {
        ByteString byteString;
        String debugValue = RouteTransmission.debugRoutingKeyForVersionSwitch(sName);
        String routingValue = StringUtils.isEmpty((String)debugValue) ? mRouteSP.getString(sName, "") : debugValue;
        ByteString byteString2 = byteString = StringUtils.isNotEmpty((String)routingValue) ? ByteString.encodeUtf8((String)routingValue) : null;
        if (RouteTransmission.isDebugOrEnv()) {
            MLog.debug((Object)TAG, (String)("getCproxyRoutingKey sName = " + sName + "  routingValue value = " + routingValue), (Object[])new Object[0]);
        }
        return byteString;
    }

    static void setCproxyRoutingKey(String sName, ByteString routingKey) {
        if (RouteTransmission.isDebugOrEnv()) {
            MLog.debug((Object)TAG, (String)("setCproxyRoutingKey sName = " + sName + "  routingKey value = " + (routingKey != null ? routingKey.utf8() : null)), (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)sName)) {
            String value = routingKey != null ? routingKey.utf8() : "";
            mRouteSP.edit().putString(sName, value == null ? "" : value).apply();
        }
    }

    private static String debugRoutingKeyForVersionSwitch(String sname) {
        String value = "";
        if (RouteTransmission.isDebugOrEnv()) {
            String snameFilter = SettingFlags.getStringValue((String)"key_sname_filter", (String)"all");
            if (RouteTransmission.isContainSname(sname, snameFilter)) {
                value = SettingFlags.getStringValue((String)"key_debug_switch_version", (String)"");
            }
            MLog.info((Object)TAG, (String)value, (Object[])new Object[0]);
        }
        return value;
    }

    private static boolean isDebugOrEnv() {
        return true;
    }

    private static boolean isContainSname(String sname, String snameFilter) {
        String[] snames;
        if ("all".equalsIgnoreCase(snameFilter)) {
            return true;
        }
        for (String s : snames = snameFilter.split("\\|")) {
            if (!s.equalsIgnoreCase(sname)) continue;
            return true;
        }
        return false;
    }
}

