/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.protobuf.GeneratedMessageLite;
import com.squareup.wire.AndroidMessage;
import com.squareup.wire.ProtoAdapter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.HomeRpcSet;
import com.yy.hiyo.proto.RouteTransmission;
import com.yy.hiyo.proto.WireEnumCheckHelper;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.rpc.RpcMethod;
import com.yy.hiyo.proto.rpc.RpcSet;
import common.Header;
import common.Response;
import common.Result;
import ikxd.cproxy.InnerV2;
import ikxd.cproxy.InnerV3;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okio.ByteString;

public final class ProtoUtils {
    public static final String X_YMICRO_API_SERVICE_NAME = "X-Ymicro-Api-Service-Name";
    public static final String X_YMICRO_API_METHOD_NAME = "X-Ymicro-Api-Method-Name";
    public static final String X_PCID = "X-Pcid";
    public static final String X_YMICRO_API_SERVICE_NAME_LOWER_CASE = "x-ymicro-api-service-name";
    public static final String X_YMICRO_API_METHOD_NAME_LOWER_CASE = "x-ymicro-api-method-name";
    private static final String TAG = "ProtoUtils";
    private static final Map<Class<? extends AndroidMessage>, ProtoAdapter> mProtoAdapter = new ConcurrentHashMap<Class<? extends AndroidMessage>, ProtoAdapter>();
    private static long mSeq = System.currentTimeMillis();

    @Nullable
    public static InnerV2 parseInner(@NonNull byte[] bs) {
        if (bs.length == 0) {
            return null;
        }
        InnerV2 inner = null;
        try {
            byte[] copyBs = Arrays.copyOf(bs, bs.length);
            inner = (InnerV2)((Object)InnerV2.ADAPTER.decode(copyBs));
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return inner;
    }

    @Nullable
    public static InnerV3 parseInnerV3(@NonNull byte[] bs) {
        if (bs.length == 0) {
            return null;
        }
        InnerV3 inner = null;
        try {
            byte[] copyBs = Arrays.copyOf(bs, bs.length);
            inner = (InnerV3)((Object)InnerV3.ADAPTER.decode(copyBs));
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return inner;
    }

    public static String headerString(Header header) {
        if (header == null) {
            return "header is null";
        }
        return StringUtils.format((String)"name: %s, method: %s, seq: %d, lang: %s, code: %d, version: %s, msgtype: %s, extend: %d", (Object[])new Object[]{header.sname, header.method, header.seqid, header.lang, header.code, header.version, header.msgtype, header.extend.size()});
    }

    public static String innerString(InnerV2 inner) {
        if (inner == null) {
            return "inner: null";
        }
        Header header = inner.header;
        if (header == null) {
            return StringUtils.formatWitUSLocal((String)"header is null, uri: %d", (Object[])new Object[]{inner.uri});
        }
        return StringUtils.format((String)"name: %s, method: %s, uri: %d, seq: %d, lang: %s, code: %d, version: %s, msgtype: %s, roomId: %s, extend: %d", (Object[])new Object[]{header.sname, header.method, inner.uri, header.seqid, header.lang, header.code, header.version, header.msgtype, header.roomid, header.extend.size()});
    }

    public static synchronized long uniqueSeq() {
        long cur = System.currentTimeMillis();
        mSeq = cur > mSeq ? cur : ++mSeq;
        return mSeq;
    }

    public static Header getHeader(String sName) {
        return ProtoUtils.getHeaderBuilder(sName, false).build();
    }

    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> RpcMethod<REQ, RES> checkResType(REQ req, IProtoCallback<RES> callback) {
        Class<RES> type;
        RpcMethod<REQ, RES> method = ProtoUtils.getRpcMethod(req);
        if (callback != null && (type = ProtoUtils.getResType(callback)) != null && type != method.res) {
            throw new IllegalArgumentException("\u68c0\u67e5\u4f60\u7684\u8bf7\u6c42res\u548c\u54cd\u5e94res\u662f\u5426\u662f\u5bf9\u5e94\u5173\u7cfb type:" + type + ",method.res" + method.res);
        }
        if (RuntimeContext.sIsDebuggable || SystemUtils.isShowEnvSetting()) {
            WireEnumCheckHelper.check(req);
        }
        return method;
    }

    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> RpcMethod<REQ, RES> getRpcMethod(REQ req) {
        if (HomeRpcSet.IS_ENABLE.booleanValue()) {
            RpcMethod method = HomeRpcSet.getRpcMethod(req.getClass());
            if (method == null) {
                method = RpcSet.getRpcMethod(req.getClass());
            }
            return method;
        }
        return RpcSet.getRpcMethod(req.getClass());
    }

    public static <RES extends AndroidMessage<RES, ?>> Class<RES> getResType(IProtoCallback<RES> callback) {
        ParameterizedType pt = (ParameterizedType)ProtoUtils.getInterfaceType(callback, IProtoCallback.class);
        Class type = pt != null && pt.getActualTypeArguments()[0] instanceof Class ? (Class)pt.getActualTypeArguments()[0] : null;
        return type;
    }

    public static Header.Builder getHeaderBuilder(String sName, boolean v2) {
        Header.Builder builder = new Header.Builder().code(0L).seqid(ProtoUtils.uniqueSeq()).lang(SystemUtils.getLangAndCountry()).back_ground(!RuntimeContext.sIsForeground).sname(sName);
        ByteString byteString = RouteTransmission.getCproxyRoutingKey(sName);
        if (byteString != null) {
            builder.routing_key(byteString);
        }
        if (v2) {
            builder.msgtype(Header.MSGTYPE.MSGTYPE_REQ).version("0.0.0");
        }
        return builder;
    }

    private static GeneratedMessageLite reflectProtoInstance(Class<? extends GeneratedMessageLite> cls) {
        try {
            Method method = cls.getDeclaredMethod("getDefaultInstance", new Class[0]);
            return (GeneratedMessageLite)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"reflectProtoInstance className: %s", (Throwable)e, (Object[])new Object[]{cls});
            return null;
        }
    }

    public static <T> Type getInterfaceType(T inter, Class<T> cls) {
        for (Type type : inter.getClass().getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != cls) continue;
            return type;
        }
        Type type = inter.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && cls.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
            return type;
        }
        return null;
    }

    public static <T extends GeneratedMessageLite<T, ?>> T parseBytes(T defaultInstance, byte[] data) {
        try {
            return ProtoUtils._parseBytes(defaultInstance, data);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public static boolean isResultRes(RpcMethod rpcMethod) {
        return rpcMethod != null && rpcMethod.protoVersion == 21000;
    }

    public static boolean isResultLegal(Response resultRes) {
        return resultRes != null && resultRes.result != null && resultRes.result.magic == 1214343023L;
    }

    public static String resultString(Response resultRes) {
        Result result;
        return resultRes == null || (result = resultRes.result) == null ? "null" : StringUtils.formatWitUSLocal((String)"Common.Result{errcode: %d, errmsg: %s, magic: %d}", (Object[])new Object[]{result.errcode, result.errmsg, result.magic});
    }

    private static <T extends GeneratedMessageLite<T, ?>> T _parseBytes(T defaultInstance, byte[] data) {
        return ProtoUtils.invokeParse(defaultInstance, data);
    }

    private static <T extends GeneratedMessageLite<T, ?>> T invokeParse(T defaultInstance, byte[] data) {
        GeneratedMessageLite result = null;
        try {
            Class<?> testClass = defaultInstance.getClass();
            Method parseFrom = testClass.getMethod("parseFrom", byte[].class);
            result = (GeneratedMessageLite)parseFrom.invoke(null, new Object[]{data});
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return (T)result;
    }

    public static <T extends AndroidMessage<T, ?>> T parseBytes(ProtoAdapter<T> adapter, byte[] data) {
        try {
            return (T)((AndroidMessage)adapter.decode(data));
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> ProtoAdapter<RES> getResProtoAdapter(REQ req) {
        RpcMethod<REQ, RES> method = ProtoUtils.getRpcMethod(req);
        return method.resAdapter;
    }

    public static <T extends AndroidMessage> ProtoAdapter<T> getProtoAdapter(Class<T> cls) {
        if (cls == null) {
            return null;
        }
        if (mProtoAdapter.containsKey(cls)) {
            return mProtoAdapter.get(cls);
        }
        ProtoAdapter proto = null;
        try {
            proto = ProtoAdapter.get(cls);
            mProtoAdapter.put(cls, proto);
        }
        catch (Exception e) {
            if (RuntimeContext.sIsDebuggable) {
                throw e;
            }
            MLog.error((Object)TAG, (Throwable)e);
        }
        return proto;
    }

    public static <T> AndroidMessage parsePbBytes(T msg, Class<T> cls, byte[] bytes) {
        try {
            ParameterizedType pt = (ParameterizedType)ProtoUtils.getInterfaceType(msg, cls);
            Class type = (Class)pt.getActualTypeArguments()[0];
            ProtoAdapter<T> proto = ProtoUtils.getProtoAdapter(type);
            if (proto != null) {
                return ProtoUtils.parseBytes(proto, bytes);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return null;
    }
}

